/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.ITrainer;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenQuestChooseScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public abstract class TrainerEntity
extends OPEntity
implements ITrainer {
    public TrainerEntity(EntityType type, World world) {
        this(type, world, null);
    }

    public TrainerEntity(EntityType type, World world, ResourceLocation[] textures) {
        super(type, world, textures);
    }

    public void func_184651_r() {
        super.func_184651_r();
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setFaction("civilian");
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return true;
    }

    @Override
    public boolean func_213397_c(double distance) {
        return super.func_213397_c(distance) && distance > 1024.0;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151057_cb) {
            return ActionResultType.FAIL;
        }
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SOpenQuestChooseScreenPacket(this.func_145782_y(), WyHelper.isInCombat((LivingEntity)player)), player);
            if (this instanceof IHakiTrainer) {
                WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), HakiDataCapability.get((LivingEntity)player)), player);
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }
}

