/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities.revenge;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.IRevengeCheck;

public class RevengeMeter {
    private static final int QUEUE_ENTRIES = 20;
    private LivingEntity entity;
    private int revengeValue;
    private int prevRevengeValue;
    private int maxRevengeValue = 100;
    private int decreasingValue = 1;
    private boolean canClear;
    private List<IRevengeCheck> checks = new ArrayList<IRevengeCheck>();
    private Map<Class<? extends IRevengeCheck>, Integer> passedChecksTotal = new HashMap<Class<? extends IRevengeCheck>, Integer>();
    private Queue<IRevengeCheck> passedChecksHistory = EvictingQueue.create((int)20);

    public RevengeMeter(LivingEntity entity, int maxRevenge, int decreasingValue) {
        this.entity = entity;
        this.maxRevengeValue = maxRevenge;
        this.decreasingValue = decreasingValue;
    }

    public void addCheck(IRevengeCheck check) {
        this.checks.add(check);
    }

    public void tick() {
        if (this.entity.field_70170_p.func_82737_E() % 40L == 0L) {
            int checksPassed = 0;
            for (IRevengeCheck check : this.checks) {
                if (!check.check(this.entity)) continue;
                this.addRevengeValue(check.revengeMeterGain());
                this.passedChecksHistory.add(check);
                Integer checksMapVal = this.passedChecksTotal.get(check.getClass());
                if (checksMapVal == null) {
                    this.passedChecksTotal.put(check.getClass(), 1);
                } else {
                    this.passedChecksTotal.put(check.getClass(), checksMapVal + 1);
                }
                ++checksPassed;
                this.canClear = true;
            }
            if (checksPassed == 0) {
                this.reduceRevengeValue(this.decreasingValue);
            }
            if (this.revengeValue <= 0 && this.canClear) {
                this.passedChecksTotal.clear();
                this.passedChecksHistory.clear();
                this.canClear = false;
            }
        }
    }

    public Map<Class<? extends IRevengeCheck>, Integer> getLastChecksMap() {
        return this.passedChecksTotal;
    }

    public Queue<IRevengeCheck> getLastChecks() {
        return this.passedChecksHistory;
    }

    public boolean isCheckPresentInLastNEntries(Class<? extends IRevengeCheck> clz, int entriesToCheck, int neededEntries) {
        if (this.passedChecksHistory.isEmpty()) {
            return false;
        }
        entriesToCheck = Math.min(entriesToCheck, this.passedChecksHistory.size());
        entriesToCheck = Math.max(0, this.passedChecksHistory.size() - entriesToCheck);
        long count = this.passedChecksHistory.stream().skip(entriesToCheck).filter(c -> c.getClass().equals(clz)).count();
        return count >= (long)neededEntries;
    }

    public int countCheckTriggers(Class<? extends IRevengeCheck> clz) {
        return this.getLastChecksMap().getOrDefault(clz, 0);
    }

    public void resetMarkers() {
        this.revengeValue = 0;
        this.checks.forEach(check -> check.resetMarkers());
    }

    public boolean isRevengeMaxed() {
        return this.getRevengePercentage() >= 1.0f;
    }

    public boolean isRevengeAbove(float percentage) {
        return this.getRevengePercentage() > percentage;
    }

    public boolean isRevengeUnder(float percentage) {
        return this.getRevengePercentage() < percentage;
    }

    public int getRevengeValue() {
        return MathHelper.func_76125_a((int)this.revengeValue, (int)0, (int)this.maxRevengeValue);
    }

    public void addRevengeValue(int value) {
        this.setRevengeValue(this.revengeValue + value);
    }

    public void reduceRevengeValue(int value) {
        this.setRevengeValue(this.revengeValue - value);
    }

    public void setRevengeValue(int value) {
        this.prevRevengeValue = this.revengeValue;
        this.revengeValue = MathHelper.func_76125_a((int)value, (int)0, (int)this.maxRevengeValue);
    }

    public float getRevengePercentage() {
        return (float)this.getRevengeValue() / (float)this.maxRevengeValue;
    }
}

