/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.LogiaInvulnerabilityAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiFutureSightAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.SparClawAbility;
import xyz.pixelatedw.mineminenomi.api.ReferenceTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.OutOfBodyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireAbilityComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.effects.IBindHandsEffect;
import xyz.pixelatedw.mineminenomi.api.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.api.events.ability.UnlockAbilityEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.effects.CaughtInNetEffect;
import xyz.pixelatedw.mineminenomi.effects.GuardingEffect;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MorganEntity;
import xyz.pixelatedw.mineminenomi.events.abilities.OutOfBodyAbilitiesEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.items.weapons.ModSwordItem;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SDisableAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.GuardParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class AbilityHelper {
    public static final int CLOUD_HEIGHT = 128;
    public static final ArrayList<SourceType> NO_SOURCE_TYPE = new ArrayList<SourceType>(Arrays.asList(SourceType.UNKNOWN));
    private static final Object[] EMPTY_ARGS = new Object[0];
    public static final Function<PlayerEntity, ResourceLocation> DF_CATEGORY_ICON = player -> {
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        ResourceLocation icon = null;
        if (props.hasAnyDevilFruit()) {
            ResourceLocation res = props.hasYamiPower() ? ModAbilities.YAMI_YAMI_NO_MI.getRegistryName() : props.getDevilFruit().orElse(ModValues.NIL_LOCATION);
            if (ClientConfig.INSTANCE.isGoroBlue() && res.toString().equals("mineminenomi:goro_goro_no_mi")) {
                res = new ResourceLocation("mineminenomi", "goro_goro_no_mi_blue");
            }
            icon = new ResourceLocation(res.func_110624_b(), "textures/items/" + res.func_110623_a() + ".png");
        }
        return icon;
    };
    public static final Function<PlayerEntity, ResourceLocation> RACE_CATEGORY_ICON = player -> {
        String iconName = null;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.isHuman()) {
            iconName = "human-rokushiki";
        } else if (props.isFishman()) {
            iconName = "fishman-karate";
        } else if (props.isCyborg()) {
            iconName = "cyborg-abilities";
        } else if (props.isMink()) {
            iconName = "mink-electro";
        }
        if (iconName != null) {
            return new ResourceLocation("mineminenomi", "textures/gui/icons/" + iconName + ".png");
        }
        return null;
    };
    public static final Function<PlayerEntity, ResourceLocation> HAKI_CATEGORY_ICON = player -> {
        float haoLevel = HakiDataCapability.get((LivingEntity)player).getTotalHakiExp() / 100.0f;
        String id = "haoshoku_haki";
        String level = "0";
        if (haoLevel > 1.0f && (double)haoLevel <= 1.75) {
            level = "1";
        } else if ((double)haoLevel > 1.75) {
            level = "2";
        }
        return new ResourceLocation("mineminenomi", "textures/abilities/" + id + "_" + level + ".png");
    };
    public static final Predicate<Entity> HAS_LOGIA_INVULNERABILITY = entity -> {
        boolean isNotSpectating = EntityPredicates.field_180132_d.test(entity);
        boolean isLogia = false;
        if (entity instanceof LivingEntity) {
            IDevilFruit props = DevilFruitCapability.get((LivingEntity)entity);
            isLogia = props.isLogia() && !props.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI);
        }
        return isNotSpectating && isLogia;
    };
    public static final Style MENTION_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN);

    public static AbilityDescriptionLine.IDescriptionLine createShortLongCooldownStat(float shortCooldown, float longCooldown) {
        return (entity, ability) -> {
            TranslationTextComponent secondsStackUnit = new TranslationTextComponent("%s %s", new Object[]{ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_SECONDS.getString(), ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_PER_STACK.getString()});
            float shortCooldownSeconds = shortCooldown / 20.0f;
            float longCooldownSeconds = longCooldown / 20.0f;
            AbilityStat.Builder shortStatBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_SHORT_COOLDOWN, shortCooldownSeconds).withUnit((ITextComponent)secondsStackUnit);
            AbilityStat.Builder longStatBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_LONG_COOLDOWN, longCooldownSeconds).withUnit((ITextComponent)secondsStackUnit);
            ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> {
                float shortBonus = comp.getBonusManager().applyBonus(shortCooldownSeconds) - shortCooldownSeconds;
                AbilityStat.AbilityStatType shortBonusType = shortBonus < 0.0f ? AbilityStat.AbilityStatType.BUFF : (shortBonus > 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                shortStatBuilder.withBonus(shortBonus, shortBonusType);
                float longBonus = comp.getBonusManager().applyBonus(longCooldownSeconds) - longCooldownSeconds;
                AbilityStat.AbilityStatType longBonusType = longBonus < 0.0f ? AbilityStat.AbilityStatType.BUFF : (longBonus > 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                longStatBuilder.withBonus(longBonus, longBonusType);
            });
            ITextComponent shortStat = shortStatBuilder.build().getStatDescription();
            ITextComponent longStat = longStatBuilder.build().getStatDescription();
            StringBuilder sb = new StringBuilder();
            sb.append(shortStat.getString() + "\n");
            sb.append(longStat.getString());
            return new StringTextComponent(sb.toString());
        };
    }

    @Nullable
    public static IFormattableTextComponent tryParseAndMention(RegistryObject<? extends IForgeRegistryEntry<?>> obj) {
        if (!obj.isPresent()) {
            return null;
        }
        return AbilityHelper.mentionEntry(obj.get());
    }

    private static IFormattableTextComponent mentionEntry(IForgeRegistryEntry<?> entry) {
        if (entry instanceof AbilityCore) {
            return AbilityHelper.mentionAbility((AbilityCore)entry);
        }
        if (entry instanceof Item) {
            return AbilityHelper.mentionItem((Item)entry);
        }
        if (entry instanceof Effect) {
            return AbilityHelper.mentionEffect((Effect)entry);
        }
        if (entry instanceof MorphInfo) {
            return AbilityHelper.mentionMorph((MorphInfo)entry);
        }
        return null;
    }

    public static IFormattableTextComponent mentionAbility(AbilityCore<?> core) {
        return core.getLocalizedName().func_230532_e_().func_230530_a_(MENTION_STYLE);
    }

    public static IFormattableTextComponent mentionMorph(MorphInfo info) {
        return new StringTextComponent(info.getDisplayName()).func_230532_e_().func_230530_a_(MENTION_STYLE);
    }

    public static IFormattableTextComponent mentionItem(Item item) {
        TranslationTextComponent comp = new TranslationTextComponent(item.func_77658_a());
        return comp.func_230530_a_(MENTION_STYLE);
    }

    public static IFormattableTextComponent mentionEffect(Effect effect) {
        return effect.func_199286_c().func_230532_e_().func_230530_a_(MENTION_STYLE);
    }

    public static IFormattableTextComponent mentionText(Object text) {
        if (text instanceof ITextComponent) {
            return ((ITextComponent)text).func_230532_e_().func_230530_a_(MENTION_STYLE);
        }
        return new StringTextComponent(text.toString()).func_230530_a_(MENTION_STYLE);
    }

    public static IFormattableTextComponent[] registerDescriptionText(String modid, String abilityName, Pair<String, Object[]> ... pairs) {
        IFormattableTextComponent[] components = new IFormattableTextComponent[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            String key = String.format("ability.%s.%s.description.%s", modid, abilityName, i);
            key = WyRegistry.registerName(key, (String)pairs[i].getKey());
            Object[] args = (Object[])pairs[i].getValue();
            if (args != null) {
                for (int j = 0; j < args.length; ++j) {
                    Object o = args[j];
                    if (o instanceof RegistryObject) {
                        args[j] = new ReferenceTextComponent((RegistryObject)o);
                        continue;
                    }
                    if (!(o instanceof IForgeRegistryEntry)) continue;
                    args[j] = AbilityHelper.mentionEntry((IForgeRegistryEntry)o);
                }
            } else {
                args = EMPTY_ARGS;
            }
            TranslationTextComponent comp = new TranslationTextComponent(key, args);
            components[i] = comp;
        }
        return components;
    }

    public static void setSecondsOnFireBy(Entity entity, int seconds, @Nullable LivingEntity attacker) {
        SetOnFireEvent event = new SetOnFireEvent(attacker, entity, seconds);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            entity.func_70015_d(event.getFireTime());
        }
    }

    public static void emergencyStopAbility(LivingEntity entity, IAbility ability) {
        ability.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> {
            if (comp.isContinuous()) {
                comp.stopContinuity(entity);
            }
        });
        ability.getComponent(ModAbilityKeys.CHARGE).ifPresent(comp -> {
            if (comp.isCharging()) {
                comp.forceStopCharging(entity);
                ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(cooldownComp -> cooldownComp.startCooldown(entity, 40.0f));
            }
        });
        ability.getComponent(ModAbilityKeys.ANIMATION).ifPresent(comp -> comp.stop(entity));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean showAbilityAdvancedTooltips() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71474_y.field_82882_x;
    }

    public static boolean checkValidAbility(LivingEntity entity, AbilityCore<?> core) {
        IAbilityData props = AbilityDataCapability.get(entity);
        boolean isAbilityUnlocked = props.hasUnlockedAbility(core);
        boolean isAbilityBanned = CommonConfig.INSTANCE.isAbilityFraudChecksEnabled() && AbilityHelper.verifyIfAbilityIsBanned(core);
        boolean canUnlock = core.canUnlock(entity);
        UnlockAbilityEvent event = new UnlockAbilityEvent(entity, core);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW) {
            canUnlock = true;
        } else if (event.getResult() == Event.Result.DENY) {
            canUnlock = false;
        }
        if (isAbilityUnlocked && props.getUnlockTypeForAbility(core) == AbilityUnlock.PROGRESSION && !canUnlock) {
            return false;
        }
        return !isAbilityBanned;
    }

    public static boolean checkAndUnlockAbility(LivingEntity entity, AbilityCore<?> core) {
        IAbilityData props = AbilityDataCapability.get(entity);
        boolean hasAbilityUnlocked = props.hasUnlockedAbility(core);
        boolean isAbilityBanned = CommonConfig.INSTANCE.isAbilityFraudChecksEnabled() && AbilityHelper.verifyIfAbilityIsBanned(core);
        boolean canUnlock = core.canUnlock(entity);
        UnlockAbilityEvent event = new UnlockAbilityEvent(entity, core);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW) {
            canUnlock = true;
        } else if (event.getResult() == Event.Result.DENY) {
            canUnlock = false;
        }
        if (hasAbilityUnlocked) {
            if (isAbilityBanned) {
                props.removeUnlockedAbility(core);
                return true;
            }
            if (!canUnlock) {
                AbilityUnlock unlockType = props.getUnlockTypeForAbility(core);
                if (props.hasUnlockedAbility(core) && unlockType == AbilityUnlock.PROGRESSION) {
                    props.removeUnlockedAbility(core);
                    return true;
                }
            }
            return false;
        }
        if (!isAbilityBanned && canUnlock) {
            props.addUnlockedAbility(core, AbilityUnlock.PROGRESSION);
            return true;
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static AnimationComponent getActiveAnimation(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        if (abilityProps == null) {
            return null;
        }
        ArrayList abilities = new ArrayList();
        abilities.addAll(ImmutableList.copyOf(abilityProps.getEquippedAbilities()));
        abilities.addAll(ImmutableList.copyOf(abilityProps.getPassiveAbilities()));
        Optional<AnimationComponent> animComp = abilities.stream().filter(ability -> {
            if (!ability.hasComponent(ModAbilityKeys.ANIMATION)) {
                return false;
            }
            AnimationComponent comp = ability.getComponent(ModAbilityKeys.ANIMATION).get();
            if (comp == null) {
                return false;
            }
            return comp.isPlaying();
        }).map(a -> a.getComponent(ModAbilityKeys.ANIMATION).get()).findFirst();
        return animComp.orElse(null);
    }

    public static void enableAbilities(LivingEntity entity, Predicate<IAbility> check) {
        IAbilityData abilityData = AbilityDataCapability.get(entity);
        List abilities = abilityData.getEquippedAndPassiveAbilities().stream().filter(ability -> check.test((IAbility)ability)).collect(Collectors.toList());
        HashSet<IAbility> markedAbilities = new HashSet<IAbility>();
        for (IAbility ability2 : abilities) {
            ability2.getComponent(ModAbilityKeys.DISABLE).ifPresent(component -> {
                component.stopDisable(entity);
                markedAbilities.add(ability2);
            });
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SDisableAbilityPacket(entity.func_145782_y(), markedAbilities, 0, false), entity);
        }
    }

    public static void disableAbilities(LivingEntity entity, int duration, Predicate<IAbility> check) {
        IAbilityData abilityData = AbilityDataCapability.get(entity);
        List abilities = abilityData.getEquippedAndPassiveAbilities().stream().filter(ability -> check.test((IAbility)ability)).collect(Collectors.toList());
        HashSet<IAbility> markedAbilities = new HashSet<IAbility>();
        for (IAbility ability2 : abilities) {
            ability2.getComponent(ModAbilityKeys.DISABLE).ifPresent(component -> {
                AbilityHelper.emergencyStopAbility(entity, ability2);
                component.stopDisable(entity);
                component.startDisable(entity, duration);
                markedAbilities.add(ability2);
            });
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SDisableAbilityPacket(entity.func_145782_y(), markedAbilities, duration, true), entity);
        }
    }

    public static boolean canUseMomentumAbilities(LivingEntity entity) {
        boolean canJump = entity.func_110148_a((Attribute)ModAttributes.JUMP_HEIGHT.get()).func_111126_e() > 0.0;
        boolean canMove = entity.func_110148_a(Attributes.field_233821_d_).func_111126_e() > 0.0;
        return canJump && canMove;
    }

    @Nullable
    public static AbilityOverlay getCurrentOverlay(PlayerEntity player) {
        AbilityOverlay overlay = null;
        Set list = AbilityDataCapability.get((LivingEntity)player).getEquippedAbilities();
        for (Ability ability : list) {
            if (ability == null || ability instanceof ContinuousAbility && !ability.isContinuous()) continue;
            if (ability instanceof IPunchOverlayAbility) {
                overlay = ((IPunchOverlayAbility)((Object)ability)).getPunchOverlay((LivingEntity)player);
                continue;
            }
            if (!(ability instanceof IBodyOverlayAbility)) continue;
            overlay = ((IBodyOverlayAbility)((Object)ability)).getBodyOverlay((LivingEntity)player);
        }
        return overlay;
    }

    public static boolean canPlaceBlock(World world, double posX, double posY, double posZ, BlockState toPlace, int flag, BlockProtectionRule rule) {
        BlockPos pos = new BlockPos(posX, posY, posZ);
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        BlockState currentBlockState = world.func_180495_p(pos);
        ProtectedAreasData worldData = ProtectedAreasData.get(world);
        ProtectedArea area = worldData.getProtectedArea((int)posX, (int)posY, (int)posZ);
        boolean isGriefDisabled = !CommonConfig.INSTANCE.isAbilityGriefingEnabled();
        boolean isGriefBypass = rule.getBypassGriefRule();
        if (!isGriefBypass) {
            if (isGriefDisabled) {
                return false;
            }
            if (area != null && !area.canDestroyBlocks()) {
                return false;
            }
        }
        return rule.check(world, pos, currentBlockState);
    }

    public static boolean canMobGrief(@Nullable Entity entity) {
        if (entity == null) {
            return true;
        }
        if (entity instanceof MobEntity) {
            if (WyHelper.isInChallengeDimension(entity.field_70170_p)) {
                return true;
            }
            return ForgeEventFactory.getMobGriefingEvent((World)entity.field_70170_p, (Entity)entity);
        }
        if (!(entity instanceof PlayerEntity)) {
            return ForgeEventFactory.getMobGriefingEvent((World)entity.field_70170_p, (Entity)entity);
        }
        return true;
    }

    public static boolean placeBlockIfAllowed(LivingEntity entity, BlockPos pos, BlockState toPlace, @Nullable BlockProtectionRule rule) {
        return AbilityHelper.placeBlockIfAllowed(entity, pos, toPlace, 2, rule);
    }

    public static boolean placeBlockIfAllowed(LivingEntity entity, BlockPos pos, BlockState toPlace, int flag, @Nullable BlockProtectionRule rule) {
        if (entity == null) {
            return false;
        }
        if (!AbilityHelper.canMobGrief((Entity)entity)) {
            return false;
        }
        return AbilityHelper.placeBlockIfAllowed(entity.field_70170_p, pos, toPlace, flag, rule);
    }

    public static boolean placeBlockIfAllowed(World world, BlockPos pos, Block toPlace, int flag, BlockProtectionRule rule) {
        return AbilityHelper.placeBlockIfAllowed(world, pos, toPlace.func_176223_P(), flag, rule);
    }

    public static boolean placeBlockIfAllowed(World world, BlockPos pos, Block toPlace, BlockProtectionRule rule) {
        return AbilityHelper.placeBlockIfAllowed(world, pos, toPlace.func_176223_P(), 2, rule);
    }

    public static boolean placeBlockIfAllowed(World world, BlockPos pos, BlockState toPlace, int flag, @Nullable BlockProtectionRule rule) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        if (!toPlace.func_196958_f() && !AbilityHelper.isWithinChallengeArenaBounds(world, pos)) {
            return false;
        }
        BlockState currentBlockState = world.func_180495_p(pos);
        ProtectedAreasData worldData = ProtectedAreasData.get(world);
        if (worldData == null) {
            return false;
        }
        ProtectedArea area = worldData.getProtectedArea(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        boolean isGriefDisabled = !CommonConfig.INSTANCE.isAbilityGriefingEnabled();
        boolean isGriefBypass = false;
        boolean canPlace = !RestrictedBlockProtectionRule.INSTANCE.check(world, pos, currentBlockState);
        boolean canActuallyPlace = true;
        if (rule != null) {
            isGriefBypass = rule.getBypassGriefRule();
            canPlace = rule.check(world, pos, currentBlockState);
            boolean bl = canActuallyPlace = !rule.getCoordsOnly();
        }
        if (WyHelper.isInChallengeDimension(world)) {
            isGriefBypass = true;
            isGriefDisabled = false;
        }
        if (!isGriefBypass) {
            if (isGriefDisabled) {
                return false;
            }
            if (area != null) {
                if (!area.canDestroyBlocks()) {
                    return false;
                }
                if (area.canDestroyBlocks() && area.canRestoreBlocks()) {
                    int hash = pos.func_177956_o() * 31 + pos.func_177952_p() + pos.func_177958_n();
                    BlockPlacingHelper.DistanceBlockPos pos2 = new BlockPlacingHelper.DistanceBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), hash);
                    BlockSnapshot snapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos, (int)2);
                    area.queueForRestoration(pos2, new ProtectedArea.RestorationEntry(world.func_82737_E(), snapshot));
                }
            }
        }
        if (canPlace) {
            if (canActuallyPlace) {
                WyHelper.setBlockStateInChunk(world, pos, toPlace, flag);
            }
            return true;
        }
        return false;
    }

    private static boolean isWithinChallengeArenaBounds(World world, BlockPos pos) {
        if (!WyHelper.isInChallengeDimension(world)) {
            return true;
        }
        if (world.field_72995_K) {
            return false;
        }
        ServerWorld sworld = (ServerWorld)world;
        InProgressChallenge ch = ChallengesWorldData.get().getInProgressChallengeFor(sworld);
        MutableBoundingBox mbb = ch.getArena().getArenaLimits();
        mbb.field_78897_a -= 4;
        mbb.field_78895_b -= 4;
        mbb.field_78896_c -= 4;
        mbb.field_78893_d += 3;
        mbb.field_78894_e += 3;
        mbb.field_78892_f += 3;
        mbb.func_236989_a_((Vector3i)ch.getArenaPos());
        return mbb.func_175898_b((Vector3i)pos);
    }

    public static List<BlockPos> createEmptyCube(Entity entity, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, BlockProtectionRule rule) {
        return AbilityHelper.createEmptyCube(entity, posX, posY, posZ, sizeX, sizeY, sizeZ, 2, blockToPlace, rule);
    }

    public static List<BlockPos> createEmptyCube(Entity entity, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, int flags, Block blockToPlace, BlockProtectionRule rule) {
        if (!AbilityHelper.canMobGrief(entity)) {
            return new ArrayList<BlockPos>();
        }
        return AbilityHelper.createEmptyCube(entity.field_70170_p, posX, posY, posZ, sizeX, sizeY, sizeZ, flags, blockToPlace, rule);
    }

    public static List<BlockPos> createEmptyCube(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, BlockProtectionRule rule) {
        return AbilityHelper.createEmptyCube(world, posX, posY, posZ, sizeX, sizeY, sizeZ, 2, blockToPlace, rule);
    }

    public static List<BlockPos> createEmptyCube(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, int flags, Block blockToPlace, BlockProtectionRule rule) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                for (int z = -sizeZ; z <= sizeZ; ++z) {
                    if (x != -sizeX && x != sizeX && y != -sizeY && y != sizeY && z != -sizeZ && z != sizeZ) continue;
                    mutpos.func_189532_c(posX + (double)x, posY + (double)y, posZ + (double)z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, blockToPlace, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createFilledCube(Entity entity, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, BlockProtectionRule rule) {
        return AbilityHelper.createFilledCube(entity, posX, posY, posZ, sizeX, sizeY, sizeZ, blockToPlace, 2, rule);
    }

    public static List<BlockPos> createFilledCube(Entity entity, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, int flags, BlockProtectionRule rule) {
        if (!AbilityHelper.canMobGrief(entity)) {
            return new ArrayList<BlockPos>();
        }
        return AbilityHelper.createFilledCube(entity.field_70170_p, posX, posY, posZ, sizeX, sizeY, sizeZ, blockToPlace, flags, rule);
    }

    public static List<BlockPos> createFilledCube(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, BlockProtectionRule rule) {
        return AbilityHelper.createFilledCube(world, posX, posY, posZ, sizeX, sizeY, sizeZ, blockToPlace, 2, rule);
    }

    public static List<BlockPos> createFilledCube(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, int flag, BlockProtectionRule rule) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                for (int z = -sizeZ; z <= sizeZ; ++z) {
                    mutpos.func_189532_c(posX + (double)x, posY + (double)y, posZ + (double)z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, blockToPlace, flag, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createSphereWithProtection(Entity entity, BlockPos center, int radiusXZ, int radiusY, Block block, int flags, BlockProtectionRule rule) {
        if (!AbilityHelper.canMobGrief(entity)) {
            return new ArrayList<BlockPos>();
        }
        return AbilityHelper.createSphereWithProtection(entity.field_70170_p, center, radiusXZ, radiusY, block, flags, rule);
    }

    public static List<BlockPos> createSphereWithProtection(World world, BlockPos center, int radiusXZ, int radiusY, Block block, int flags, BlockProtectionRule rule) {
        int x0 = center.func_177958_n();
        int y0 = center.func_177956_o();
        int z0 = center.func_177952_p();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int y = y0 - radiusY; y <= y0 + radiusY; ++y) {
            for (int x = x0 - radiusXZ; x <= x0 + radiusXZ; ++x) {
                for (int z = z0 - radiusXZ; z <= z0 + radiusXZ; ++z) {
                    boolean fallingProtection;
                    double distance = (x0 - x) * (x0 - x) + (z0 - z) * (z0 - z) + (y0 - y) * (y0 - y);
                    if (!(distance < (double)(radiusXZ * radiusY))) continue;
                    mutpos.func_181079_c(x, y, z);
                    int posDifference = center.func_177956_o() - mutpos.func_177956_o();
                    boolean bl = fallingProtection = Math.sqrt(mutpos.func_177951_i((Vector3i)center.func_177979_c(posDifference))) > 2.5;
                    if (!fallingProtection || !AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, block, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createSphere(Entity entity, BlockPos center, int radiusXZ, boolean hollow, Block block, int flags, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(entity, center, radiusXZ, radiusXZ, hollow, block, flags, rule);
    }

    public static List<BlockPos> createSphere(Entity entity, BlockPos center, int radiusXZ, int radiusY, boolean hollow, Block block, int flags, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(entity, center, radiusXZ, radiusY, hollow, block, null, flags, rule);
    }

    public static List<BlockPos> createSphere(Entity entity, BlockPos center, int radiusXZ, int radiusY, boolean hollow, Block block, @Nullable BlockProtectionRule.IReplaceBlockRule replaceTest, int flags, BlockProtectionRule rule) {
        if (!AbilityHelper.canMobGrief(entity)) {
            return new ArrayList<BlockPos>();
        }
        return AbilityHelper.createSphere(entity.field_70170_p, center, radiusXZ, radiusY, hollow, block, replaceTest, flags, rule);
    }

    public static List<BlockPos> createSphere(World world, BlockPos center, int radiusXZ, boolean hollow, Block block, int flags, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(world, center, radiusXZ, radiusXZ, hollow, block, flags, rule);
    }

    public static List<BlockPos> createSphere(World world, BlockPos center, int radiusXZ, int radiusY, boolean hollow, Block block, int flags, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(world, center, radiusXZ, radiusY, hollow, block, null, flags, rule);
    }

    public static List<BlockPos> createSphere(World world, BlockPos center, int radiusXZ, int radiusY, boolean hollow, Block block, @Nullable BlockProtectionRule.IReplaceBlockRule replaceTest, int flags, BlockProtectionRule rule) {
        int x0 = center.func_177958_n();
        int y0 = center.func_177956_o();
        int z0 = center.func_177952_p();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int y = y0 - radiusY; y <= y0 + radiusY; ++y) {
            for (int x = x0 - radiusXZ; x <= x0 + radiusXZ; ++x) {
                for (int z = z0 - radiusXZ; z <= z0 + radiusXZ; ++z) {
                    double distance = (x0 - x) * (x0 - x) + (z0 - z) * (z0 - z) + (y0 - y) * (y0 - y);
                    if (!(distance < (double)(radiusXZ * radiusY)) || hollow && distance < (double)((radiusXZ - 1) * (radiusXZ - 1))) continue;
                    mutpos.func_181079_c(x, y, z);
                    BlockState state = world.func_180495_p((BlockPos)mutpos);
                    if (replaceTest != null && !replaceTest.replace(world, (BlockPos)mutpos, state) || !AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, block, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    @Deprecated
    public static List<BlockPos> createEmptySphere(World world, int posX, int posY, int posZ, int size, Block block, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(world, new BlockPos(posX, posY, posZ), size, true, block, 2, rule);
    }

    @Deprecated
    public static List<BlockPos> createFilledSphere(World world, int posX, int posY, int posZ, int size, Block block, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(world, new BlockPos(posX, posY, posZ), size, false, block, 2, rule);
    }

    public static List<BlockPos> getFilledSpherePositions(World world, double posX, double posY, double posZ, int radiusXZ, int radiusY, BlockState state, int flag, BlockProtectionRule rule) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (double y = posY - (double)radiusY; y <= posY + (double)radiusY; y += 1.0) {
            for (double x = posX - (double)radiusXZ; x <= posX + (double)radiusXZ; x += 1.0) {
                for (double z = posZ - (double)radiusXZ; z <= posZ + (double)radiusXZ; z += 1.0) {
                    double distance = (posX - x) * (posX - x) + (posZ - z) * (posZ - z) + (posY - y) * (posY - y);
                    if (!(distance < (double)(radiusXZ * radiusY))) continue;
                    mutpos.func_189532_c(x, y, z);
                    if (!AbilityHelper.canPlaceBlock(world, mutpos.func_177958_n(), mutpos.func_177956_o(), mutpos.func_177952_p(), state, flag, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> getFilledCubePositions(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, BlockState state, int flag, BlockProtectionRule rule) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int y = -sizeY; y <= sizeY; ++y) {
            for (int x = -sizeX; x <= sizeX; ++x) {
                for (int z = -sizeZ; z <= sizeZ; ++z) {
                    mutpos.func_189532_c(posX + (double)x, posY + (double)y, posZ + (double)z);
                    if (!AbilityHelper.canPlaceBlock(world, mutpos.func_177958_n(), mutpos.func_177956_o(), mutpos.func_177952_p(), state, flag, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static ExplosionAbility newExplosion(Entity entity, World world, double posX, double posY, double posZ, float size) {
        return new ExplosionAbility(entity, world, posX, posY, posZ, size);
    }

    public static boolean canUseBrawlerAbilities(LivingEntity entity) {
        return entity.func_184614_ca().func_190926_b();
    }

    public static boolean canUseSwordsmanAbilities(LivingEntity entity) {
        boolean hasSwordInHand = ItemsHelper.isSword(entity.func_184614_ca());
        if (entity instanceof PlayerEntity) {
            IAbilityData abilityProps = AbilityDataCapability.get(entity);
            Ability sparClawAbility = abilityProps.getEquippedAbility(SparClawAbility.INSTANCE);
            boolean hasSparClaw = sparClawAbility != null && sparClawAbility.isContinuous();
            return hasSwordInHand || hasSparClaw;
        }
        return hasSwordInHand;
    }

    public static boolean isAffectedByWater(LivingEntity entity) {
        return AbilityHelper.isAffectedByWater(entity, 0.5f);
    }

    public static boolean isAffectedByWater(LivingEntity entity, float waterLevel) {
        if (entity.func_175149_v()) {
            return false;
        }
        if (entity.func_70644_a((Effect)ModEffects.BUBBLY_CORAL.get())) {
            return false;
        }
        boolean isUnderDaSea = entity.func_208600_a((ITag)FluidTags.field_206959_a);
        if (isUnderDaSea) {
            return true;
        }
        if (entity.func_184218_aH()) {
            return false;
        }
        FluidState fluidState = entity.field_70170_p.func_204610_c(entity.func_233580_cy_());
        float entityHeight = entity.func_213302_cg();
        int waterLevelCheck = Math.max(1, Math.round(entityHeight * waterLevel));
        boolean isInWater = fluidState.func_206884_a((ITag)FluidTags.field_206959_a);
        if (isInWater) {
            boolean hasWaterUnder = false;
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            for (int i = 0; i <= waterLevelCheck; ++i) {
                mutpos.func_189533_g((Vector3i)entity.func_233580_cy_().func_177979_c(i));
                boolean isWater = entity.field_70170_p.func_204610_c((BlockPos)mutpos).func_206884_a((ITag)FluidTags.field_206959_a);
                if (!isWater) {
                    hasWaterUnder = false;
                    break;
                }
                hasWaterUnder = true;
            }
            if (hasWaterUnder) {
                return true;
            }
        }
        if (fluidState.func_223408_f() < 0.8f && !fluidState.func_206889_d()) {
            return false;
        }
        float waterLevelHeight = entityHeight * waterLevel;
        return entity.func_233571_b_((ITag)FluidTags.field_206959_a) >= (double)waterLevelHeight;
    }

    public static boolean isKairosekiNearby(LivingEntity entity) {
        if (entity.func_175149_v()) {
            return false;
        }
        if (entity.func_70644_a((Effect)ModEffects.BUBBLY_CORAL.get())) {
            return false;
        }
        return WyHelper.isBlockNearby((Entity)entity, 1, state -> state.func_177230_c().func_203417_a(ModTags.Blocks.KAIROSEKI)) || ItemsHelper.hasKairosekiItem(entity);
    }

    public static boolean isWeakenedByKairosekiOrWater(LivingEntity entity) {
        return AbilityHelper.isKairosekiNearby(entity) || AbilityHelper.isAffectedByWater(entity);
    }

    public static boolean verifyIfAbilityIsBanned(AbilityCore core) {
        return CommonConfig.INSTANCE.getBannedAbilities().stream().anyMatch(abl -> abl.equals(core));
    }

    public static Predicate<IAbility> getAbilityFromCategoryPredicate(LivingEntity entity, AbilityCategory category) {
        return ability -> {
            if (AbilityDataCapability.get(entity).getUnlockTypeForAbility(ability.getCore()).equals((Object)AbilityUnlock.COMMAND)) {
                return false;
            }
            return ability.getCore().getCategory().equals((Object)category);
        };
    }

    public static Predicate<AbilityCore> getAbilityCoreFromCategoryPredicate(LivingEntity entity, AbilityCategory category) {
        return core -> {
            if (AbilityDataCapability.get(entity).getUnlockTypeForAbility((AbilityCore)core).equals((Object)AbilityUnlock.COMMAND)) {
                return false;
            }
            return core.getCategory().equals((Object)category);
        };
    }

    public static boolean isInCreativeOrSpectator(@Nullable LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (entity.func_175149_v()) {
            return true;
        }
        return entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_();
    }

    @Deprecated
    public static boolean isTargetBlocking(LivingEntity attacker, LivingEntity target) {
        if (AbilityHelper.isLogiaBlocking((Entity)attacker, target)) {
            return true;
        }
        if (AbilityHelper.isShieldBlocking(target)) {
            return true;
        }
        if (AbilityHelper.isGuardBlocking(target)) {
            return true;
        }
        return AbilityHelper.isDodging(target);
    }

    public static boolean isHakiBlocking(LivingEntity attacker, LivingEntity target) {
        float attackerHakiExp = HakiDataCapability.get(attacker).getTotalHakiExp();
        float targetHakiExp = HakiDataCapability.get(target).getTotalHakiExp();
        if (targetHakiExp < 5.0f) {
            return false;
        }
        float diff = attackerHakiExp - targetHakiExp;
        if (diff < -5.0f) {
            return true;
        }
        if (diff > 5.0f) {
            return false;
        }
        float clampedDiff = MathHelper.func_76131_a((float)diff, (float)0.0f, (float)5.0f);
        float mod = clampedDiff / 400.0f * -1.0f;
        float chance = 0.95f + mod;
        float rand = target.func_70681_au().nextFloat();
        if (rand < chance) {
            attacker.field_70170_p.func_184133_a(null, attacker.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_GUARD.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HAKI_GUARD.get(), (Entity)target, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            return true;
        }
        return false;
    }

    public static boolean isLogiaBlocking(Entity attacker, LivingEntity target) {
        Optional<LogiaInvulnerabilityAbility> logiaAbility;
        boolean hasLogiaDefence;
        EffectInstance inst = target.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get());
        if (inst != null && inst.func_76458_c() > 0) {
            return false;
        }
        if (target.func_70644_a((Effect)ModEffects.KAIROSEKI_WEAKNESS.get()) || target.func_70644_a((Effect)ModEffects.WATER_WEAKNESS.get())) {
            return false;
        }
        boolean hasHardeningActive = false;
        boolean hasKairosekiEffect = false;
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            hasHardeningActive = HakiHelper.hasHardeningActive(livingAttacker);
            for (ItemStack stack : livingAttacker.func_184214_aD()) {
                if (stack.func_190926_b()) continue;
                if (ItemsHelper.isKairosekiWeapon(stack)) {
                    hasKairosekiEffect = true;
                } else {
                    if (!ModTags.Items.KAIROSEKI.func_230235_a_((Object)stack.func_77973_b())) continue;
                    hasKairosekiEffect = true;
                }
                break;
            }
        } else if (ModTags.Entities.KAIROSEKI.func_230235_a_((Object)attacker.func_200600_R())) {
            hasKairosekiEffect = true;
        }
        boolean bl = hasLogiaDefence = (logiaAbility = AbilityDataCapability.get(target).getPassiveAbilities(AbilityCategory.DEVIL_FRUITS.isAbilityPartofCategory()).stream().filter(LogiaInvulnerabilityAbility.class::isInstance).limit(1L).map(LogiaInvulnerabilityAbility.class::cast).filter(a -> !a.isPaused()).findFirst()).isPresent() && !hasHardeningActive && !hasKairosekiEffect;
        if (hasLogiaDefence) {
            logiaAbility.get().spawnParticles(target);
            return true;
        }
        return false;
    }

    public static boolean isShieldBlocking(LivingEntity target) {
        EffectInstance inst = target.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get());
        if (inst != null && inst.func_76458_c() > 0) {
            return false;
        }
        boolean hasShield = target.func_184585_cz();
        if (hasShield) {
            target.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + target.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    public static boolean isGuardBlocking(LivingEntity target) {
        EffectInstance inst = target.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get());
        if (inst != null && inst.func_76458_c() > 0) {
            return false;
        }
        boolean isGuarding = target.func_70651_bq().stream().anyMatch(instance -> instance.func_188419_a() instanceof GuardingEffect);
        if (isGuarding) {
            target.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.GUARD.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            new GuardParticleEffect().spawn(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    public static boolean isDodging(LivingEntity entity) {
        EffectInstance inst = entity.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get());
        if (inst != null && inst.func_76458_c() > 0) {
            return false;
        }
        boolean isDodgingAbilityActive = AbilityHelper.getEquippedAbilitiesPool(entity, AbilityPool.DODGE_ABILITY).stream().anyMatch(ability -> ability.isContinuous()) || AbilityHelper.getEquippedAbilitiesPool(entity, ModAbilityPools.DODGE_ABILITY).stream().anyMatch(ability -> ability.isContinuous());
        return isDodgingAbilityActive;
    }

    @Deprecated
    public static List<Ability> getEquippedAbilitiesPool(LivingEntity entity, AbilityPool pool) {
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        return abilityProps.getEquippedAndPassiveAbilities().stream().filter(ability -> ability instanceof Ability && ((Ability)ability).isInPool(pool)).map(ability -> (Ability)ability).collect(Collectors.toList());
    }

    public static List<Ability> getEquippedAbilitiesPool(LivingEntity entity, AbilityPool2 pool) {
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        return abilityProps.getEquippedAndPassiveAbilities().stream().filter(ability -> ability.hasComponent(ModAbilityKeys.POOL) && ability.getComponent(ModAbilityKeys.POOL).get().containsPool(pool)).map(ability -> (Ability)ability).collect(Collectors.toList());
    }

    public static void addFrostbiteStacks(LivingEntity target, @Nullable LivingEntity attacker, int stacks) {
        EffectInstance frostbite;
        if (target == null) {
            return;
        }
        if (stacks <= 0) {
            stacks = 1;
        }
        if ((frostbite = target.func_70660_b((Effect)ModEffects.FROSTBITE.get())) == null) {
            frostbite = new EffectInstance((Effect)ModEffects.FROSTBITE.get(), 20 * stacks, stacks);
            target.func_195064_c(frostbite);
        } else {
            ((EffectInstanceMixin)frostbite).setDuration(frostbite.func_76459_b() + 20 * stacks);
            ((EffectInstanceMixin)frostbite).setAmplifier(frostbite.func_76458_c() + stacks);
        }
        if (target.func_184102_h() != null) {
            target.func_184102_h().func_184103_al().func_148543_a(null, target.func_213303_ch().field_72450_a, target.func_213303_ch().field_72448_b, target.func_213303_ch().field_72449_c, 100.0, target.func_130014_f_().func_234923_W_(), (IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), frostbite));
        }
    }

    public static void reduceEffect(@Nullable EffectInstance effect, double reduction) {
        if (effect == null) {
            return;
        }
        try {
            double duration = (double)effect.func_76459_b() / reduction;
            ((EffectInstanceMixin)effect).setDuration((int)duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void slowEntityFall(LivingEntity player) {
        AbilityHelper.slowEntityFall(player, 5);
    }

    public static void slowEntityFall(LivingEntity player, int duration) {
        player.func_195064_c(new EffectInstance((Effect)ModEffects.REDUCED_FALL.get(), duration, 0));
    }

    public static void resetSpawnInvulnerability(ServerPlayerEntity player) {
        Field f = ObfuscationReflectionHelper.findField(ServerPlayerEntity.class, (String)"field_147101_bU");
        try {
            f.setInt(player, 0);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isJumping(LivingEntity entity) {
        Field f = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"field_70703_bu");
        try {
            return f.getBoolean(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setPose(LivingEntity entity, Pose pose) {
        Method method = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_213301_b", (Class[])new Class[]{Pose.class});
        try {
            method.setAccessible(true);
            method.invoke((Object)entity, pose);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static LivingEntity canGrab(LivingEntity entity, boolean sendMessage) {
        double reach = Math.sqrt(AttributeHelper.getSquaredAttackRangeDistance(entity, 3.0));
        return AbilityHelper.canGrab(entity, (float)reach, 0.4f, sendMessage);
    }

    @Nullable
    public static LivingEntity canGrab(LivingEntity entity, float distance, float size, boolean sendMessage) {
        Optional opt = TargetHelper.getEntitiesInLine(entity, distance, size, null, LivingEntity.class).stream().findFirst();
        if (opt.isPresent()) {
            LivingEntity target = (LivingEntity)opt.get();
            KenbunshokuHakiFutureSightAbility futureSightAbility = AbilityDataCapability.get(target).getEquippedAbility(KenbunshokuHakiFutureSightAbility.INSTANCE);
            if (target instanceof PlayerEntity && futureSightAbility != null && futureSightAbility.isContinuous()) {
                futureSightAbility.reduceProtection(target, 1.0f);
                return null;
            }
            if (target != null && target.func_70089_S() && !AbilityHelper.isTargetBlocking(entity, target)) {
                return target;
            }
        } else if (sendMessage && !entity.field_70170_p.field_72995_K) {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NO_TARGET), Util.field_240973_b_);
        }
        return null;
    }

    public static boolean canCarry(LivingEntity entity, LivingEntity target) {
        if (entity == null || target == null) {
            return false;
        }
        for (EffectInstance effectInstance : entity.func_70651_bq()) {
            Effect effect = effectInstance.func_188419_a();
            if (!(effect instanceof IBindHandsEffect) || !((IBindHandsEffect)effect).isBlockingSwings()) continue;
            return false;
        }
        Optional<OutOfBodyAbility> oobAbility = OutOfBodyAbilitiesEvents.getOOBAbility(entity);
        if (oobAbility.isPresent()) {
            return false;
        }
        MorphInfo morphInfo = MorphHelper.getZoanInfo(target);
        if (morphInfo != null && !morphInfo.canMount()) {
            return false;
        }
        IEntityStats props = EntityStatsCapability.get(entity);
        if (props.isCarrying() && props.getCarry().equals((Object)target)) {
            if (entity.func_70644_a((Effect)ModEffects.DOA_INVISIBILITY.get())) {
                return true;
            }
        } else if (!target.func_70644_a((Effect)ModEffects.DOA_INVISIBILITY.get()) && entity.func_70644_a((Effect)ModEffects.DOA_INVISIBILITY.get())) {
            return false;
        }
        IDevilFruit devilFruitProps = DevilFruitCapability.get(target);
        for (EffectInstance effectInstance : target.func_70651_bq()) {
            Effect effect = effectInstance.func_188419_a();
            if (devilFruitProps.hasAnyDevilFruit() && effect == ModEffects.WATER_WEAKNESS.get()) {
                return true;
            }
            if (!(effect instanceof CaughtInNetEffect)) continue;
            return true;
        }
        EffectInstance inst = target.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get());
        return inst != null && inst.func_76458_c() > 0;
    }

    public static boolean isCarrying(LivingEntity entity, LivingEntity target) {
        IEntityStats props = EntityStatsCapability.get(entity);
        if (!props.isCarrying()) {
            return false;
        }
        if (props.getCarry() == null || props.getCarry() != target) {
            return false;
        }
        return AbilityHelper.canCarry(entity, target);
    }

    public static AbilityUseResult canUseNPCAbilities(LivingEntity entity, EntityType<?> type) {
        if (entity.func_200600_R().equals(type)) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail(null);
    }

    public static AbilityUseResult canUseWeaponAbilities(LivingEntity entity, IAbility ability) {
        if (entity instanceof MorganEntity) {
            return AbilityUseResult.success();
        }
        if (entity.func_184614_ca().func_190926_b()) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MELEE_WEAPON));
        }
        ItemStack itemStack = entity.func_184614_ca();
        boolean hasSwordInHand = ItemsHelper.isSword(itemStack);
        if (hasSwordInHand) {
            return AbilityUseResult.success();
        }
        if (itemStack.func_77973_b() instanceof ModSwordItem) {
            return AbilityUseResult.success();
        }
        if (itemStack.func_77973_b() instanceof TieredItem) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MELEE_WEAPON));
    }

    public static AbilityUseResult canUseMorphAbility(LivingEntity entity, IAbility ability, MorphInfo ... morphs) {
        for (MorphInfo morph : morphs) {
            if (!morph.isActive(entity)) continue;
            return AbilityUseResult.success();
        }
        TranslationTextComponent failMessage = null;
        if (morphs.length == 1) {
            failMessage = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{ability.getCore().getLocalizedName(), morphs[0].getDisplayName()});
        } else if (morphs.length >= 2) {
            failMessage = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_DOUBLE, new Object[]{ability.getCore().getLocalizedName(), morphs[0].getDisplayName(), morphs[1].getDisplayName()});
        }
        return AbilityUseResult.fail(failMessage);
    }

    public static AbilityUseResult requireAbilityCheck(LivingEntity entity, IAbility ability, RequireAbilityComponent.CheckData<IAbility> ... checks) {
        for (RequireAbilityComponent.CheckData<IAbility> checkData : checks) {
            if (!checkData.checkAbility(entity)) continue;
            return AbilityUseResult.success();
        }
        TranslationTextComponent failMessage = null;
        if (checks.length == 1) {
            failMessage = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{ability.getCore().getLocalizedName(), checks[0].getAbility().getLocalizedName().getString()});
        } else if (checks.length >= 2) {
            failMessage = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_DOUBLE, new Object[]{ability.getCore().getLocalizedName(), checks[0].getAbility().getLocalizedName().getString(), checks[1].getAbility().getLocalizedName().getString()});
        }
        return AbilityUseResult.fail(failMessage);
    }

    public static AbilityUseResult canUseMomentumAbilities(LivingEntity entity, IAbility ability) {
        ModifiableAttributeInstance attr = entity.func_110148_a((Attribute)ModAttributes.JUMP_HEIGHT.get());
        if (attr != null && attr.func_111126_e() <= 0.0) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANT_MOVE, new Object[]{ability.getCore().getLocalizedName()}));
        }
        attr = entity.func_110148_a(Attributes.field_233821_d_);
        if (attr != null && attr.func_111126_e() <= 0.0) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANT_MOVE, new Object[]{ability.getCore().getLocalizedName()}));
        }
        return AbilityUseResult.success();
    }

    public static AbilityUseResult canUseBrawlerAbilities(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_190926_b()) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST));
        }
        return AbilityUseResult.success();
    }

    public static AbilityUseResult requiresClimaTact(LivingEntity entity, IAbility ability) {
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_77973_b() instanceof ClimaTactItem) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NEED_CLIMA_TACT);
    }

    public static AbilityUseResult requiresBluntWeapon(LivingEntity entity, IAbility ability) {
        boolean hasBluntInHand = ItemsHelper.isBlunt(entity.func_184614_ca());
        if (hasBluntInHand) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_BLUNT));
    }

    public static AbilityUseResult canUseSwordsmanAbilities(LivingEntity entity, IAbility ability) {
        boolean hasSparClawActive;
        if (entity instanceof MorganEntity) {
            return AbilityUseResult.success();
        }
        boolean hasSwordInHand = ItemsHelper.isSword(entity.func_184614_ca());
        if (hasSwordInHand) {
            return AbilityUseResult.success();
        }
        Optional<ContinuousComponent> sparClaw = AbilityDataCapability.getLazy(entity).filter(Objects::nonNull).map(data -> data.getEquippedAbility(SparClawAbility.INSTANCE)).map(abl -> abl.getComponent(ModAbilityKeys.CONTINUOUS)).filter(Optional::isPresent).map(Optional::get);
        boolean bl = hasSparClawActive = sparClaw.isPresent() && sparClaw.get().isContinuous();
        if (hasSparClawActive && entity.func_184614_ca().func_190926_b()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SWORD));
    }

    public static AbilityUseResult requiresMedicBag(LivingEntity entity, IAbility ability) {
        boolean hasMedicBag;
        ItemStack medicBag = entity.func_184582_a(EquipmentSlotType.CHEST);
        boolean bl = hasMedicBag = !medicBag.func_190926_b() && medicBag.func_77973_b() == ModArmors.MEDIC_BAG.get();
        if (hasMedicBag) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MEDIC_BAG, new Object[]{ability.getDisplayName().getString()}));
    }

    public static AbilityUseResult requiresOnGround(LivingEntity entity, IAbility ability) {
        if (entity.func_233570_aj_()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{ability.getDisplayName().getString()}));
    }

    public static AbilityUseResult requiresInAir(LivingEntity entity, IAbility ability) {
        if (!entity.func_233570_aj_()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_AIR, new Object[]{ability.getDisplayName().getString()}));
    }

    public static AbilityUseResult requiresDryUser(LivingEntity entity, IAbility ability) {
        if (!entity.func_70026_G()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_WHEN_DRY, new Object[]{ability.getDisplayName().getString()}));
    }

    public static AbilityUseResult requiresTonfaWeapon(LivingEntity entity, IAbility ability) {
        boolean hasTonfaInHand;
        boolean bl = hasTonfaInHand = !entity.func_184614_ca().func_190926_b() && entity.func_184614_ca().func_77973_b() == ModWeapons.TONFA.get();
        if (hasTonfaInHand) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_TONFA));
    }
}

