/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class FightingStyleHelper {
    private static final UUID BRAWLER_ATTACK_BONUS_UUID = UUID.fromString("4e4d55e7-774b-4010-8722-a15f9da99807");
    private static final UUID BLACK_LEG_ATTACK_BONUS_UUID = UUID.fromString("be5937cc-c1da-4891-9583-cebbab2134d3");
    public static final UUID SWORDSMAN_ATTACK_BONUS_ID = UUID.fromString("4b706e44-2567-4019-9b9c-747fa53bb05d");
    private static final AttributeModifier BLACK_LEG_ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("aa257b39-effd-43b3-9034-615b21e49038"), "Black Leg Speed Multiplier", (double)0.3f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BLACK_LEG_ATTACK_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("cd7d0526-005b-4ef2-a61f-0e941b0d6e1a"), "Black Leg Range Multiplier", 0.5, AttributeModifier.Operation.ADDITION);

    public static boolean hasBlackLegModifiers(LivingEntity entity) {
        boolean flag1 = entity.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111127_a(BLACK_LEG_ATTACK_BONUS_UUID) != null;
        boolean flag2 = entity.func_110148_a(Attributes.field_233825_h_).func_180374_a(BLACK_LEG_ATTACK_SPEED_MODIFIER);
        boolean flag3 = entity.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_180374_a(BLACK_LEG_ATTACK_RANGE_MODIFIER);
        return flag1 || flag2 || flag3;
    }

    public static void removeBlackLegModifiers(LivingEntity entity) {
    }

    public static void applyBlackLegModifiers(LivingEntity entity) {
    }

    public static boolean hasBrawlerModifiers(LivingEntity entity) {
        return entity.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111127_a(BRAWLER_ATTACK_BONUS_UUID) != null;
    }

    public static void removeBrawlerModifiers(LivingEntity entity) {
    }

    public static void applyBrawlerModifiers(LivingEntity entity) {
    }

    public static double getBrawlerBonus(LivingEntity entity) {
        return 2.0 + EntityStatsCapability.get(entity).getDoriki() * 5.0E-4;
    }

    public static double getBlackLegBonus(LivingEntity entity) {
        return 2.0 + EntityStatsCapability.get(entity).getDoriki() * 4.0E-4;
    }

    public static double getAppliedBrawlerBonus(LivingEntity entity) {
        AttributeModifier mod = entity.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111127_a(BRAWLER_ATTACK_BONUS_UUID);
        if (mod == null) {
            return 0.0;
        }
        return mod.func_111164_d();
    }

    public static double getAppliedBlackLegBonus(LivingEntity entity) {
        AttributeModifier mod = entity.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111127_a(BLACK_LEG_ATTACK_BONUS_UUID);
        if (mod == null) {
            return 0.0;
        }
        return mod.func_111164_d();
    }

    private static AttributeModifier getBrawlerAttackModifier(LivingEntity entity) {
        return new AttributeModifier(BRAWLER_ATTACK_BONUS_UUID, "Brawler Attack Multiplier", FightingStyleHelper.getBrawlerBonus(entity), AttributeModifier.Operation.ADDITION);
    }

    private static AttributeModifier getBlackLegAttackModifier(LivingEntity entity) {
        return new AttributeModifier(BLACK_LEG_ATTACK_BONUS_UUID, "Black Leg Attack Multiplier", FightingStyleHelper.getBlackLegBonus(entity), AttributeModifier.Operation.ADDITION);
    }
}

