/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xyz.pixelatedw.mineminenomi.abilities.ZoomAbility;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.ProjectileExtrasCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.DFEncyclopediaItem;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.items.weapons.ModSwordItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ItemsHelper {
    private static final String[] WANTED_POSTER_BACKGROUNDS = new String[]{"forest1", "forest2", "jungle1", "jungle2", "hills1", "hills2", "hills3", "plains1", "plains2", "plains3", "taiga1", "taiga2"};

    public static void hurtCurrentlyUsedShield(LivingEntity entity, float damage) {
        if (entity.func_184607_cu().isShield(entity)) {
            if (!entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_71029_a(Stats.field_75929_E.func_199076_b((Object)entity.func_184607_cu().func_77973_b()));
            }
            int i = 1 + MathHelper.func_76141_d((float)damage);
            Hand hand = entity.func_184600_cs();
            entity.func_184607_cu().func_222118_a(i, entity, user -> {
                user.func_213334_d(hand);
                if (entity instanceof PlayerEntity) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)entity), (ItemStack)entity.func_184607_cu(), (Hand)hand);
                }
            });
            if (entity.func_184607_cu().func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    entity.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    entity.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                entity.func_184602_cy();
                entity.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public static void stopShieldAndStartCooldown(LivingEntity entity, int cooldown) {
        if (AbilityHelper.isShieldBlocking(entity)) {
            entity.func_184602_cy();
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_184811_cZ().func_185145_a(Items.field_185159_cQ, cooldown);
            }
        }
    }

    public static boolean giveItemStackToEntity(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slotType) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).field_71071_by.func_70441_a(itemStack);
            return true;
        }
        if (!entity.func_190630_a(slotType)) {
            entity.func_184201_a(slotType, itemStack);
            return true;
        }
        return false;
    }

    public static void removeItemStackFromInventory(LivingEntity entity, ItemStack searchStack) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).field_71071_by.func_184437_d(searchStack);
        } else {
            for (ItemStack stack : entity.func_184209_aF()) {
                if (!stack.equals(searchStack)) continue;
                stack.func_190918_g(stack.func_190916_E());
            }
        }
    }

    public static boolean hasItemStackInInventory(LivingEntity entity, ItemStack stack) {
        return ItemsHelper.getAllInventoryItems(entity).contains(stack);
    }

    public static int countItemInInventory(LivingEntity entity, Item item) {
        return ItemsHelper.getAllInventoryItems(entity).stream().filter(stack -> stack.func_77973_b().equals(item)).map(ItemStack::func_190916_E).reduce(0, Integer::sum);
    }

    public static int getFreeSlotReversed(PlayerEntity player) {
        for (int i = player.field_71071_by.field_70462_a.size() - 1; i > 0; --i) {
            if (!((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasInventoryFull(LivingEntity entity) {
        return !ItemsHelper.getInventoryItems(entity).stream().anyMatch(stack -> stack.func_190926_b());
    }

    public static long getFreeSlotsCount(LivingEntity entity) {
        return ItemsHelper.getInventoryItems(entity).stream().filter(stack -> stack.func_190926_b()).count();
    }

    public static List<ItemStack> getInventoryItems(LivingEntity entity) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        if (entity instanceof PlayerEntity) {
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_70462_a);
        } else {
            entity.func_184214_aD().forEach(inventory::add);
        }
        return inventory;
    }

    public static List<ItemStack> getAllInventoryItems(LivingEntity entity) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        if (entity instanceof PlayerEntity) {
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_70462_a);
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_184439_c);
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_70460_b);
        } else {
            entity.func_184209_aF().forEach(inventory::add);
        }
        inventory.removeIf(stack -> stack == null || stack.func_190926_b());
        return inventory;
    }

    public static void itemBreakParticles(World level, Vector3d pos, int count, ItemStack stack) {
        for (int i = 0; i < count; ++i) {
            Vector3d vec3d = new Vector3d(((double)level.func_201674_k().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            double d0 = (double)(-level.func_201674_k().nextFloat()) * 0.6 - 0.3;
            Vector3d vec3d1 = new Vector3d(((double)level.func_201674_k().nextFloat() - 0.5) * 0.3, d0, 0.6);
            if (level instanceof ServerWorld) {
                ((ServerWorld)level).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.2);
                continue;
            }
            level.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public static void itemBreakParticles(LivingEntity entity, int count, ItemStack stack) {
        for (int i = 0; i < count; ++i) {
            Vector3d vec3d = new Vector3d(((double)entity.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            double d0 = (double)(-entity.func_70681_au().nextFloat()) * 0.6 - 0.3;
            Vector3d vec3d1 = new Vector3d(((double)entity.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_72441_c(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
            if (entity.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.2);
                continue;
            }
            entity.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public static boolean updateEncyclopediae(PlayerEntity player, ResourceLocation fruit, DFEncyclopediaEntry entry) {
        List<Object> slots = new ArrayList();
        slots.addAll((Collection<Object>)player.field_71071_by.field_70462_a);
        slots.addAll((Collection<Object>)player.field_71071_by.field_184439_c);
        slots = slots.stream().filter(stack -> stack.func_77973_b() == ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get()).collect(Collectors.toList());
        if (slots.size() <= 0) {
            return false;
        }
        slots.forEach(stack -> {
            DFEncyclopediaItem.addFruitClues(stack, fruit, entry);
            ModAdvancements.ENCYCLOPEDIA_COMPLETION.trigger((ServerPlayerEntity)player, (ItemStack)stack);
        });
        return true;
    }

    public static void dropWantedPosters(World world, int posX, int posY, int posZ) {
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get();
        HashSet playerBountiesInPackage = new HashSet();
        if (worldData.getAllBounties().size() > 0) {
            Predicate<PlayerEntity> hasBounty = player -> player != null && player.func_70089_S() && BountyHelper.canGainBounty(player) && worldData.getBounty(player.func_110124_au().toString().toLowerCase()) != 0L;
            WyHelper.getNearbyPlayers(new Vector3d((double)posX, (double)posY, (double)posZ), (IWorld)world, 10.0, null).stream().filter(hasBounty).limit(5L).forEach(player -> {
                ImmutablePair pair = ImmutablePair.of((Object)player.func_110124_au().toString(), (Object)worldData.getBounty(player.func_110124_au().toString().toLowerCase()));
                playerBountiesInPackage.add(pair);
            });
            if (playerBountiesInPackage.size() < 5) {
                List playerBounties = worldData.getAllBounties().entrySet().stream().filter(entry -> !playerBountiesInPackage.contains(entry)).map(entry -> ImmutablePair.of(entry.getKey(), entry.getValue())).collect(Collectors.toList());
                Collections.shuffle(playerBounties);
                int size = Math.min(3, playerBounties.size());
                playerBountiesInPackage.addAll(playerBounties.subList(0, size));
            }
        }
        if (!playerBountiesInPackage.isEmpty()) {
            playerBountiesInPackage.stream().forEach(entry -> {
                ItemStack stack = new ItemStack((IItemProvider)ModBlocks.WANTED_POSTER.get());
                CompoundNBT data = ItemsHelper.setPlayerWantedData((IWorld)world, (String)entry.getKey(), (Long)entry.getValue());
                if (!data.isEmpty()) {
                    stack.func_77982_d(data);
                    world.func_217376_c((Entity)new ItemEntity(world, (double)posX, (double)(posY + 1), (double)posZ, stack));
                }
            });
        }
        int bossPosters = world.func_201674_k().nextInt(3);
        List list = ModRegistries.CHALLENGES.getValues().stream().filter(core -> core.getDifficulty() == ChallengeDifficulty.STANDARD).collect(Collectors.toList());
        Collections.shuffle(list);
        for (int i = 0; i < bossPosters; ++i) {
            int pick = world.func_201674_k().nextInt(list.size());
            ChallengeCore challenge = (ChallengeCore)((Object)list.get(pick));
            ItemStack stack = new ItemStack((IItemProvider)ModItems.CHALLENGE_POSTER.get());
            stack.func_200302_a((ITextComponent)challenge.getLocalizedTitle());
            stack.func_196082_o().func_74778_a("challengeId", challenge.getRegistryName().toString());
            world.func_217376_c((Entity)new ItemEntity(world, (double)posX, (double)(posY + 1), (double)posZ, stack));
        }
    }

    public static CompoundNBT setPlayerWantedData(IWorld world, String id, long bounty) {
        CompoundNBT data = new CompoundNBT();
        PlayerEntity player = world.func_217371_b(UUID.fromString(id));
        if (player == null) {
            return data;
        }
        data.func_74778_a("UUID", id);
        data.func_74778_a("Name", player.func_200200_C_().getString());
        data.func_74772_a("Bounty", bounty);
        data.func_74778_a("Faction", EntityStatsCapability.get((LivingEntity)player).getFaction());
        long seed = (long)player.func_200200_C_().getString().hashCode() + bounty;
        Random rand = new Random(seed);
        int randomBg = (int)WyHelper.randomWithRange(rand, 0, WANTED_POSTER_BACKGROUNDS.length - 1);
        data.func_74778_a("Background", WANTED_POSTER_BACKGROUNDS[randomBg]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = format.format(new Date());
        data.func_74778_a("Date", dateString);
        CompoundNBT compoundnbt = new CompoundNBT();
        NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)player.func_146103_bH());
        data.func_218657_a("Owner", (INBT)compoundnbt);
        return data;
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ShootableItem) {
            return true;
        }
        return itemStack.func_77975_n() == UseAction.BOW;
    }

    public static boolean isBlunt(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.func_77973_b() instanceof ModSwordItem && ((ModSwordItem)itemStack.func_77973_b()).isBlunt();
    }

    public static boolean isSword(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ModSwordItem && !((ModSwordItem)itemStack.func_77973_b()).isBlunt()) {
            return true;
        }
        return itemStack.func_77973_b() instanceof SwordItem;
    }

    public static boolean isClimaTact(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.func_77973_b() instanceof ClimaTactItem;
    }

    public static boolean hasKairosekiItem(LivingEntity entity) {
        Iterable iter = entity.func_184209_aF();
        if (entity instanceof PlayerEntity) {
            iter = Iterables.concat((Iterable)((PlayerEntity)entity).field_71071_by.field_70462_a, (Iterable)entity.func_184209_aF());
        }
        for (ItemStack stack : iter) {
            if (stack.func_190926_b() || !ModTags.Items.KAIROSEKI.func_230235_a_((Object)stack.func_77973_b())) continue;
            return true;
        }
        return entity.func_70644_a((Effect)ModEffects.CAUGHT_IN_KAIROSEKI_NET.get()) || entity.func_70644_a((Effect)ModEffects.HANDCUFFED_KAIROSEKI.get());
    }

    public static boolean isKairosekiWeapon(ItemStack heldItem) {
        if (heldItem != null) {
            return heldItem.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.KAIROSEKI.get()), (ItemStack)heldItem) > 0 || heldItem.func_77973_b() == ModWeapons.JITTE.get();
        }
        return false;
    }

    public static float getSniperInaccuracy(float inaccuracy, LivingEntity entity) {
        if (EntityStatsCapability.get(entity).isSniper()) {
            inaccuracy /= 2.0f;
        }
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModArmors.SNIPER_GOGGLES.get()) {
            boolean isActive;
            IAbilityData aprops = AbilityDataCapability.get(entity);
            ZoomAbility ability = aprops.getEquippedAbility(ZoomAbility.INSTANCE);
            boolean bl = isActive = ability != null && ability.isContinuous();
            if (isActive) {
                inaccuracy /= 4.0f;
            }
        }
        return inaccuracy;
    }

    public static float getItemDamage(ItemStack stack) {
        if (stack == null) {
            return -1.0f;
        }
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        double modifier = EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attr = (AttributeModifier)entry.getValue();
            if (!attr.func_111167_a().equals(AttributeHelper.ATTACK_DAMAGE_MODIFIER)) continue;
            double damage = attr.func_111164_d() + modifier;
            return (float)damage;
        }
        return -1.0f;
    }

    public static ItemStack getProjectileUsedWeapon(ProjectileEntity entity) {
        return ProjectileExtrasCapability.get((Entity)entity).getWeaponUsed();
    }
}

