/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.DoppelmanEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.NightmareSoldierEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.GenkotsuMeteorWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiEmissionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.TekkaiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.HiryuKaenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.OTatsumakiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.SanbyakurokujuPoundHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.ShiShishiSonsonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.YakkodoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class MobsHelper {
    public static final Color MARINE_BLUE_COLOR = WyHelper.hexToRGB("#0084BC");
    public static final ArrayList<Supplier<? extends Item>> PIRATE_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.CUTLASS, ModWeapons.KATANA, ModWeapons.AXE, () -> Items.field_151040_l, () -> Items.field_151052_q, () -> Items.field_151049_t, () -> Items.field_151036_c});
    public static final ArrayList<Supplier<? extends Item>> MARINE_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.BROADSWORD, ModWeapons.KATANA, ModWeapons.SPEAR, () -> Items.field_151040_l, () -> Items.field_151052_q});
    public static final ArrayList<Supplier<? extends Item>> MARINE_CAPTAIN_SWORDS = MobsHelper.createMarineCaptainWeaponsList();
    public static final ArrayList<Supplier<? extends Item>> BANDIT_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.DAGGER, ModWeapons.AXE, ModWeapons.KATANA, () -> Items.field_151049_t, () -> Items.field_151036_c});
    public static final ArrayList<Supplier<? extends Item>> BRUTE_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.MACE, ModWeapons.DALTONS_SPADE, ModWeapons.CLEAVER, () -> Items.field_151036_c});
    public static final ArrayList<Supplier<? extends Item>> GORILLA_AXES = Lists.newArrayList((Object[])new Supplier[]{() -> Items.field_151036_c, () -> Items.field_151006_E, () -> Items.field_151049_t, () -> Items.field_151056_x});
    public static final ResourceLocation[] PIRATE_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("pirate6"), MobsHelper.entityTexture("pirate7"), MobsHelper.entityTexture("pirate8")};
    public static final ResourceLocation[] PIRATE_FISHMEN_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("fishman_pirate1"), MobsHelper.entityTexture("fishman_pirate2"), MobsHelper.entityTexture("fishman_pirate3")};
    public static final ResourceLocation[] PIRATE_CAPTAINS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("pirate_captain1"), MobsHelper.entityTexture("pirate_captain2"), MobsHelper.entityTexture("pirate_captain3"), MobsHelper.entityTexture("pirate_captain4"), MobsHelper.entityTexture("pirate_captain5")};
    public static final ResourceLocation[] PIRATE_TRADERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("pirate_trader1"), MobsHelper.entityTexture("pirate_trader2")};
    public static final ResourceLocation[] MARINE_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine1"), MobsHelper.entityTexture("marine2"), MobsHelper.entityTexture("marine3"), MobsHelper.entityTexture("marine4"), MobsHelper.entityTexture("marine5")};
    public static final ResourceLocation[] MARINE_CAPTAINS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine_captain1"), MobsHelper.entityTexture("marine_captain2"), MobsHelper.entityTexture("marine_captain3"), MobsHelper.entityTexture("marine_captain4"), MobsHelper.entityTexture("marine_captain5")};
    public static final ResourceLocation[] MARINE_TRADERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine_trader1"), MobsHelper.entityTexture("marine_trader2")};
    public static final ResourceLocation[] BANDIT_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("bandit1"), MobsHelper.entityTexture("bandit2"), MobsHelper.entityTexture("bandit3")};
    public static final ResourceLocation[] SKYPEAN_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("skypiean_civilian1"), MobsHelper.entityTexture("skypiean_civilian2"), MobsHelper.entityTexture("skypiean_civilian3")};
    public static final ResourceLocation[] SKYPEAN_TRADERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("skypiean_trader1"), MobsHelper.entityTexture("skypiean_trader2")};
    public static final ResourceLocation[] SWORDSMAN_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dojosensei1"), MobsHelper.entityTexture("dojosensei2"), MobsHelper.entityTexture("dojosensei3")};
    public static final ResourceLocation[] SNIPER_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("bow_master1"), MobsHelper.entityTexture("bow_master2")};
    public static final ResourceLocation[] DOCTOR_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("doctor1"), MobsHelper.entityTexture("doctor2")};
    public static final ResourceLocation[] BRAWLER_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("brawler_trainer1"), MobsHelper.entityTexture("brawler_trainer2")};
    public static final ResourceLocation[] BLACK_LEG_TRAINERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("black_leg_trainer1"), MobsHelper.entityTexture("black_leg_trainer2")};
    public static final ResourceLocation[] WEATHER_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("weather_wizard1")};
    public static final ResourceLocation[] DEN_DEN_MUSHI_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("den_den_mushi1"), MobsHelper.entityTexture("den_den_mushi2"), MobsHelper.entityTexture("den_den_mushi3")};
    public static final ResourceLocation[] YAGARA_BULL_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("yagara_bull1"), MobsHelper.entityTexture("yagara_bull2"), MobsHelper.entityTexture("yagara_bull3")};
    public static final ResourceLocation[] NIGHTMARE_SOLDIER_TEXTURES = WyHelper.concatAllArrays(PIRATE_TEXTURES, PIRATE_FISHMEN_TEXTURES, MARINE_TEXTURES, BANDIT_TEXTURES);
    public static final ResourceLocation[] DUGONG_HEAD_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/head_0"), MobsHelper.entityTexture("dugong_scars/head_1"), MobsHelper.entityTexture("dugong_scars/head_2"), MobsHelper.entityTexture("dugong_scars/head_3"), MobsHelper.entityTexture("dugong_scars/head_4")};
    public static final ResourceLocation[] DUGONG_CHEST_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/chest_0"), MobsHelper.entityTexture("dugong_scars/chest_1"), MobsHelper.entityTexture("dugong_scars/chest_2")};
    public static final ResourceLocation[] DUGONG_ARMS_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/arms_0"), MobsHelper.entityTexture("dugong_scars/arms_1")};
    public static final ResourceLocation[] DUGONG_TAIL_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/tail_0"), MobsHelper.entityTexture("dugong_scars/tail_1"), MobsHelper.entityTexture("dugong_scars/tail_2")};
    public static final Comparator<LivingEntity> ENTITY_THREAT = new Comparator<LivingEntity>(){

        @Override
        public int compare(LivingEntity e1, LivingEntity e2) {
            int e1Threat = (int)EntityStatsCapability.get(e1).getDoriki();
            int e2Threat = (int)EntityStatsCapability.get(e2).getDoriki();
            return e1Threat - e2Threat;
        }
    };

    private static ArrayList<Supplier<? extends Item>> createMarineCaptainWeaponsList() {
        ArrayList list = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.JITTE, ModWeapons.BISENTO, () -> Items.field_151048_u});
        list.addAll(MARINE_SWORDS);
        return list;
    }

    public static float getThreatLevel(LivingEntity entity) {
        double doriki = EntityStatsCapability.get(entity).getDoriki() / (double)CommonConfig.INSTANCE.getDorikiLimit();
        doriki = MathHelper.func_151237_a((double)doriki, (double)0.0, (double)1.0);
        double haki = HakiDataCapability.get(entity).getTotalHakiExp() / (float)CommonConfig.INSTANCE.getHakiExpLimit();
        haki = MathHelper.func_151237_a((double)haki, (double)0.0, (double)1.0);
        float abilities = (float)AbilityDataCapability.get(entity).getUnlockedAbilities().size() / 30.0f;
        abilities = MathHelper.func_76131_a((float)abilities, (float)0.0f, (float)1.0f);
        if (entity instanceof PlayerEntity) {
            abilities = 0.0f;
        }
        float threatLevel = (float)((doriki *= (double)0.4f) + (haki *= 0.5) + (double)(abilities *= 0.1f));
        threatLevel = MathHelper.func_76131_a((float)threatLevel, (float)0.0f, (float)1.0f);
        return threatLevel;
    }

    public static Predicate<Entity> shouldAttackTarget(LivingEntity entity) {
        return targetEntity -> {
            if (!(targetEntity instanceof LivingEntity)) {
                return false;
            }
            if (WyHelper.isInChallengeDimension(entity.field_70170_p)) {
                return true;
            }
            LivingEntity target = (LivingEntity)targetEntity;
            double entityThreatLevel = MobsHelper.getThreatLevel(entity);
            double targetThreatLevel = MobsHelper.getThreatLevel(target);
            double bonus = targetThreatLevel * 0.2;
            if ((double)target.func_110143_aJ() < (double)target.func_110138_aP() * 0.2) {
                targetThreatLevel -= targetThreatLevel * 0.2;
            }
            return entityThreatLevel + bonus >= targetThreatLevel;
        };
    }

    @Nullable
    public static LivingEntity getTamer(LivingEntity entity) {
        BlackKnightEntity blackKnight;
        NightmareSoldierEntity soldier;
        DoppelmanEntity doppelamn;
        if (!ModEntityPredicates.canBeTamed().test((Entity)entity)) {
            return null;
        }
        if (entity instanceof TameableEntity) {
            return ((TameableEntity)entity).func_70902_q();
        }
        if (entity instanceof AbstractHorseEntity) {
            UUID ownerUuid = ((AbstractHorseEntity)entity).func_184780_dh();
            if (ownerUuid == null) {
                return null;
            }
            return entity.field_70170_p.func_217371_b(ownerUuid);
        }
        if (entity instanceof DoppelmanEntity && (doppelamn = (DoppelmanEntity)entity).getOwner() != null && doppelamn.getOwner().func_70089_S()) {
            return doppelamn.getOwner();
        }
        if (entity instanceof NightmareSoldierEntity && (soldier = (NightmareSoldierEntity)entity).getOwner() != null && soldier.getOwner().func_70089_S()) {
            return soldier.getOwner();
        }
        if (entity instanceof BlackKnightEntity && (blackKnight = (BlackKnightEntity)entity).getOwner() != null && blackKnight.getOwner().func_70089_S()) {
            return blackKnight.getOwner();
        }
        if (entity instanceof ICommandReceiver) {
            return ((ICommandReceiver)entity).getLastCommandSender();
        }
        return null;
    }

    public static <T extends IAbility> T unlockAndEquipAbility(LivingEntity entity, AbilityCore<T> core) {
        IAbilityData props = AbilityDataCapability.get(entity);
        T ability = MobsHelper.unlockAbility(entity, core);
        int availableSlot = props.getEquippedAbilities().size();
        props.setEquippedAbility(availableSlot, (IAbility)ability);
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllAround(new SEquipAbilityPacket(entity.func_145782_y(), availableSlot, core), (Entity)entity);
        }
        return ability;
    }

    public static <T extends IAbility> T unlockAbility(LivingEntity entity, AbilityCore<T> core) {
        IAbilityData props = AbilityDataCapability.get(entity);
        props.addUnlockedAbility(core, AbilityUnlock.COMMAND);
        T ability = core.createAbility();
        return ability;
    }

    public static ResourceLocation entityTexture(String texture) {
        return MobsHelper.entityTexture("mineminenomi", texture);
    }

    public static ResourceLocation entityTexture(String modId, String texture) {
        return new ResourceLocation(modId, "textures/models/" + texture + ".png");
    }

    public static void addBasicNPCGoals(CreatureEntity entity) {
        Predicate<Entity> targetMobCheck;
        ((GroundPathNavigator)entity.func_70661_as()).func_179688_b(true);
        boolean isBoss = entity instanceof OPBossEntity;
        if (!isBoss) {
            ((GroundPathNavigator)entity.func_70661_as()).func_212239_d(true);
            entity.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)entity));
            entity.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal(entity, 0.8));
        }
        entity.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)entity, true));
        entity.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)entity, PlayerEntity.class, 8.0f));
        entity.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)entity));
        Predicate<Entity> hurtByCheck = ModEntityPredicates.getEnemyFactions((LivingEntity)entity).and(ModEntityPredicates.IS_ENTITY_HARMLESS.negate());
        Predicate<Entity> targetPlayerCheck = targetMobCheck = hurtByCheck.and(ModEntityPredicates.IS_INVISIBLE.negate()).and(MobsHelper.shouldAttackTarget((LivingEntity)entity));
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        FactionHurtByTargetGoal hurtByTargetGoal = new FactionHurtByTargetGoal(entity, hurtByCheck, new Class[0]);
        if (props.isMarine() || props.isBountyHunter()) {
            targetPlayerCheck = targetPlayerCheck.and(ModEntityPredicates.TARGET_HAS_ISSUED_BOUNTY);
            hurtByTargetGoal.func_220794_a(new Class[0]);
        }
        entity.field_70715_bh.func_75776_a(1, (Goal)hurtByTargetGoal);
        entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, MobEntity.class, 10, true, true, targetMobCheck));
        entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, true, targetPlayerCheck));
    }

    @Deprecated
    public static Set<Goal> getBrawlerAbilities(MobEntity entity, int maxGoals) {
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new HakaiHoWrapperGoal(entity), 3.0f);
        goals.addEntry(() -> new SuplexWrapperGoal(entity), 3.0f);
        goals.addEntry(() -> new GenkotsuMeteorWrapperGoal(entity), 2.0f);
        goals.addEntry(() -> new JishinHoWrapperGoal(entity), 2.0f);
        goals.addEntry(() -> new SpinningBrawlWrapperGoal(entity), 1.0f);
        return MobsHelper.getRandomizedGoals(entity, maxGoals, goals);
    }

    @Deprecated
    public static void addBrawlerAbilities(MobEntity entity, int maxGoals) {
        MobsHelper.applyRandomizedGoals(entity, maxGoals, MobsHelper.getBrawlerAbilities(entity, maxGoals));
    }

    @Deprecated
    public static Set<Goal> getSwordsmanAbilities(MobEntity entity, int maxGoals) {
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new HiryuKaenWrapperGoal(entity), 4.0f);
        goals.addEntry(() -> new ShiShishiSonsonWrapperGoal(entity), 4.0f);
        goals.addEntry(() -> new YakkodoriWrapperGoal(entity), 3.0f);
        goals.addEntry(() -> new OTatsumakiWrapperGoal(entity), 2.0f);
        goals.addEntry(() -> new SanbyakurokujuPoundHoWrapperGoal(entity), 2.0f);
        return MobsHelper.getRandomizedGoals(entity, maxGoals, goals);
    }

    @Deprecated
    public static void addSwordsmanAbilities(MobEntity entity, int maxGoals) {
        MobsHelper.applyRandomizedGoals(entity, maxGoals, MobsHelper.getSwordsmanAbilities(entity, maxGoals));
    }

    @Deprecated
    public static Set<Goal> getRokushikiAbilities(MobEntity entity, int maxGoals) {
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new SoruWrapperGoal(entity), 10.0f);
        goals.addEntry(() -> new ShiganWrapperGoal(entity), 7.0f);
        goals.addEntry(() -> new TekkaiWrapperGoal(entity), 7.0f);
        goals.addEntry(() -> new RankyakuWrapperGoal(entity), 1.0f);
        return MobsHelper.getRandomizedGoals(entity, maxGoals, goals);
    }

    @Deprecated
    public static void addRokushikiAbilities(MobEntity entity, int maxGoals) {
        MobsHelper.applyRandomizedGoals(entity, maxGoals, MobsHelper.getRokushikiAbilities(entity, maxGoals));
    }

    public static void addBusoshokuHaki(MobEntity entity, int chance) {
        if ((double)chance > WyHelper.randomWithRange(0, 100)) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
            if (props.isSniper() || props.isSwordsman()) {
                hakiProps.setBusoshokuHakiExp(30 + entity.func_70681_au().nextInt(20));
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiImbuingWrapperGoal(entity));
            } else if ((double)(chance / 3) > WyHelper.randomWithRange(0, 100)) {
                hakiProps.setBusoshokuHakiExp(50 + entity.func_70681_au().nextInt(20));
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal(entity));
            } else {
                hakiProps.setBusoshokuHakiExp(30 + entity.func_70681_au().nextInt(20));
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiHardeningWrapperGoal(entity));
            }
        }
    }

    public static void addAdvancedBusoshokuHaki(MobEntity entity, int chance) {
        if ((double)chance > WyHelper.randomWithRange(0, 100)) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
            if (entity.func_70681_au().nextInt(10) < 6) {
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiEmissionWrapperGoal(entity));
            } else {
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal(entity));
            }
        }
    }

    public static Set<Goal> getRandomizedGoals(MobEntity entity, int maxGoals, WeightedList<Supplier<Goal>> list) {
        int rolls = 5;
        HashSet<Goal> goals = new HashSet<Goal>();
        while (goals.size() < maxGoals && rolls > 0) {
            Goal goal = list.pick(entity.func_70681_au()).get();
            if (goal == null) {
                --rolls;
                continue;
            }
            boolean alreadyInList = goals.stream().map(g -> g.toString()).anyMatch(s -> goal.toString().equalsIgnoreCase((String)s));
            if (!alreadyInList) {
                goals.add(goal);
                continue;
            }
            --rolls;
        }
        return goals;
    }

    private static void applyRandomizedGoals(MobEntity entity, int maxGoals, Set<Goal> goals) {
        goals.forEach(goal -> entity.field_70714_bg.func_75776_a(4, goal));
    }
}

