/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMorphAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.mixins.client.ILivingRendererMixin;

public class MorphHelper {
    public static <T extends LivingEntity, M extends EntityModel<T>> boolean hasLayerFor(LivingRenderer renderer, Class<? extends LayerRenderer> clz) {
        return ((ILivingRendererMixin)renderer).getLayers().stream().anyMatch(layer -> clz.equals(layer.getClass()));
    }

    public static void addLayerFor(LivingRenderer renderer, LayerRenderer layer) {
        if (!MorphHelper.hasLayerFor(renderer, layer.getClass())) {
            ((ILivingRendererMixin)renderer).getLayers().add(layer);
        }
    }

    public static void removeLayerFor(LivingRenderer renderer, Class<? extends LayerRenderer> clz) {
        ((ILivingRendererMixin)renderer).getLayers().removeIf(layer -> clz.equals(layer.getClass()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLimbFirstPerson(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float equippedProgress, float swingProgress, HandSide side, Optional<AbilityOverlay> overlay, @Nullable MorphInfo info) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity clientPlayer = mc.field_71439_g;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)mc.field_71439_g);
        if (props.isBlackLeg()) {
            MorphHelper.renderLeg((AbstractClientPlayerEntity)clientPlayer, matrixStack, buffer, combinedLight, equippedProgress, swingProgress, side, Optional.empty(), info);
            MorphHelper.renderLeg((AbstractClientPlayerEntity)clientPlayer, matrixStack, buffer, combinedLight, equippedProgress, swingProgress, side, overlay, info);
        } else if (!props.isBlackLeg()) {
            MorphHelper.renderArm((AbstractClientPlayerEntity)clientPlayer, matrixStack, buffer, combinedLight, equippedProgress, swingProgress, side, Optional.empty(), info);
            MorphHelper.renderArm((AbstractClientPlayerEntity)clientPlayer, matrixStack, buffer, combinedLight, equippedProgress, swingProgress, side, overlay, info);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderLeg(AbstractClientPlayerEntity clientPlayer, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float equippedProgress, float swingProgress, HandSide side, Optional<AbilityOverlay> overlay, @Nullable MorphInfo info) {
        float alpha;
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager renderManager = mc.func_175598_ae();
        EntityRenderer renderer = renderManager.func_78713_a((Entity)clientPlayer);
        IDevilFruit dfProps = DevilFruitCapability.get((LivingEntity)mc.field_71439_g);
        if (!(renderer instanceof PlayerRenderer)) {
            return;
        }
        matrixStack.func_227860_a_();
        boolean flag = side != HandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress) / 1.55f;
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        matrixStack.func_227861_a_((double)(f * (f2 + 0.64000005f)), (double)(f3 + -0.6f + equippedProgress * -0.6f), (double)(f4 + -0.71999997f));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229182_e_, f * 85.0f, true));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, f * f6 * 120.0f, true));
        matrixStack.func_227861_a_((double)(f * -1.0f), 4.0, (double)3.6f);
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, f * 120.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 200.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, f * -135.0f, true));
        matrixStack.func_227861_a_((double)(f * 5.6f), 0.0, 0.0);
        IVertexBuilder vertex = null;
        float red = overlay.isPresent() ? (float)overlay.get().getColor().getRed() / 255.0f : 1.0f;
        float green = overlay.isPresent() ? (float)overlay.get().getColor().getGreen() / 255.0f : 1.0f;
        float blue = overlay.isPresent() ? (float)overlay.get().getColor().getBlue() / 255.0f : 1.0f;
        float f5 = alpha = overlay.isPresent() ? (float)overlay.get().getColor().getAlpha() / 255.0f : 1.0f;
        vertex = overlay.isPresent() ? (overlay.get().getTexture() != null ? buffer.getBuffer(ModRenderTypes.getAbilityHand(overlay.get().getTexture())) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR)) : buffer.getBuffer(ModRenderTypes.getAbilityHand(clientPlayer.func_110306_p()));
        MorphModel morphModel = null;
        boolean renderLimb = false;
        boolean isPartial = false;
        if (info != null) {
            morphModel = info.getModel();
            isPartial = info.isPartial();
            renderLimb = info.shouldRenderFirstPersonLeg();
        }
        if (Strings.isNullOrEmpty((String)dfProps.getZoanPoint()) || isPartial && !renderLimb) {
            PlayerModel model = (PlayerModel)((PlayerRenderer)renderer).func_217764_d();
            if (flag) {
                model.field_178721_j.field_78795_f = 0.0f;
                model.field_178721_j.field_78796_g = 0.0f;
                model.field_178721_j.field_78808_h = 0.0f;
                model.field_178721_j.field_78800_c = -2.0f;
                model.field_178721_j.field_78797_d = 0.0f;
                model.field_178721_j.field_78798_e = 0.0f;
                model.field_178731_d.func_217177_a(model.field_178721_j);
                model.field_178721_j.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                model.field_178731_d.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
            } else {
                model.field_178722_k.field_78795_f = 0.0f;
                model.field_178722_k.field_78796_g = 0.0f;
                model.field_178722_k.field_78808_h = 0.0f;
                model.field_178722_k.field_78800_c = 2.0f;
                model.field_178722_k.field_78797_d = 0.0f;
                model.field_178722_k.field_78798_e = 0.0f;
                model.field_178733_c.func_217177_a(model.field_178722_k);
                model.field_178722_k.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                model.field_178733_c.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
            }
        } else if (morphModel != null && renderLimb) {
            ResourceLocation texture = info.getTexture((LivingEntity)clientPlayer);
            if (!overlay.isPresent() || overlay.get().getTexture() == null) {
                vertex = texture != null ? buffer.getBuffer(ModRenderTypes.getAbilityHand(texture)) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
            }
            morphModel.renderFirstPersonLeg(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha, side);
        }
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderArm(AbstractClientPlayerEntity clientPlayer, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float equippedProgress, float swingProgress, HandSide side, Optional<AbilityOverlay> overlay, @Nullable MorphInfo info) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager renderManager = mc.func_175598_ae();
        EntityRenderer renderer = renderManager.func_78713_a((Entity)clientPlayer);
        IDevilFruit dfProps = DevilFruitCapability.get((LivingEntity)mc.field_71439_g);
        if (!(renderer instanceof PlayerRenderer)) {
            return;
        }
        matrixStack.func_227860_a_();
        boolean flag = side != HandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        matrixStack.func_227861_a_((double)(f * (f2 + 0.64000005f)), (double)(f3 + -0.6f + equippedProgress * -0.6f), (double)(f4 + -0.71999997f));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, f * 45.0f, true));
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, f * f6 * 70.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, f * f5 * -20.0f, true));
        matrixStack.func_227861_a_((double)(f * -1.0f), (double)3.6f, 3.5);
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, f * 120.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 200.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, f * -135.0f, true));
        matrixStack.func_227861_a_((double)(f * 5.6f), 0.0, 0.0);
        IVertexBuilder vertex = null;
        float red = overlay.isPresent() ? (float)overlay.get().getColor().getRed() / 255.0f : 1.0f;
        float green = overlay.isPresent() ? (float)overlay.get().getColor().getGreen() / 255.0f : 1.0f;
        float blue = overlay.isPresent() ? (float)overlay.get().getColor().getBlue() / 255.0f : 1.0f;
        float alpha = overlay.isPresent() ? (float)overlay.get().getColor().getAlpha() / 255.0f : 1.0f;
        MorphModel morphModel = null;
        boolean renderLimb = false;
        boolean isPartial = false;
        if (info != null) {
            morphModel = info.getModel();
            isPartial = info.isPartial();
            renderLimb = info.shouldRenderFirstPersonHand();
        }
        vertex = overlay.isPresent() ? (overlay.get().getTexture() != null ? buffer.getBuffer(ModRenderTypes.getAbilityHand(overlay.get().getTexture())) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR)) : buffer.getBuffer(ModRenderTypes.getAbilityHand(clientPlayer.func_110306_p()));
        if (Strings.isNullOrEmpty((String)dfProps.getZoanPoint()) || isPartial && !renderLimb) {
            PlayerModel model = (PlayerModel)((PlayerRenderer)renderer).func_217764_d();
            if (flag) {
                model.field_178723_h.field_78795_f = 0.0f;
                model.field_178723_h.field_78796_g = 0.02f;
                model.field_178723_h.field_78808_h = 0.1f;
                model.field_178723_h.field_78800_c = -5.0f;
                model.field_178723_h.field_78797_d = 2.0f;
                model.field_178723_h.field_78798_e = 0.0f;
                model.field_178732_b.func_217177_a(model.field_178723_h);
                model.field_178723_h.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                model.field_178732_b.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
            } else {
                model.field_178724_i.field_78795_f = 0.0f;
                model.field_178724_i.field_78796_g = 0.04f;
                model.field_178724_i.field_78808_h = -0.1f;
                model.field_178724_i.field_78800_c = 5.0f;
                model.field_178724_i.field_78797_d = 2.0f;
                model.field_178724_i.field_78798_e = 0.0f;
                model.field_178734_a.func_217177_a(model.field_178724_i);
                model.field_178724_i.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                model.field_178734_a.func_228309_a_(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
            }
        } else if (morphModel != null && renderLimb) {
            ResourceLocation texture = info.getTexture((LivingEntity)clientPlayer);
            if (!overlay.isPresent() || overlay.get().getTexture() == null) {
                vertex = texture != null ? buffer.getBuffer(ModRenderTypes.getAbilityHand(texture)) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
            }
            morphModel.renderFirstPersonArm(matrixStack, vertex, combinedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha, side);
        }
        matrixStack.func_227865_b_();
    }

    @Nullable
    public static MorphInfo getZoanInfo(LivingEntity entity) {
        IDevilFruit devilFruitProps = DevilFruitCapability.get(entity);
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        if (devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(entity)) {
            return (MorphInfo)ModMorphs.YOMI_SKELETON.get();
        }
        Optional<MorphInfo> morph = devilFruitProps.getCurrentMorph();
        if (morph.isPresent()) {
            return morph.get();
        }
        for (IAbility ability : abilityProps.getEquippedAbilities()) {
            MorphComponent comp;
            boolean isMorphed;
            if (!ability.hasComponent(ModAbilityKeys.MORPH) || !(isMorphed = (comp = ability.getComponent(ModAbilityKeys.MORPH).get()).isMorphed())) continue;
            return comp.getMorphInfo();
        }
        for (IAbility ability : abilityProps.getEquippedAbilities()) {
            IMorphAbility morphAbility;
            if (ability == null || !(ability instanceof IMorphAbility) || !(morphAbility = (IMorphAbility)((Object)ability)).isTransformationActive(entity)) continue;
            return morphAbility.getTransformation();
        }
        return null;
    }
}

