/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.data.entity.animation.AnimationDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.humanoids.DojoSenseiModel;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.humanoids.HumanoidModel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RendererHelper {
    public static final ResourceLocation VANILLA_VIGNETTE_TEX_PATH = new ResourceLocation("textures/misc/vignette.png");
    public static final ResourceLocation FORCEFIELD_LOCATION = new ResourceLocation("textures/misc/forcefield.png");
    private static final Color WORLD_GOVT_COLOR = WyHelper.hexToRGB("#2B497B");
    public static boolean hasModelChanged = false;
    private static final float distance = (float)(Math.sqrt(3.0) / 2.0);

    public static <M extends EntityModel> void resetHumanoidModelToDefaultPivots(M model) {
        if (model instanceof PlayerModel || model instanceof HumanoidModel || model instanceof DojoSenseiModel) {
            BipedModel biped = (BipedModel)model;
            biped.field_178722_k.func_78793_a(2.0f, 12.0f, 0.1f);
            biped.field_178722_k.field_78795_f = 0.0f;
            biped.field_178722_k.field_78796_g = 0.0f;
            biped.field_178722_k.field_78808_h = 0.0f;
            biped.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.1f);
            biped.field_178721_j.field_78795_f = 0.0f;
            biped.field_178721_j.field_78796_g = 0.0f;
            biped.field_178721_j.field_78808_h = 0.0f;
            biped.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            biped.field_178724_i.field_78795_f = 0.0f;
            biped.field_178724_i.field_78796_g = 0.0f;
            biped.field_178724_i.field_78808_h = 0.0f;
            biped.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            biped.field_178723_h.field_78795_f = 0.0f;
            biped.field_178723_h.field_78796_g = 0.0f;
            biped.field_178723_h.field_78808_h = 0.0f;
            biped.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
            biped.field_78116_c.field_78795_f = 0.0f;
            biped.field_78116_c.field_78796_g = 0.0f;
            biped.field_78116_c.field_78808_h = 0.0f;
            biped.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            biped.field_78115_e.field_78795_f = 0.0f;
            biped.field_78115_e.field_78796_g = 0.0f;
            biped.field_78115_e.field_78808_h = 0.0f;
        }
    }

    public static <M extends EntityModel> void animationHeldItem(LivingEntity entity, ItemStack itemStack, ItemCameraTransforms.TransformType transformType, HandSide handSide, MatrixStack matrixType, IRenderTypeBuffer renderBuffer, int packedLight) {
        Animation animation = AnimationDataCapability.get(entity).getAnimation();
        if (animation != null && animation.isPlaying()) {
            animation.setupHeldItem(entity, itemStack, transformType, handSide, matrixType, renderBuffer, packedLight);
        }
    }

    public static <M extends EntityModel> void animationSetup(LivingEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        Animation animation = AnimationDataCapability.get(entity).getAnimation();
        if (animation != null && animation.isPlaying()) {
            animation.setupAnimation(entity, matrixStack, buffer, packedLight, entityYaw, partialTicks);
        }
    }

    public static <M extends EntityModel<?>> void animationAngles(LivingEntity entity, M model, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Animation<LivingEntity, M> animation = AnimationDataCapability.get(entity).getAnimation();
        if (animation != null && animation.isPlaying()) {
            animation.setAnimationAngles(entity, model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        if (model instanceof BipedModel) {
            ((BipedModel)model).field_178720_f.func_217177_a(((BipedModel)model).field_78116_c);
        }
    }

    public static void drawPlayerFace(PlayerEntity player, MatrixStack matrixStack, int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayNetHandler netHandler = mc.field_71439_g.field_71174_a;
        NetworkPlayerInfo playerInfo = netHandler.func_175102_a(player.func_110124_au());
        mc.func_110434_K().func_110577_a(playerInfo.func_178837_g());
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        if (player.func_175148_a(PlayerModelPart.HAT)) {
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        }
    }

    public static void drawLivingBust(LivingEntity entity, MatrixStack matrixStack, int posX, int posY, int scale, int mouseX, int mouseY, boolean isHidden) {
        float f = (float)Math.atan((float)mouseX / 40.0f);
        float f1 = (float)Math.atan((float)mouseY / 40.0f);
        Minecraft mc = Minecraft.func_71410_x();
        double uiscale = mc.func_228018_at_().func_198100_s();
        double left = posX - scale;
        double width = posX;
        double top = (double)posY - (double)scale * 1.1;
        double height = posY;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)posX, (double)posY, 1050.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, -1.0f);
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixStack.func_227863_a_(quaternion);
        float yBodyRot = entity.field_70761_aq;
        float yRot = entity.field_70177_z;
        float xRot = entity.field_70125_A;
        float yHeadRotO = entity.field_70758_at;
        float yHeadRot = entity.field_70759_as;
        ItemStack mainHand = entity.func_184586_b(Hand.MAIN_HAND);
        ItemStack offHand = entity.func_184586_b(Hand.OFF_HAND);
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 30.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        manager.func_229089_a_(quaternion1);
        manager.func_178633_a(false);
        manager.func_178629_b(false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)(left * uiscale)), (int)((int)((double)mc.func_228018_at_().func_198091_l() - top * uiscale)), (int)((int)(width * uiscale)), (int)((int)(height * uiscale)));
        float entityHeight = entity.func_213305_a((Pose)Pose.STANDING).field_220316_b;
        if (entityHeight > 1.6f) {
            entityHeight = 0.05f;
        } else {
            entityHeight -= 1.8f;
            entityHeight *= -1.0f;
        }
        manager.func_229084_a_((Entity)entity, 0.0, (double)entityHeight, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)buffer, isHidden ? Color.BLACK.getRGB() : 15728860);
        buffer.getBuffer(RenderType.func_228659_m_()).func_225582_a_(0.0, 0.0, 0.0);
        GL11.glDisable((int)3089);
        buffer.func_228461_a_();
        manager.func_178633_a(true);
        entity.field_70761_aq = yBodyRot;
        entity.field_70177_z = yRot;
        entity.field_70125_A = xRot;
        entity.field_70758_at = yHeadRotO;
        entity.field_70759_as = yHeadRot;
        matrixStack.func_227865_b_();
    }

    public static void drawTexturedModalRect(MatrixStack matrixStack, float x, float y, float u, float v, float width, float height, float zLevel, float red, float green, float blue, float alpha) {
        RendererHelper.drawTexturedModalRect(matrixStack, x, y, u, v, width, height, zLevel, 1.0f, 1.0f, red, green, blue, alpha);
    }

    public static void drawTexturedModalRect(MatrixStack matrixStack, float x, float y, float u, float v, float width, float height, float zLevel, float uScale, float vScale, float red, float green, float blue, float alpha) {
        float uAtalsScale = 0.00390625f;
        float vAtlasScale = 0.00390625f;
        float width2 = width * uScale;
        float height2 = height * vScale;
        RenderSystem.enableBlend();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(matrix, x, y + height2, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_(u * 0.00390625f, (v + height) * 0.00390625f).func_181675_d();
        wr.func_227888_a_(matrix, x + width2, y + height2, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_((u + width) * 0.00390625f, (v + height) * 0.00390625f).func_181675_d();
        wr.func_227888_a_(matrix, x + width2, y, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_((u + width) * 0.00390625f, v * 0.00390625f).func_181675_d();
        wr.func_227888_a_(matrix, x, y, zLevel).func_227885_a_(red, green, blue, alpha).func_225583_a_(u * 0.00390625f, v * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
    }

    public static void renderVeryUglySphere(MatrixStack matrixStack, ActiveRenderInfo info, BufferBuilder buffer, double posX, double posY, double posZ, float raduis, float red, float green, float blue, float alpha, float animUSpeed, float animVSpeed, ResourceLocation texture) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        float animU = (float)Util.func_211177_b() % animUSpeed / animUSpeed;
        float animV = (float)Util.func_211177_b() % animVSpeed / animVSpeed;
        float u = animU - 0.0f;
        float v = animV - 1.0f;
        float x = (float)info.func_216785_c().field_72450_a;
        float y = (float)info.func_216785_c().field_72448_b;
        float z = (float)info.func_216785_c().field_72449_c;
        float minY = 0.0f - y;
        float maxY = 256.0f - y;
        minY = (float)((double)(-raduis - y) + posY);
        maxY = (float)((double)(raduis - y) + posY);
        float minX = (float)((double)(-raduis - x) + posX);
        float maxX = (float)((double)(raduis + 1.0f - x) + posX);
        float minZ = (float)((double)(-raduis - z) + posZ);
        float maxZ = (float)((double)(raduis + 1.0f - z) + posZ);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderSystem.pushMatrix();
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableCull();
        buffer.func_227888_a_(matrix4f, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        RenderSystem.enableCull();
        RenderSystem.disableAlphaTest();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public static void renderAbilityProtectionArea(MatrixStack matrixStack, ActiveRenderInfo info, BufferBuilder buffer, double posX, double posY, double posZ, float sizeX, float sizeY, float sizeZ) {
        RendererHelper.renderAreaBorder(matrixStack, info, buffer, posX, posY, posZ, sizeX, sizeY, sizeZ, 0.0f, 1.0f, 1.0f, 1.0f, 10000.0f, 10000.0f, FORCEFIELD_LOCATION);
    }

    public static void renderAreaBorder(MatrixStack matrixStack, ActiveRenderInfo info, BufferBuilder buffer, double posX, double posY, double posZ, float sizeX, float sizeY, float sizeZ, float red, float green, float blue, float alpha, float animUSpeed, float animVSpeed, ResourceLocation texture) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        float animU = (float)Util.func_211177_b() % animUSpeed / animUSpeed;
        float animV = (float)Util.func_211177_b() % animVSpeed / animVSpeed;
        float u = animU - 0.0f;
        float v = animV - 1.0f;
        float x = (float)info.func_216785_c().field_72450_a;
        float y = (float)info.func_216785_c().field_72448_b;
        float z = (float)info.func_216785_c().field_72449_c;
        boolean hasYAxis = sizeY != 0.0f && sizeY < 256.0f;
        float minY = 0.0f - y;
        float maxY = 256.0f - y;
        if (hasYAxis) {
            minY = (float)((double)(-sizeY - y) + posY);
            maxY = (float)((double)(sizeY - y) + posY);
        }
        float minX = (float)((double)(-sizeX - x) + posX);
        float maxX = (float)((double)(sizeX + 1.0f - x) + posX);
        float minZ = (float)((double)(-sizeZ - z) + posZ);
        float maxZ = (float)((double)(sizeZ + 1.0f - z) + posZ);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
        RenderSystem.pushMatrix();
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableCull();
        buffer.func_227888_a_(matrix4f, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
        buffer.func_227888_a_(matrix4f, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        if (hasYAxis) {
            buffer.func_227888_a_(matrix4f, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
            buffer.func_227888_a_(matrix4f, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
            buffer.func_227888_a_(matrix4f, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
            buffer.func_227888_a_(matrix4f, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
            buffer.func_227888_a_(matrix4f, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
            buffer.func_227888_a_(matrix4f, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, v).func_181675_d();
            buffer.func_227888_a_(matrix4f, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(v, u).func_181675_d();
            buffer.func_227888_a_(matrix4f, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, u).func_181675_d();
        }
        buffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        RenderSystem.enableCull();
        RenderSystem.disableAlphaTest();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
    }

    public static void drawColourOnScreen(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RendererHelper.drawColourOnScreen(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColourOnScreen(int red, int green, int blue, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_(posX, posY + height, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY + height, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX, posY, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    /*
     * WARNING - void declaration
     */
    public static void drawAbilityTooltip(IAbility ability, MatrixStack mStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, FontRenderer font) {
        ItemStack stack = ItemStack.field_190927_a;
        if (!textLines.isEmpty()) {
            void var17_23;
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (ITextProperties iTextProperties : textLines) {
                int textLineWidth = font.func_238414_a_(iTextProperties);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            int titleLinesCount = 1;
            int n2 = mouseX + 12;
            if (n2 + tooltipTextWidth + 4 > screenWidth && (n = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
            }
            int wrappedTooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < textLines.size(); ++i) {
                ITextProperties textLine = textLines.get(i);
                List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = font.func_238414_a_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((ITextProperties)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            if (mouseX > screenWidth / 2) {
                int n3 = mouseX - 16 - tooltipTextWidth;
            } else {
                int n4 = mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 400;
            mStack.func_227860_a_();
            Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 3), (int)(tooltipY - 3), (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColorStart, (int)backgroundColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 3), (int)(tooltipY - 4), (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(var17_23 + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 4), (int)(tooltipY - 3), (int)(var17_23 - 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 3), (int)(tooltipY + tooltipHeight + 3), (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)borderColorEnd, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 3), (int)(tooltipY - 3), (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 3), (int)(tooltipY - 3 + 1), (int)(var17_23 - 3 + true), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(var17_23 - 3), (int)(tooltipY + tooltipHeight + 2), (int)(var17_23 + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            String abilityName = ability.getDisplayName().getString();
            int nameWidth = font.func_78256_a(abilityName);
            Color iconColor = WyHelper.hexToRGB("#333333");
            HashSet<ResourceLocation> coloredIcons = new HashSet<ResourceLocation>();
            HashSet<ResourceLocation> staticIcons = new HashSet<ResourceLocation>();
            if (ability.getCore().getSourceHakiNature() != null && ability.getCore().getSourceHakiNature().getTexture() != null) {
                coloredIcons.add(ability.getCore().getSourceHakiNature().getTexture());
            }
            if (ability.getCore().getSourceTypes() != null) {
                for (SourceType sourceType : ability.getCore().getSourceTypes()) {
                    if (sourceType.getTexture() == null) continue;
                    coloredIcons.add(sourceType.getTexture());
                }
            }
            if (ability.getCore().getSourceElement() != null && ability.getCore().getSourceElement().getTexture() != null) {
                staticIcons.add(ability.getCore().getSourceElement().getTexture());
            }
            int spacing = 4;
            for (ResourceLocation icon : coloredIcons) {
                RendererHelper.drawIcon(icon, event.getMatrixStack(), (float)(var17_23 + nameWidth + ((spacing += 12) - 12)), tooltipY, 500.0f, 10.0f, 10.0f, (float)iconColor.getRed() / 255.0f, (float)iconColor.getGreen() / 255.0f, (float)iconColor.getBlue() / 255.0f, 1.0f);
            }
            for (ResourceLocation icon : staticIcons) {
                RendererHelper.drawIcon(icon, event.getMatrixStack(), (float)(var17_23 + nameWidth + ((spacing += 12) - 12)), tooltipY, 500.0f, 10.0f, 10.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, mStack, (int)var17_23, tooltipY, font, tooltipTextWidth, tooltipHeight));
            IRenderTypeBuffer.Impl impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            mStack.func_227861_a_(0.0, 0.0, 400.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                ITextProperties line = textLines.get(lineNumber);
                if (line != null) {
                    font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)var17_23, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)impl, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            impl.func_228461_a_();
            mStack.func_227865_b_();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, mStack, (int)var17_23, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public static void drawAbilityIcon(AbilityCore core, MatrixStack matrixStack, float x, float y, int z, float u, float v) {
        RendererHelper.drawAbilityIcon(core, matrixStack, x, y, z, u, v, 1.0f, 1.0f, 1.0f);
    }

    public static void drawAbilityIcon(AbilityCore core, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue) {
        RendererHelper.drawIcon(core.getIcon(), matrixStack, x, y, z, u, v, red, green, blue, 1.0f);
    }

    public static void drawIcon(ResourceLocation rs, MatrixStack matrixStack, float x, float y, float z, float u, float v) {
        RendererHelper.drawIcon(rs, matrixStack, x, y, z, u, v, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawIcon(ResourceLocation rs, MatrixStack matrixStack, float x, float y, float z, float u, float v, int intColor) {
        Color color = new Color(intColor);
        RendererHelper.drawIcon(rs, matrixStack, x, y, z, u, v, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
    }

    public static void drawIcon(ResourceLocation rs, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha) {
        RendererHelper.drawIcon(rs, matrixStack, x, y, z, u, v, red, green, blue, alpha, false);
    }

    public static void drawIcon(ResourceLocation rs, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, boolean flip) {
        float uvDir = flip ? -1.0f : 1.0f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, x, y + v, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, uvDir).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x + u, y + v, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(uvDir, uvDir).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x + u, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(uvDir, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.disableBlend();
    }

    public static void drawIcon(ResourceLocation rs, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, boolean flipX, boolean flipY) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        if (!flipX) {
            bufferbuilder.func_227888_a_(matrix, x, y + v, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, x + u, y + v, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, x + u, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        } else {
            bufferbuilder.func_227888_a_(matrix, x, y + v, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, x + u, y + v, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(-1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, x + u, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(-1.0f, -1.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, -1.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.disableBlend();
    }

    public static void drawQuad(MatrixStack matrixStack, IVertexBuilder buffer, float red, float green, float blue, float alpha, float x, float y, float width, float height, int lightmap) {
        RendererHelper.drawQuad(matrixStack, buffer, red, green, blue, alpha, x, y, width, height, 0.0f, 1.0f, lightmap);
    }

    public static void drawQuad(MatrixStack matrixStack, IVertexBuilder buffer, float red, float green, float blue, float alpha, float x, float y, float width, float height, float u, float v, int lightmap) {
        RendererHelper.drawQuad(matrixStack, buffer, red, green, blue, alpha, x, y, width, height, u, v, u, v, lightmap);
    }

    public static void drawQuad(MatrixStack matrixStack, IVertexBuilder buffer, float red, float green, float blue, float alpha, float x, float y, float width, float height, float u1, float v1, float u2, float v2, int lightmap) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = entry.func_227870_a_();
        Matrix3f matrix3f = entry.func_227872_b_();
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x, y + height, u1, v2, lightmap);
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x + width, y + height, v1, v2, lightmap);
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x + width, y, v1, u2, lightmap);
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x, y, u1, u2, lightmap);
    }

    public static void drawVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float x, float y, float texU, float texV, int lightmap) {
        bufferIn.func_227888_a_(matrixPos, x, y, 0.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void drawPlayerFactionIcon(String faction, @Nullable LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightmap) {
        RendererHelper.drawPlayerFactionIcon(faction, entity, matrixStack, buffer, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, lightmap);
    }

    public static void drawPlayerFactionIcon(String faction, @Nullable LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, float x, float y, float width, float height, float u1, float v1, float u2, float v2, int lightmap) {
        if (faction.equalsIgnoreCase("pirate")) {
            ExtendedWorldData worldData;
            Crew crew;
            if (entity != null && (crew = (worldData = ExtendedWorldData.get((IWorld)entity.field_70170_p)).getCrewWithMember(entity.func_110124_au())) != null) {
                RendererHelper.drawPlayerJollyRoger(crew.getJollyRoger(), matrixStack, buffer, lightmap);
            }
        } else if (faction.equalsIgnoreCase("revolutionary")) {
            matrixStack.func_227861_a_(-0.4, -0.42, 0.0);
            matrixStack.func_227862_a_(4.0f, 4.0f, 1.0f);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(ModRenderTypes.getWantedPoster(ModResources.REVOLUTIONARY_ARMY_ICON_GREYSCALE));
            RendererHelper.drawQuad(matrixStack, ivertexbuilder, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f, 0.5f, lightmap);
        } else if (faction.equalsIgnoreCase("marine")) {
            matrixStack.func_227861_a_(-0.5, -0.5, 0.0);
            matrixStack.func_227862_a_(4.0f, 4.0f, 1.0f);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(ModRenderTypes.getWantedPoster(ModResources.MARINE_ICON));
            RendererHelper.drawQuad(matrixStack, ivertexbuilder, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.5f, 0.5f, lightmap);
        } else if (faction.equalsIgnoreCase("world_government")) {
            matrixStack.func_227861_a_(-0.4, -0.42, 0.0);
            matrixStack.func_227862_a_(4.0f, 4.0f, 1.0f);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(ModRenderTypes.getWantedPoster(ModResources.WORLD_GOV_ICON));
            RendererHelper.drawQuad(matrixStack, ivertexbuilder, (float)WORLD_GOVT_COLOR.getRed() / 255.0f, (float)WORLD_GOVT_COLOR.getGreen() / 255.0f, (float)WORLD_GOVT_COLOR.getBlue() / 255.0f, 1.0f, 0.0f, 0.0f, 0.5f, 0.5f, lightmap);
        }
    }

    public static void drawPlayerJollyRoger(JollyRoger jollyRoger, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightmap) {
        RendererHelper.drawPlayerJollyRoger(jollyRoger, matrixStack, buffer, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, lightmap);
    }

    public static void drawPlayerJollyRoger(JollyRoger jollyRoger, MatrixStack matrixStack, IRenderTypeBuffer buffer, float x, float y, float width, float height, float u1, float v1, float u2, float v2, int lightmap) {
        float alpha;
        float blue;
        float green;
        float red;
        for (JollyRogerElement element : jollyRoger.getBackgrounds()) {
            if (element == null || element.getTexture() == null) continue;
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
            alpha = 1.0f;
            if (element.canBeColored()) {
                red = (float)element.getRed() / 255.0f;
                green = (float)element.getGreen() / 255.0f;
                blue = (float)element.getBlue() / 255.0f;
            }
            RendererHelper.drawQuad(matrixStack, buffer.getBuffer(ModRenderTypes.getWantedPoster(element.getTexture())), red, green, blue, alpha, x, y, width, height, u1, v1, u2, v2, lightmap);
        }
        if (jollyRoger.getBase() != null && jollyRoger.getBase().getTexture() != null) {
            float red2 = 1.0f;
            float green2 = 1.0f;
            float blue2 = 1.0f;
            float alpha2 = 1.0f;
            if (jollyRoger.getBase().canBeColored()) {
                red2 = (float)jollyRoger.getBase().getRed() / 255.0f;
                green2 = (float)jollyRoger.getBase().getGreen() / 255.0f;
                blue2 = (float)jollyRoger.getBase().getBlue() / 255.0f;
            }
            RendererHelper.drawQuad(matrixStack, buffer.getBuffer(ModRenderTypes.getWantedPoster(jollyRoger.getBase().getTexture())), red2, green2, blue2, alpha2, x, y, width, height, u1, v1, u2, v2, lightmap);
        }
        for (JollyRogerElement element : jollyRoger.getDetails()) {
            if (element == null || element.getTexture() == null) continue;
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
            alpha = 1.0f;
            if (element.canBeColored()) {
                red = (float)element.getRed() / 255.0f;
                green = (float)element.getGreen() / 255.0f;
                blue = (float)element.getBlue() / 255.0f;
            }
            RendererHelper.drawQuad(matrixStack, buffer.getBuffer(ModRenderTypes.getWantedPoster(element.getTexture())), red, green, blue, alpha, x, y, width, height, u1, v1, u2, v2, lightmap);
        }
    }

    public static void drawPlayerJollyRoger(JollyRoger jollyRoger, MatrixStack matrixStack) {
        int i;
        for (JollyRogerElement element : jollyRoger.getBackgrounds()) {
            i = 0;
            if (element != null && element.getTexture() != null) {
                if (element.canBeColored()) {
                    RenderSystem.color3f((float)((float)element.getRed() / 255.0f), (float)((float)element.getGreen() / 255.0f), (float)((float)element.getBlue() / 255.0f));
                } else {
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(element.getTexture());
                GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)i);
            }
            --i;
        }
        if (jollyRoger.getBase() != null && jollyRoger.getBase().getTexture() != null) {
            if (jollyRoger.getBase().canBeColored()) {
                RenderSystem.color3f((float)((float)jollyRoger.getBase().getRed() / 255.0f), (float)((float)jollyRoger.getBase().getGreen() / 255.0f), (float)((float)jollyRoger.getBase().getBlue() / 255.0f));
            } else {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(jollyRoger.getBase().getTexture());
            GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)0.0f);
        }
        for (JollyRogerElement element : jollyRoger.getDetails()) {
            i = 0;
            if (element != null && element.getTexture() != null) {
                if (element.canBeColored()) {
                    RenderSystem.color3f((float)((float)element.getRed() / 255.0f), (float)((float)element.getGreen() / 255.0f), (float)((float)element.getBlue() / 255.0f));
                } else {
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(element.getTexture());
                GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)i);
            }
            ++i;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawA(IVertexBuilder vertexBuilder, Matrix4f matrix4f, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        vertexBuilder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void drawB(IVertexBuilder vertexBuilder, Matrix4f matrix4f, float y, float xz, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, -distance * xz, y, -0.5f * xz).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void drawC(IVertexBuilder vertexBuilder, Matrix4f matrix4f, float y, float xz, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, distance * xz, y, -0.5f * xz).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void drawD(IVertexBuilder vertexBuilder, Matrix4f matrix4f, float y, float z, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, 0.0f, y, z).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void renderVignette(Entity entity, float intensity, double width, double height) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float red = intensity;
        float green = intensity;
        float blue = intensity;
        if (intensity > 0.8f) {
            red = 0.0f;
            green = 1.0f;
            blue = 1.0f;
        }
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VANILLA_VIGNETTE_TEX_PATH);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, height, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(width, height, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(width, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }
}

