/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.CustomSpawnerTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModStructures;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class StructuresHelper {
    public static final List<BlockPos> SPAWNED_STRUCTURES = new ArrayList<BlockPos>();
    public static final int[] STRUCTURES_COUNT = new int[15];
    private static final ArrayList<RegistryObject<Structure<NoFeatureConfig>>> SHIP_STRUCTURES = Lists.newArrayList((Object[])new RegistryObject[]{ModStructures.GHOST_SHIP, ModStructures.MARINE_BATTLESHIP, ModStructures.PIRATE_LARGE_SHIP, ModStructures.PIRATE_MEDIUM_SHIP, ModStructures.PIRATE_SMALL_SHIP});
    private static final HashMap<StructureSpawnType, Map<StructureFaction, List<EntityType>>> SPAWN_TYPES = new HashMap();

    public static void spawnMobs(IWorld world, BlockPos pos, StructureFaction faction, StructureSpawnType type, int min, int max) {
        StructuresHelper.spawnMobs(world, pos, faction, type, (int)WyHelper.randomWithRange(min, max));
    }

    public static void spawnMobs(IWorld world, BlockPos pos, StructureFaction faction, StructureSpawnType type, int amount) {
        CustomSpawnerTileEntity spawner;
        if (world == null) {
            return;
        }
        List<EntityType> factionList = SPAWN_TYPES.get((Object)type).get((Object)faction);
        if (factionList == null || factionList.size() <= 0) {
            return;
        }
        EntityType spawnType = factionList.get((int)WyHelper.randomWithRange(0, factionList.size() - 1));
        if (spawnType == null) {
            return;
        }
        world.func_180501_a(pos, ((Block)ModBlocks.CUSTOM_SPAWNER.get()).func_176223_P(), 3);
        if (world.func_175625_s(pos) instanceof CustomSpawnerTileEntity && (spawner = (CustomSpawnerTileEntity)world.func_175625_s(pos)) != null) {
            spawner.setSpawnerLimit(amount);
            spawner.setSpawnerMob(spawnType);
        }
    }

    public static void spawnLoot(IWorld world, BlockPos pos, ResourceLocation lootTable) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        TileEntity tile = world.func_175625_s(pos.func_177977_b());
        if (tile instanceof ChestTileEntity) {
            ((ChestTileEntity)tile).func_189404_a(lootTable, world.func_201674_k().nextLong());
        }
    }

    public static boolean isInsideShip(ServerWorld world, BlockPos pos) {
        boolean flag = false;
        for (RegistryObject<Structure<NoFeatureConfig>> reg : SHIP_STRUCTURES) {
            StructureStart struct = world.func_241112_a_().func_235010_a_(pos, false, (Structure)reg.get());
            if (struct == StructureStart.field_214630_a) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isInsideModStructure(ServerWorld world, BlockPos pos, @Nullable StructureFaction faction) {
        boolean flag = false;
        for (Structure<?> reg : ModStructures.REGISTERED_STRUCTURES.keySet()) {
            StructureStart struct = world.func_241112_a_().func_235010_a_(pos, false, reg);
            if (struct == StructureStart.field_214630_a || faction != null && (!(reg instanceof OPStructure) || !((OPStructure)reg).getFaction().equals((Object)faction))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static List<BlockPos> createFilledSphere(World world, BlockPos origin, int radiusXZ, int radiusY, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (double y = (double)(y0 - radiusY); y < (double)(y0 + radiusY); y += 1.0) {
            for (double x = (double)(x0 - radiusXZ); x < (double)(x0 + radiusXZ); x += 1.0) {
                for (double z = (double)(z0 - radiusXZ); z < (double)(z0 + radiusXZ); z += 1.0) {
                    double distance = ((double)x0 - x) * ((double)x0 - x) + ((double)z0 - z) * ((double)z0 - z) + ((double)y0 - y) * ((double)y0 - y);
                    if (!(distance < (double)(radiusXZ * radiusY))) continue;
                    mutpos.func_189532_c(x, y, z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, state, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createHollowSphere(World world, BlockPos origin, int radiusXZ, int radiusY, int thickness, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int y = y0 - radiusY; y < y0 + radiusY; ++y) {
            for (int x = x0 - radiusXZ; x < x0 + radiusXZ; ++x) {
                for (int z = z0 - radiusXZ; z < z0 + radiusXZ; ++z) {
                    double distance = (x0 - x) * (x0 - x) + (z0 - z) * (z0 - z) + (y0 - y) * (y0 - y);
                    if (!(distance < (double)(radiusXZ * radiusY)) || !(distance >= (double)((radiusXZ - thickness) * (radiusXZ - thickness)))) continue;
                    mutpos.func_181079_c(x, y, z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, state, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createCenteredFilledCircle(World world, BlockPos origin, int radiusXZ, int height, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        WeightedList<BlockState> list = new WeightedList<BlockState>(state);
        return StructuresHelper.createCenteredFilledCircle(world, origin, radiusXZ, height, list, flags, rule);
    }

    public static List<BlockPos> createCenteredFilledCircle(World world, BlockPos origin, int radiusXZ, int height, WeightedList<BlockState> list, int flags, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (double y = 0.0; y < (double)height; y += 1.0) {
            for (double x = (double)(x0 - radiusXZ); x < (double)(x0 + radiusXZ); x += 1.0) {
                for (double z = (double)(z0 - radiusXZ); z < (double)(z0 + radiusXZ); z += 1.0) {
                    double distance = ((double)x0 - x) * ((double)x0 - x) + ((double)z0 - z) * ((double)z0 - z);
                    if (!(distance < (double)(radiusXZ * radiusXZ))) continue;
                    mutpos.func_189532_c(x, (double)y0 + y, z);
                    BlockState state = list.pick(world.func_201674_k());
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, state, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> fillCube(World world, BlockPos from, BlockPos to, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        MutableBoundingBox bb = new MutableBoundingBox((Vector3i)from, (Vector3i)to);
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)bb.field_78897_a, (int)bb.field_78895_b, (int)bb.field_78896_c, (int)bb.field_78893_d, (int)bb.field_78894_e, (int)bb.field_78892_f)) {
            if (!AbilityHelper.placeBlockIfAllowed(world, blockpos, state, flags, rule)) continue;
            blockPositions.add(blockpos.func_185334_h());
        }
        return blockPositions;
    }

    public static List<BlockPos> hollowCube(World world, BlockPos from, BlockPos to, int thickness, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        MutableBoundingBox bb = new MutableBoundingBox((Vector3i)from, (Vector3i)to);
        return StructuresHelper.hollowCube(world, bb, thickness, state, flags, rule);
    }

    public static List<BlockPos> hollowCube(World world, MutableBoundingBox bb, int thickness, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)bb.field_78897_a, (int)bb.field_78895_b, (int)bb.field_78896_c, (int)bb.field_78893_d, (int)bb.field_78894_e, (int)bb.field_78892_f)) {
            boolean isEdge = blockpos.func_177958_n() < bb.field_78897_a + thickness || blockpos.func_177958_n() > bb.field_78893_d - thickness || blockpos.func_177956_o() < bb.field_78895_b + thickness || blockpos.func_177956_o() > bb.field_78894_e - thickness || blockpos.func_177952_p() < bb.field_78896_c + thickness || blockpos.func_177952_p() > bb.field_78892_f - thickness;
            if (!isEdge || !AbilityHelper.placeBlockIfAllowed(world, blockpos, state, flags, rule)) continue;
            blockPositions.add(blockpos.func_185334_h());
        }
        return blockPositions;
    }

    public static List<BlockPos> createHollowCube(World world, BlockPos origin, int sizeX, int sizeY, int sizeZ, int thickness, BlockState state, int flags, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        int actualXSize = (int)Math.ceil((double)sizeX / 2.0);
        int actualYSize = (int)Math.ceil((double)sizeY / 2.0);
        int actualZSize = (int)Math.ceil((double)sizeZ / 2.0);
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -actualXSize; x < actualXSize; ++x) {
            for (int y = -actualYSize; y < actualYSize; ++y) {
                for (int z = -actualZSize; z < actualZSize; ++z) {
                    if (x >= -actualXSize + thickness && x < actualXSize - thickness && y >= -actualYSize + thickness && y < actualYSize - thickness && z >= -actualZSize + thickness && z < actualZSize - thickness) continue;
                    mutpos.func_181079_c(x0 + x, y0 + y, z0 + z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, state, flags, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createCenteredFilledCube(World world, BlockPos origin, int sizeX, int sizeY, int sizeZ, BlockState state, int flag, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        boolean isNegative = sizeY < 0;
        sizeY = Math.abs(sizeY);
        int actualXSize = (int)Math.ceil((double)sizeX / 2.0);
        int actualZSize = (int)Math.ceil((double)sizeZ / 2.0);
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -actualXSize; x < actualXSize; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = -actualZSize; z < actualZSize; ++z) {
                    mutpos.func_181079_c(x0 + x, isNegative ? y0 - y : y0 + y, z0 + z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, state, flag, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createFilledCube(World world, BlockPos origin, int sizeX, int sizeY, int sizeZ, BlockState state, int flag, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        int actualXSize = (int)Math.ceil((double)sizeX / 2.0);
        int actualYSize = (int)Math.ceil((double)sizeY / 2.0);
        int actualZSize = (int)Math.ceil((double)sizeZ / 2.0);
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -actualXSize; x < actualXSize; ++x) {
            for (int y = -actualYSize; y < actualYSize; ++y) {
                for (int z = -actualZSize; z < actualZSize; ++z) {
                    mutpos.func_181079_c(x0 + x, y0 + y, z0 + z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, (BlockPos)mutpos, state, flag, rule)) continue;
                    blockPositions.add(mutpos.func_185334_h());
                }
            }
        }
        return blockPositions;
    }

    static {
        SPAWN_TYPES.put(StructureSpawnType.GRUNT, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.MARINE_GRUNT.get()}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.PIRATE_GRUNT.get()}), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.BANDIT_GRUNT.get()}), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.CAPTAIN, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.MARINE_CAPTAIN.get()}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.PIRATE_CAPTAIN.get()}), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.BRUTE, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.MARINE_BRUTE.get()}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.PIRATE_BRUTE.get()}), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.BANDIT_BRUTE.get()}), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.SNIPER, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.MARINE_SNIPER.get()}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.BANDIT_SNIPER.get()}), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.TRADER, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.MARINE_TRADER.get()}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.PIRATE_TRADER.get()}), (Object)((Object)StructureFaction.SKYPIEAN), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.SKYPIEAN_TRADER.get()})));
        SPAWN_TYPES.put(StructureSpawnType.CIVILIAN, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.SKYPIEAN), (Object)Lists.newArrayList((Object[])new EntityType[]{(EntityType)ModEntities.SKYPIEAN_CIVILIAN.get()})));
    }

    public static enum StructureSpawnType {
        GRUNT,
        CAPTAIN,
        SNIPER,
        BRUTE,
        CIVILIAN,
        TRADER;

    }

    public static enum StructureFaction {
        MARINE,
        PIRATE,
        BANDIT,
        REVOLUTIONARY,
        SKYPIEAN,
        NEUTRAL;


        @Nullable
        public static StructureFaction from(String faction) {
            switch (faction) {
                case "marine": {
                    return MARINE;
                }
                case "pirate": {
                    return PIRATE;
                }
                case "bandit": {
                    return BANDIT;
                }
                case "revolutionary": {
                    return REVOLUTIONARY;
                }
            }
            return null;
        }
    }
}

