/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.protection;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import org.apache.commons.lang3.RandomStringUtils;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ProtectedArea {
    private BlockPos centerPos;
    private int size;
    private String label = "";
    private boolean allowBlockDestruction = false;
    private boolean allowEntityDamage = false;
    private boolean allowAbilities = false;
    private boolean allowBlockRestoration = false;
    private int restoreInterval = 20;
    private int restoreAmount = 15;
    private Map<BlockPlacingHelper.DistanceBlockPos, RestorationEntry> restoreBlocks = new HashMap<BlockPlacingHelper.DistanceBlockPos, RestorationEntry>();

    private ProtectedArea() {
    }

    public ProtectedArea(BlockPos center, int size, String label) {
        this.centerPos = center;
        this.setLabel(label);
        this.size = size;
    }

    public static ProtectedArea from(CompoundNBT nbt) {
        ProtectedArea area = new ProtectedArea();
        area.load(nbt);
        area.setLabel(area.getLabel());
        return area;
    }

    public void setBlockDestruction(boolean flag) {
        this.allowBlockDestruction = flag;
    }

    public boolean canDestroyBlocks() {
        return this.allowBlockDestruction;
    }

    public void setEntityDamage(boolean flag) {
        this.allowEntityDamage = flag;
    }

    public boolean canHurtEntities() {
        return this.allowEntityDamage;
    }

    public void setBlockRestoration(boolean flag) {
        this.allowBlockRestoration = flag;
    }

    public boolean canRestoreBlocks() {
        return this.allowBlockRestoration;
    }

    public void setAbilitiesUsage(boolean flag) {
        this.allowAbilities = flag;
    }

    public boolean canAbilitiesBeUsed() {
        return this.allowAbilities;
    }

    public boolean canUseAbility(AbilityCore core) {
        if (!this.allowAbilities) {
            boolean isWhitelisted = CommonConfig.INSTANCE.isAbilityProtectionWhitelisted(core);
            return isWhitelisted;
        }
        return true;
    }

    public void setRestoreInterval(int interval) {
        this.restoreInterval = interval;
    }

    public int getRestoreInterval() {
        return this.restoreInterval;
    }

    public void setRestoreAmount(int amount) {
        this.restoreAmount = amount;
    }

    public int getRestoreAmount() {
        return this.restoreAmount;
    }

    public void queueForRestoration(World world, BlockPos pos) {
        int hash = pos.func_177956_o() * 31 + pos.func_177952_p() + pos.func_177958_n();
        BlockPlacingHelper.DistanceBlockPos pos2 = new BlockPlacingHelper.DistanceBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), hash);
        this.queueForRestoration(pos2, new RestorationEntry(world.func_82737_E(), BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos, (int)2)));
    }

    public void queueForRestoration(BlockPlacingHelper.DistanceBlockPos pos, RestorationEntry entry) {
        this.restoreBlocks.putIfAbsent(pos, entry);
    }

    public void queueForRestoration(Map<BlockPlacingHelper.DistanceBlockPos, RestorationEntry> map) {
        map.entrySet().removeIf(e -> this.restoreBlocks.containsKey(e.getKey()));
        this.restoreBlocks.putAll(map);
    }

    public Map<BlockPlacingHelper.DistanceBlockPos, RestorationEntry> getRestorationMap() {
        return this.restoreBlocks;
    }

    public void restoreBlocks(World world) {
        int restoreLeft;
        if (this.getRestorationMap().size() <= 0 || !this.canRestoreBlocks()) {
            return;
        }
        if (this.getRestoreInterval() > 0 && world.func_82737_E() % (long)this.getRestoreInterval() != 0L) {
            return;
        }
        Iterator<Map.Entry<BlockPlacingHelper.DistanceBlockPos, RestorationEntry>> iter = this.getRestorationMap().entrySet().iterator();
        if (!iter.hasNext()) {
            return;
        }
        BlockPos[] removed = new BlockPos[restoreLeft];
        for (restoreLeft = this.restoreAmount; restoreLeft > 0 && iter.hasNext(); --restoreLeft) {
            Map.Entry<BlockPlacingHelper.DistanceBlockPos, RestorationEntry> entry = iter.next();
            if (world.func_82737_E() < entry.getValue().getTimestamp() + CommonConfig.INSTANCE.getGlobalProtectionGraceTime()) {
                return;
            }
            BlockPos pos = entry.getKey();
            if (CommonConfig.INSTANCE.stopRestorationNearPlayers()) {
                boolean hasPlayerNear = false;
                for (PlayerEntity player : world.func_217369_A()) {
                    if (!player.func_233580_cy_().func_218141_a((Vector3i)pos, 10.0)) continue;
                    hasPlayerNear = true;
                    break;
                }
                if (hasPlayerNear) {
                    return;
                }
            }
            if (!(entry.getValue().getSnapshot().getCurrentBlock().func_177230_c() instanceof FallingBlock)) {
                BlockState replaced = entry.getValue().getSnapshot().getReplacedBlock();
                world.func_180501_a(pos, replaced, 2);
                CompoundNBT nbt = entry.getValue().getSnapshot().getNbt();
                TileEntity te = null;
                if (nbt != null && (te = world.func_175625_s(pos)) != null) {
                    te.func_230337_a_(replaced, nbt);
                    te.func_70296_d();
                }
            }
            removed[restoreLeft - 1] = pos;
            iter.remove();
        }
        for (BlockPos pos : removed) {
            if (pos == null) continue;
            this.getRestorationMap().remove(pos);
        }
    }

    public void setLabel(String label) {
        this.label = this.checkValidLabel(label);
    }

    public String getLabel() {
        return WyHelper.getResourceName(this.label);
    }

    public BlockPos getCenter() {
        return this.centerPos;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isInside(int posX, int posY, int posZ) {
        int size = this.getSize() + 1;
        return posX < this.getCenter().func_177958_n() + size && posX > this.getCenter().func_177958_n() - size && posY < this.getCenter().func_177956_o() + size && posY > this.getCenter().func_177956_o() - size && posZ < this.getCenter().func_177952_p() + size && posZ > this.getCenter().func_177952_p() - size;
    }

    private String checkValidLabel(String label) {
        if (Strings.isNullOrEmpty((String)label)) {
            return RandomStringUtils.randomAlphabetic((int)5);
        }
        return WyHelper.getResourceName(label);
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("label", this.label);
        nbt.func_74768_a("x", this.centerPos.func_177958_n());
        nbt.func_74768_a("y", this.centerPos.func_177956_o());
        nbt.func_74768_a("z", this.centerPos.func_177952_p());
        nbt.func_74768_a("size", this.size);
        nbt.func_74757_a("allowBlockDestruction", this.allowBlockDestruction);
        nbt.func_74757_a("allowEntityDamage", this.allowEntityDamage);
        nbt.func_74757_a("allowBlockRestoration", this.allowBlockRestoration);
        nbt.func_74757_a("allowAbilities", this.allowAbilities);
        nbt.func_74768_a("restoreInterval", this.restoreInterval);
        nbt.func_74768_a("restoreAmount", this.restoreAmount);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        this.label = nbt.func_74779_i("label");
        int x = nbt.func_74762_e("x");
        int y = nbt.func_74762_e("y");
        int z = nbt.func_74762_e("z");
        this.centerPos = new BlockPos(x, y, z);
        this.size = nbt.func_74762_e("size");
        this.allowBlockDestruction = nbt.func_74767_n("allowBlockDestruction");
        this.allowEntityDamage = nbt.func_74767_n("allowEntityDamage");
        this.allowBlockRestoration = nbt.func_74767_n("allowBlockRestoration");
        this.allowAbilities = nbt.func_74767_n("allowAbilities");
        this.restoreInterval = nbt.func_74762_e("restoreInterval");
        this.restoreAmount = nbt.func_74762_e("restoreAmount");
    }

    public static class RestorationEntry {
        private long timestamp;
        private BlockSnapshot snapshot;

        public RestorationEntry(long timestamp, BlockSnapshot snapshot) {
            this.timestamp = timestamp;
            this.snapshot = snapshot;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public BlockSnapshot getSnapshot() {
            return this.snapshot;
        }
    }
}

