/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.quests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class Quest {
    private QuestId core;
    private List<Objective> objectives = new ArrayList<Objective>();
    protected IStarting onStartEvent = player -> true;
    protected ICompleting onCompleteEvent = player -> true;
    protected IShouldRestart shouldRestartEvent = player -> false;

    public Quest(QuestId core) {
        this.core = core;
    }

    public QuestId getCore() {
        return this.core;
    }

    public boolean equals(Object quest) {
        if (quest == null || this.getCore() == null) {
            return false;
        }
        if (quest instanceof Quest) {
            if (((Quest)quest).getCore() == null) {
                return false;
            }
            if (((Object)((Object)this.getCore())).equals((Object)((Quest)quest).getCore())) {
                return true;
            }
        } else if (quest instanceof QuestId && ((Object)((Object)this.getCore())).equals(quest)) {
            return true;
        }
        return false;
    }

    public boolean removeQuestItem(PlayerEntity player, Item item, int amount) {
        int id = WyHelper.getIndexOfItemStack(item, (IInventory)player.field_71071_by);
        if (id < 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Missing quest items: %s", new Object[]{new ItemStack((IItemProvider)item).func_200301_q().getString()}), Util.field_240973_b_);
            return false;
        }
        player.field_71071_by.func_70301_a(id).func_190918_g(amount);
        return true;
    }

    public boolean checkRestart(PlayerEntity player) {
        return this.shouldRestartEvent.check(player);
    }

    public boolean triggerCompleteEvent(PlayerEntity player) {
        return this.onCompleteEvent.check(player);
    }

    public boolean triggerStartEvent(PlayerEntity player) {
        return this.onStartEvent.check(player);
    }

    public void addObjectives(Objective ... objectives) {
        for (Objective obj : objectives) {
            this.addObjective(obj);
        }
    }

    public void addObjective(Objective objective) {
        if (!this.objectives.contains(objective)) {
            this.objectives.add(objective);
        }
    }

    public List<Objective> getObjectives() {
        return this.objectives;
    }

    public boolean isComplete() {
        return this.objectives.stream().allMatch(objective -> !objective.isOptional() && objective.isComplete());
    }

    public double getProgress() {
        int maxProgress = this.objectives.size();
        int completed = this.objectives.stream().filter(objective -> !objective.isOptional() && objective.isComplete()).collect(Collectors.toList()).size();
        double progress = (double)completed / (double)maxProgress;
        return progress;
    }

    public void resetProgress() {
        this.objectives.stream().forEach(o -> o.setProgress(0.0));
    }

    public boolean isLocked(IQuestData props) {
        return this.getCore().isLocked(props);
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.core.getRegistryName().toString());
        ListNBT objectivesData = new ListNBT();
        for (Objective obj : this.getObjectives()) {
            objectivesData.add((Object)obj.save());
        }
        nbt.func_218657_a("objectives", (INBT)objectivesData);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        ListNBT objectivesData = nbt.func_150295_c("objectives", 10);
        for (int i = 0; i < objectivesData.size(); ++i) {
            CompoundNBT questData = objectivesData.func_150305_b(i);
            this.getObjectives().get(i).load(questData);
        }
    }

    public static interface ICompleting
    extends Serializable {
        public boolean check(PlayerEntity var1);
    }

    public static interface IStarting
    extends Serializable {
        public boolean check(PlayerEntity var1);
    }

    public static interface IShouldRestart
    extends Serializable {
        public boolean check(PlayerEntity var1);
    }

    public static interface IFactory<A extends Quest> {
        public A create(QuestId<A> var1);
    }
}

