/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.quests.objectives;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class Objective {
    private String title;
    private String description;
    private boolean isHidden;
    private boolean isOptional;
    private double maxProgress = 1.0;
    private double progress;
    private boolean hasEvent;
    private boolean hasStartedEvent;
    private List<Objective> requirements = new ArrayList<Objective>();
    public IStartEvent onStartEvent = player -> {};
    public IRestartEvent onRestartEvent = player -> true;

    public Objective(String title) {
        this.title = title;
    }

    public void triggerStartEvent(PlayerEntity player) {
        this.hasStartedEvent = true;
        this.onStartEvent.start(player);
    }

    public void triggerRestartEvent(PlayerEntity player) {
        this.hasStartedEvent = false;
        this.onRestartEvent.restart(player);
    }

    public void setProgress(double progress) {
        this.progress = MathHelper.func_151237_a((double)progress, (double)0.0, (double)this.getMaxProgress());
    }

    public void alterProgress(double progress) {
        this.progress = MathHelper.func_151237_a((double)(this.progress + progress), (double)0.0, (double)this.getMaxProgress());
    }

    public double getProgress() {
        return this.progress;
    }

    public void setMaxProgress(double progress) {
        this.maxProgress = progress;
    }

    public double getMaxProgress() {
        return this.maxProgress;
    }

    public Objective addRequirements(Objective ... objectives) {
        for (Objective obj : objectives) {
            this.addRequirement(obj);
        }
        return this;
    }

    public Objective addRequirement(Objective objective) {
        if (!this.requirements.contains(objective)) {
            this.requirements.add(objective);
        }
        return this;
    }

    public Objective setDescription(String desc) {
        this.description = desc;
        return this;
    }

    public Objective setOptional() {
        this.isOptional = true;
        return this;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public Objective markHidden() {
        this.isHidden = true;
        return this;
    }

    public String getId() {
        return WyHelper.getResourceName(this.title);
    }

    public boolean isHidden() {
        return this.isHidden && this.isLocked();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isComplete() {
        return this.progress >= this.maxProgress;
    }

    public boolean isLocked() {
        if (this.requirements.size() <= 0) {
            return false;
        }
        return !this.requirements.stream().filter(o -> o != null).allMatch(o -> !o.isOptional() && o.isComplete());
    }

    public String getLocalizedTitle() {
        String objectiveKey = new TranslationTextComponent(String.format("quest.objective.mineminenomi.%s", this.getId())).func_150268_i();
        return new TranslationTextComponent(objectiveKey, new Object[]{(int)this.getMaxProgress()}).getString();
    }

    public void setHasEvent(boolean flag) {
        this.hasEvent = flag;
    }

    public boolean hasEvent() {
        return this.hasEvent;
    }

    public boolean hasStartedEvent() {
        return this.hasStartedEvent;
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.getId());
        nbt.func_74757_a("isHidden", this.isHidden);
        nbt.func_74780_a("progress", this.progress);
        nbt.func_74757_a("hasStartedEvent", this.hasStartedEvent);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        this.isHidden = nbt.func_74767_n("isHidden");
        this.progress = nbt.func_74769_h("progress");
        this.hasStartedEvent = nbt.func_74767_n("hasStartedEvent");
    }

    @FunctionalInterface
    public static interface IRestartEvent {
        public boolean restart(PlayerEntity var1);
    }

    @FunctionalInterface
    public static interface IStartEvent {
        public void start(PlayerEntity var1);
    }
}

