/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PriorityEventPool<E> {
    public static final int DEFAULT_PRIORITY = 100;
    private final Multimap<Integer, E> events = HashMultimap.create();
    private boolean isDirty;
    private long lastCount;

    public void addEvent(E event) {
        this.addEvent(100, event);
    }

    public void addEvent(int priority, E event) {
        this.events.put((Object)priority, event);
        this.isDirty = true;
    }

    public void removeEvent(E event) {
        if (this.events.containsValue(event)) {
            int eventKey = -1;
            Iterator iterator = this.events.keySet().iterator();
            block0: while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                if (eventKey >= 0) break;
                for (Object value : this.events.get((Object)key)) {
                    if (!value.equals(event)) continue;
                    eventKey = key;
                    continue block0;
                }
            }
            this.events.remove((Object)eventKey, event);
            this.isDirty = true;
        }
    }

    public Stream<E> getEventsStream() {
        return this.events.entries().stream().sorted((e1, e2) -> (Integer)e1.getKey() > (Integer)e2.getKey() ? 1 : -1).map(e -> e.getValue());
    }

    public boolean dispatchCancelable(Predicate<E> predicate) {
        long failedEvents = this.getEventsStream().filter(predicate).count();
        return failedEvents > 0L;
    }

    public void dispatch(Consumer<E> consumer) {
        this.getEventsStream().forEachOrdered(consumer);
    }

    public long countEventsInPool() {
        if (this.isDirty) {
            this.lastCount = this.getEventsStream().count();
            this.isDirty = false;
        }
        return this.lastCount;
    }
}

