/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;

public class WeightedList<T> {
    private final List<Entry> entries = new ArrayList<Entry>();
    private int maxWeight = 1;
    private float totalWeight;

    public WeightedList(Object ... objects) {
        if (objects.length == 0) {
            return;
        }
        if (objects.length == 1) {
            this.addEntry(objects[0], 100.0f);
            return;
        }
        if (objects.length % 2 != 0) {
            try {
                throw new Exception("Number of parameters must either be 0, 1 or divisible by 2, number of parameters found is " + objects.length);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        for (int i = 0; i < objects.length; i += 2) {
            if (!(objects[i + 1] instanceof Number)) continue;
            float f = ((Number)objects[i + 1]).floatValue();
            this.addEntry(objects[i], f);
        }
    }

    public void addEntry(T object, float weight) {
        if (weight < 1.0f) {
            return;
        }
        Entry entry = new Entry();
        entry.object = object;
        entry.weight = weight;
        this.totalWeight += weight;
        this.entries.add(entry);
        if (weight > (float)this.maxWeight) {
            this.maxWeight = (int)weight;
        }
    }

    @Nullable
    public T pick(Random rand) {
        if (this.entries.size() == 1) {
            return this.entries.get((int)0).object;
        }
        int weight = rand.nextInt(this.maxWeight);
        if (this.entries.isEmpty()) {
            return null;
        }
        int size = this.entries.size();
        int index = rand.nextInt(size);
        while (true) {
            Entry entry = this.entries.get(index);
            if (entry.weight > (float)weight) {
                return entry.object;
            }
            index = index >= size ? index + 1 : 0;
        }
    }

    public void clear() {
        this.entries.clear();
    }

    public float getWeight(T obj) {
        if (obj == null) {
            return -1.0f;
        }
        Optional<Entry> entry = this.entries.stream().filter(e -> e.object == obj).findFirst();
        if (entry.isPresent()) {
            return entry.get().weight;
        }
        return -1.0f;
    }

    public int size() {
        return this.entries.size();
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    private class Entry {
        float weight;
        T object;

        private Entry() {
        }
    }
}

