/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.PoneglyphTileEntity;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.init.ModChallenges;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PoneglyphBlock
extends Block {
    public static final IntegerProperty TEXTURE = IntegerProperty.func_177719_a((String)"texture", (int)0, (int)2);

    public PoneglyphBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_200943_b(Float.MAX_VALUE).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)TEXTURE, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public void initPoneglyph(IWorld world, BlockPos pos) {
        ChallengeCore challenge = null;
        for (BlockPos checkPos : WyHelper.getNearbyBlocks(pos, world, 2)) {
            TileEntity te = world.func_175625_s(checkPos);
            if (checkPos.equals((Object)pos) || !(te instanceof PoneglyphTileEntity)) continue;
            challenge = ((PoneglyphTileEntity)te).getChallenge();
            break;
        }
        if (challenge == null) {
            List list = ModRegistries.CHALLENGES.getValues().stream().filter(core -> core.getDifficulty() == ChallengeDifficulty.STANDARD).collect(Collectors.toList());
            Collections.shuffle(list);
            ChallengeCore possible = (ChallengeCore)((Object)list.get(0));
            challenge = possible != null ? possible : (ChallengeCore)ModChallenges.MORGAN.get();
        }
        PoneglyphTileEntity tileEntity = (PoneglyphTileEntity)world.func_175625_s(pos);
        tileEntity.setChallenge(challenge);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        blockstate = (BlockState)blockstate.func_206870_a((Property)TEXTURE, (Comparable)Integer.valueOf(context.func_195991_k().func_201674_k().nextInt(3)));
        return blockstate;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        PoneglyphTileEntity tileEntity = (PoneglyphTileEntity)world.func_175625_s(pos);
        if (WyHelper.isInChallengeDimension(world)) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (tileEntity.getChallenge() == null) {
            this.initPoneglyph((IWorld)world, pos);
        }
        if (tileEntity.getEntryType() == PoneglyphTileEntity.Type.CHALLENGE) {
            boolean hasPaper = player.field_71071_by.func_213902_a((Set)ImmutableSet.of((Object)Items.field_151121_aF));
            if (hasPaper) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_190926_b() || stack.func_77973_b() != Items.field_151121_aF || stack.func_196082_o().func_74762_e("type") > 0) continue;
                    stack.func_190918_g(1);
                    IChallengesData props = ChallengesDataCapability.get(player);
                    ChallengeCore<?> challenge = tileEntity.getChallenge();
                    if (props.hasChallenge(challenge)) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.CHALLENGE_MESSAGE_ALREADY_UNLOCKED, new Object[]{challenge.getLocalizedTitle()}), Util.field_240973_b_);
                    } else {
                        props.addChallenge(challenge);
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.CHALLENGE_MESSAGE_UNLOCKED, new Object[]{challenge.getLocalizedTitle()}), Util.field_240973_b_);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.CHALLENGE_MESSAGE_INSCRIPTION_NO_PAPER), Util.field_240973_b_);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (world instanceof World && WyHelper.isInChallengeDimension((World)world)) {
            return null;
        }
        return new PoneglyphTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TEXTURE});
    }
}

