/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks.tileentities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModTileEntities;

public class FlagTileEntity
extends TileEntity
implements ITickableTileEntity {
    private UUID ownerUUID = Util.field_240973_b_;
    private String faction = "";
    private boolean isOnFire;
    private int fireTick = 200;
    @Nullable
    private Entity lastAttacker;
    private BlockPos masterPos;
    private FlagTileEntity master;
    private boolean isSub;
    private List<BlockPos> subsList = new ArrayList<BlockPos>();

    public FlagTileEntity() {
        super((TileEntityType)ModTileEntities.FLAG.get());
    }

    public void setOnFire(boolean onFire) {
        this.isOnFire = onFire;
        if (onFire) {
            this.fireTick = 200;
        }
    }

    public boolean isOnFire() {
        return this.isOnFire;
    }

    public void setLastAttacker(Entity attacker) {
        this.lastAttacker = attacker;
    }

    @Nullable
    public Entity getLastAttacker() {
        return this.lastAttacker;
    }

    public void setFaction(String factionName) {
        this.faction = factionName;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.ownerUUID = owner.func_110124_au();
            this.faction = EntityStatsCapability.get(owner).getFaction();
        }
    }

    public String getFaction() {
        return this.faction;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean isMaster() {
        return !this.isSub();
    }

    public boolean isSub() {
        return this.isSub;
    }

    @Nullable
    public FlagTileEntity getMaster() {
        TileEntity tileEntity;
        if (!this.isSub) {
            return this;
        }
        if (this.field_145850_b != null && this.masterPos != null && this.master == null && (tileEntity = this.field_145850_b.func_175625_s(this.masterPos)) instanceof FlagTileEntity) {
            this.master = (FlagTileEntity)tileEntity;
        }
        return this.master;
    }

    public void setMaster(FlagTileEntity flagTile) {
        this.masterPos = flagTile.func_174877_v();
        this.master = flagTile;
        this.isSub = true;
    }

    public void addSub(BlockPos pos) {
        this.subsList.add(pos);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.isOnFire()) {
            if (this.isSub) {
                if (this.field_145850_b.func_72896_J()) {
                    this.master.setOnFire(false);
                    return;
                }
                this.master.setOnFire(true);
            } else {
                if (this.field_145850_b.func_72896_J()) {
                    this.setOnFire(false);
                    return;
                }
                if (--this.fireTick <= 0) {
                    this.breakAllBlocks(false);
                }
            }
        }
    }

    public void breakAllBlocks(boolean instabuild) {
        boolean drop;
        if (this.isSub()) {
            return;
        }
        boolean bl = drop = !this.isOnFire;
        if (instabuild) {
            drop = false;
        }
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175655_b(this.func_174877_v(), drop);
            for (BlockPos pos : this.subsList) {
                this.func_145831_w().func_175655_b(pos, false);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_186854_a("ownerUUID", this.ownerUUID);
        nbt.func_74778_a("faction", this.faction);
        nbt.func_74757_a("isOnFire", this.isOnFire);
        nbt.func_74768_a("fireTicks", this.fireTick);
        nbt.func_74757_a("isSub", this.isSub);
        if (this.isSub) {
            nbt.func_74772_a("masterPos", this.masterPos.func_218275_a());
        } else {
            LongArrayNBT subs = new LongArrayNBT(new ArrayList());
            for (BlockPos pos : this.subsList) {
                long longPos = pos.func_218275_a();
                subs.add((Object)LongNBT.func_229698_a_((long)longPos));
            }
            nbt.func_218657_a("subs", (INBT)subs);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.ownerUUID = nbt.func_186857_a("ownerUUID");
        this.faction = nbt.func_74779_i("faction");
        this.isOnFire = nbt.func_74767_n("isOnFire");
        this.fireTick = nbt.func_74762_e("fireTicks");
        this.isSub = nbt.func_74767_n("isSub");
        if (this.isSub) {
            this.masterPos = BlockPos.func_218283_e((long)nbt.func_74763_f("masterPos"));
        } else {
            long[] subs = nbt.func_197645_o("subs");
            for (int i = 0; i < subs.length; ++i) {
                BlockPos subPos = BlockPos.func_218283_e((long)subs[i]);
                this.subsList.add(subPos);
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        this.func_189515_b(nbttagcompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }
}

