/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks.tileentities;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModTileEntities;

public class WantedPosterTileEntity
extends TileEntity
implements ITickableTileEntity {
    private String uuid = "";
    private String entityName = "";
    private String bounty = "";
    private String faction = "";
    private String date = "";
    private String background = "";
    private GameProfile gameProfile;

    public WantedPosterTileEntity() {
        super((TileEntityType)ModTileEntities.WANTED_POSTER.get());
    }

    public void func_73660_a() {
        if (Strings.isNullOrEmpty((String)this.getUUID()) || !Strings.isNullOrEmpty((String)this.getBackground())) {
            return;
        }
        PlayerEntity player = this.func_145831_w().func_217371_b(UUID.fromString(this.getUUID()));
        if (player == null) {
            return;
        }
        long bounty = Long.parseLong(this.getPosterBounty());
        CompoundNBT nbt = ItemsHelper.setPlayerWantedData((IWorld)this.func_145831_w(), this.getUUID(), bounty);
        this.uuid = nbt.func_74779_i("UUID");
        this.entityName = nbt.func_74779_i("Name");
        this.bounty = nbt.func_74763_f("Bounty") + "";
        this.faction = nbt.func_74779_i("Faction");
        this.date = nbt.func_74779_i("Date");
        this.background = nbt.func_74779_i("Background");
        if (nbt.func_150297_b("Owner", 10)) {
            this.setGameProfile(NBTUtil.func_152459_a((CompoundNBT)nbt.func_74775_l("Owner")));
        }
    }

    public void setGameProfile(GameProfile gp) {
        this.gameProfile = gp;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String name) {
        this.entityName = name;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setPosterBounty(String bounty) {
        this.bounty = bounty;
    }

    public String getPosterBounty() {
        return this.bounty;
    }

    public void setFaction(String faction) {
        this.faction = faction;
    }

    public String getFaction() {
        return this.faction;
    }

    public boolean isPirate() {
        return this.faction.equalsIgnoreCase("pirate");
    }

    public boolean isRevolutionary() {
        return this.faction.equalsIgnoreCase("revolutionary");
    }

    public void setIssuedDate(String date) {
        this.date = date;
    }

    public String getIssuedDate() {
        return this.date;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.entityName == null || this.bounty == null || this.date == null || this.background == null) {
            return nbt;
        }
        nbt.func_74778_a("UUID", this.uuid);
        nbt.func_74778_a("Name", this.entityName);
        nbt.func_74778_a("Bounty", this.bounty);
        nbt.func_74778_a("Faction", this.faction);
        nbt.func_74778_a("Date", this.date);
        nbt.func_74778_a("Background", this.background);
        if (this.gameProfile != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)this.gameProfile);
            nbt.func_218657_a("Owner", (INBT)compoundnbt);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.uuid = nbt.func_74779_i("UUID");
        this.entityName = nbt.func_74779_i("Name");
        this.bounty = nbt.func_74779_i("Bounty");
        this.faction = nbt.func_74779_i("Faction");
        this.date = nbt.func_74779_i("Date");
        this.background = nbt.func_74779_i("Background");
        if (nbt.func_150297_b("Owner", 10)) {
            this.setGameProfile(NBTUtil.func_152459_a((CompoundNBT)nbt.func_74775_l("Owner")));
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        this.func_189515_b(nbttagcompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }
}

