/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.ArlongParkPart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;

public class ArlongParkSimpleArena
extends ChallengeArena {
    public static final ArlongParkSimpleArena INSTANCE = new ArlongParkSimpleArena();
    private static final int ARENA_XZ_SIZE_RADIUS = 50;
    private static final int ARENA_Y_SIZE_RADIUS = 50;
    private static final int ARENA_XZ_SIZE = 100;

    private ArlongParkSimpleArena() {
        super(ArenaStyle.SIMPLE);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        blocks.addAll(new ArlongParkPart(challenge, 50, bottomLayer).buildPart(challenge.getShard(), challenge.getArenaPos()));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 100, 2, 100, Blocks.field_150354_m.func_176223_P(), 0, null));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-50, -50, -50, 50, 50, 50);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 30 - (posId + 1), challenge.getArenaPos().func_177956_o() - 12, challenge.getArenaPos().func_177952_p() - 40);
        return new ChallengeArena.SpawnPosition(pos, 0.0f, 0.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 30, challenge.getArenaPos().func_177956_o() - 12, challenge.getArenaPos().func_177952_p() + 40);
        return ChallengesHelper.get4DefaultSpawnPoints(pos, 180.0f);
    }
}

