/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.RampPart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.TreePart;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SyrupHillSimpleArena
extends ChallengeArena {
    public static final SyrupHillSimpleArena INSTANCE = new SyrupHillSimpleArena();
    private static final int ARENA_X_SIZE_RADIUS = 70;
    private static final int ARENA_Z_SIZE_RADIUS = 50;
    private static final int ARENA_Y_SIZE_RADIUS = 50;
    private static final int ARENA_X_SIZE = 140;
    private static final int ARENA_Z_SIZE = 100;
    private static final int GROUND_LEVEL = 30;
    private final WeightedList<BlockState> floorBlocks = new WeightedList(Blocks.field_150348_b.func_176223_P(), 100, Blocks.field_196656_g.func_176223_P(), 50, Blocks.field_150351_n.func_176223_P(), 40, Blocks.field_150347_e.func_176223_P(), 20, Blocks.field_150341_Y.func_176223_P(), 5);
    private final WeightedList<BlockState> cliffBlocks = new WeightedList(Blocks.field_150348_b.func_176223_P(), 100, Blocks.field_196656_g.func_176223_P(), 50, Blocks.field_150351_n.func_176223_P(), 40);
    private final WeightedList<BlockState> slabsBlocks = new WeightedList(Blocks.field_150333_U.func_176223_P(), 100, Blocks.field_222455_ls.func_176223_P(), 50, Blocks.field_196646_bz.func_176223_P(), 40, Blocks.field_150351_n.func_176223_P(), 40, Blocks.field_150348_b.func_176223_P(), 10, Blocks.field_150347_e.func_176223_P(), 20, Blocks.field_222450_ln.func_176223_P(), 5);
    private static final BlockProtectionRule ONLY_AIR_AND_WATER = new BlockProtectionRule.Builder(new BlockProtectionRule[0]).addApprovedMaterials(Material.field_151579_a, Material.field_151586_h).build();

    private SyrupHillSimpleArena() {
        super(ArenaStyle.SIMPLE);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        BlockPos groundLayer = bottomLayer.func_177981_b(30);
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 139, 30, 99, Blocks.field_150355_j.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), bottomLayer.func_177981_b(3).func_177982_a(-70, 0, 0), 98, 6, this.floorBlocks, 0, ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), bottomLayer.func_177981_b(9).func_177982_a(-70, 0, 0), 95, 8, this.floorBlocks, 0, ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), bottomLayer.func_177977_b().func_177982_a(-70, 0, 0), 90, 30, this.floorBlocks, 0, ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), groundLayer.func_177977_b().func_177982_a(-70, 0, 0), 89, 2, this.floorBlocks, 0, ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), groundLayer.func_177982_a(-74, 0, 0), 90, 25, this.cliffBlocks, 0, ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), groundLayer.func_177982_a(-74, 25, 0), 90, 1, Blocks.field_196658_i.func_176223_P(), 0, null));
        StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177982_a(-20, 15, 0), 100, 25, 25, Blocks.field_150350_a.func_176223_P(), 3, null);
        StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177982_a(-10, 9, 0), 60, 25, 25, Blocks.field_150350_a.func_176223_P(), 3, null);
        StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177982_a(17, 1, 0), 60, 25, 25, Blocks.field_150350_a.func_176223_P(), 3, null);
        blocks.addAll(new RampPart(challenge, 26, 12, this.slabsBlocks, this.cliffBlocks, Direction.EAST).buildPart(challenge.getShard(), groundLayer.func_177982_a(-71, 20, -14)));
        blocks.addAll(new RampPart(challenge, 26, 12, this.slabsBlocks, this.cliffBlocks, Direction.EAST).buildPart(challenge.getShard(), groundLayer.func_177982_a(-41, 14, -14)));
        blocks.addAll(new RampPart(challenge, 26, 16, this.slabsBlocks, this.cliffBlocks, Direction.EAST).buildPart(challenge.getShard(), groundLayer.func_177982_a(-14, 8, -14)));
        BlockPos topRightLayer = groundLayer.func_177982_a(-15, 26, 32);
        blocks.addAll(this.populateTrees(challenge, topRightLayer));
        BlockPos topRightLayer2 = groundLayer.func_177982_a(-40, 26, 32);
        blocks.addAll(this.populateTrees(challenge, topRightLayer2));
        BlockPos topLeftLayer = groundLayer.func_177982_a(-15, 26, -32);
        blocks.addAll(this.populateTrees(challenge, topLeftLayer));
        BlockPos topLeftLayer2 = groundLayer.func_177982_a(-40, 26, -32);
        blocks.addAll(this.populateTrees(challenge, topLeftLayer2));
        blocks.addAll(this.populateTrees(challenge, topLeftLayer2));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 140, 2, 100, Blocks.field_150354_m.func_176223_P(), 0, null));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    private Set<BlockPos> populateTrees(InProgressChallenge challenge, BlockPos pos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (int i = 0; i < 40; ++i) {
            int offsetX = (int)WyHelper.randomWithRange(challenge.getRNG(), -30, 30);
            int offsetZ = (int)WyHelper.randomWithRange(challenge.getRNG(), -30, 30);
            mutpos.func_189533_g((Vector3i)pos.func_177982_a(offsetX, -1, offsetZ));
            if (challenge.getShard().func_180495_p((BlockPos)mutpos).func_177230_c() != Blocks.field_196658_i) continue;
            ConfiguredFeature treeType = challenge.getRNG().nextBoolean() ? Features.field_243862_bH : Features.field_243864_bJ;
            blocks.addAll(new TreePart(challenge, treeType, challenge.getRNG().nextInt(10)).buildPart(challenge.getShard(), mutpos.func_185334_h()));
        }
        return blocks;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-70, -50, -50, 70, 50, 50);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 14 - (posId + 1), challenge.getArenaPos().func_177956_o() - 10, challenge.getArenaPos().func_177952_p());
        return new ChallengeArena.SpawnPosition(pos, -90.0f, 23.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 10, challenge.getArenaPos().func_177956_o() - 17, challenge.getArenaPos().func_177952_p());
        return ChallengesHelper.get4DefaultSpawnPoints(pos, 90.0f, -23.0f);
    }
}

