/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;

public class ArlongParkPart
extends ArenaPart {
    private static final int GROUND_LEVEL = 35;
    private static final int PIER_DISTANCE = 40;
    private static final int PIER_LENGTH = 45;
    private static final int PIER_WIDTH = 10;
    private static final int PIER_HEIGHT = 35;
    private static final int FENCE_HEIGHT = 7;
    private final int arenaSizeRadius;
    private final BlockPos bottomLayer;

    public ArlongParkPart(InProgressChallenge challenge, int arenaSizeRadius, BlockPos bottomLayer) {
        super(challenge);
        this.arenaSizeRadius = arenaSizeRadius;
        this.bottomLayer = bottomLayer;
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        HashSet blocks = Sets.newHashSet();
        BlockPos bottomNECorner = this.bottomLayer.func_177964_d(this.arenaSizeRadius - 1).func_177965_g(this.arenaSizeRadius - 2);
        BlockPos splitSWCorner = this.bottomLayer.func_177981_b(35).func_177985_f(10).func_177970_e(this.arenaSizeRadius - 2);
        BlockPos splitNWCorner = this.bottomLayer.func_177981_b(35).func_177985_f(10).func_177964_d(this.arenaSizeRadius - 1);
        BlockPos bottomNWCorner = this.bottomLayer.func_177964_d(this.arenaSizeRadius - 1).func_177985_f(this.arenaSizeRadius - 1);
        BlockPos groundLayer = this.bottomLayer.func_177981_b(36);
        blocks.addAll(StructuresHelper.fillCube((World)world, bottomNECorner, splitSWCorner, Blocks.field_150355_j.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)world, splitSWCorner, bottomNWCorner, Blocks.field_150348_b.func_176223_P(), 0, null));
        BlockPos firstPierStart = splitSWCorner.func_177964_d(this.arenaSizeRadius / 3 + 3);
        BlockPos firstPierEnd = firstPierStart.func_177965_g(45).func_177964_d(10);
        blocks.addAll(StructuresHelper.fillCube((World)world, firstPierStart, firstPierEnd.func_177979_c(35), Blocks.field_150348_b.func_176223_P(), 0, null));
        BlockPos secondPierStart = firstPierStart.func_177964_d(50);
        BlockPos secondPierEnd = secondPierStart.func_177965_g(45).func_177964_d(10);
        blocks.addAll(StructuresHelper.fillCube((World)world, secondPierStart, secondPierEnd.func_177979_c(35), Blocks.field_150348_b.func_176223_P(), 0, null));
        BlockPos southFenceStart = groundLayer.func_177970_e(this.arenaSizeRadius - 2).func_177985_f(this.arenaSizeRadius - 1);
        BlockPos southFenceEnd = southFenceStart.func_177965_g(this.arenaSizeRadius * 2 - 2).func_177981_b(7);
        blocks.addAll(StructuresHelper.fillCube((World)world, southFenceStart, southFenceEnd, Blocks.field_222413_lB.func_176223_P(), 256, null));
        blocks.addAll(StructuresHelper.fillCube((World)world, southFenceStart.func_177981_b(8), southFenceEnd.func_177981_b(1), Blocks.field_150411_aY.func_176223_P(), 256, null));
        blocks.addAll(StructuresHelper.fillCube((World)world, southFenceStart.func_177977_b(), southFenceEnd.func_177978_c().func_177979_c(42), Blocks.field_150348_b.func_176223_P(), 0, null));
        BlockPos northFenceStart = groundLayer.func_177964_d(this.arenaSizeRadius - 1).func_177985_f(this.arenaSizeRadius - 1);
        BlockPos northFenceEnd = northFenceStart.func_177965_g(this.arenaSizeRadius * 2 - 2).func_177981_b(7);
        blocks.addAll(StructuresHelper.fillCube((World)world, northFenceStart, northFenceEnd, Blocks.field_222413_lB.func_176223_P(), 256, null));
        blocks.addAll(StructuresHelper.fillCube((World)world, northFenceStart.func_177981_b(8), northFenceEnd.func_177981_b(1), Blocks.field_150411_aY.func_176223_P(), 256, null));
        blocks.addAll(StructuresHelper.fillCube((World)world, northFenceStart.func_177977_b(), northFenceEnd.func_177968_d().func_177979_c(42), Blocks.field_150348_b.func_176223_P(), 0, null));
        BlockPos westFenceStart = southFenceStart.func_177981_b(7);
        BlockPos westFenceEnd = northFenceStart;
        blocks.addAll(StructuresHelper.fillCube((World)world, westFenceStart, westFenceEnd, Blocks.field_222413_lB.func_176223_P(), 256, null));
        blocks.addAll(StructuresHelper.fillCube((World)world, westFenceStart.func_177981_b(1), northFenceStart.func_177981_b(8), Blocks.field_150411_aY.func_176223_P(), 256, null));
        int gateWidth = 10;
        return blocks;
    }
}

