/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;

public class SimpleBasePart
extends ArenaPart {
    private boolean hasBedrock;

    public SimpleBasePart(InProgressChallenge challenge) {
        this(challenge, true);
    }

    public SimpleBasePart(InProgressChallenge challenge, boolean hasBedrock) {
        super(challenge);
        this.hasBedrock = hasBedrock;
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        BlockPos bottomLayer = spawnPos.func_185334_h().func_177979_c(Math.abs(this.getParent().getArenaLimits().field_78895_b) - 1);
        int xSize = this.getParent().getArenaLimits().func_78883_b() - 1;
        int zSize = this.getParent().getArenaLimits().func_78880_d() - 1;
        MutableBoundingBox bb = this.getParent().getArenaLimits();
        int barrierLimit = 4;
        for (int i = -barrierLimit; i < 1; ++i) {
            BlockPos from = spawnPos.func_177982_a(bb.field_78897_a + i, bb.field_78895_b + i, bb.field_78896_c + i);
            BlockPos to = spawnPos.func_177982_a(bb.field_78893_d - 1 - i, bb.field_78894_e - 1 - i, bb.field_78892_f - 1 - i);
            blocks.addAll(StructuresHelper.hollowCube((World)world, from, to, 1, Blocks.field_180401_cv.func_176223_P(), 0, null));
        }
        if (this.hasBedrock) {
            blocks.addAll(StructuresHelper.createCenteredFilledCube((World)world, bottomLayer, xSize, 1, zSize, Blocks.field_150357_h.func_176223_P(), 0, null));
        }
        return blocks;
    }
}

