/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.kriegpirates;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.challenges.arenas.BaratieSimpleArena;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.DonKriegEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModChallenges;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class DonKriegChallenge
extends Challenge {
    private static final String TITLE = WyRegistry.registerName("challenge.mineminenomi.krieg_pirates.don_krieg", "Don Krieg");
    public static final String OBJECTIVE = WyRegistry.registerName("challenge.mineminenomi.krieg_pirates.don_krieg.objective", "Defeat Don Krieg");
    public static final ResourceLocation REWARD = new ResourceLocation("mineminenomi", "rewards/don_krieg");
    public static final ChallengeCore<DonKriegChallenge> INSTANCE = new ChallengeCore.Builder<Challenge>("don_krieg", TITLE, OBJECTIVE, ModNPCGroups.KRIEG_PIRATES.getName(), DonKriegChallenge::new).setDifficulty(ChallengeDifficulty.STANDARD).setDifficultyStars(1).addArena(ArenaStyle.SIMPLE, BaratieSimpleArena.INSTANCE, BaratieSimpleArena::getChallengerSpawnPos, BaratieSimpleArena::getEnemySpawnPos).setEnemySpawns(DonKriegChallenge::setEnemeySpawns).setTargetShowcase(DonKriegChallenge::createKriegShowcase).setTimeLimit(10).setOrder(ModChallenges.Order.DON_KRIEG).setRewards(REWARD).build();

    public DonKriegChallenge(ChallengeCore<DonKriegChallenge> core) {
        super(core);
    }

    public static Set<ChallengeArena.EnemySpawn> setEnemeySpawns(InProgressChallenge challenge, ChallengeArena.SpawnPosition[] spawns) {
        HashSet<ChallengeArena.EnemySpawn> set = new HashSet<ChallengeArena.EnemySpawn>();
        DonKriegEntity boss = new DonKriegEntity(challenge);
        set.add(new ChallengeArena.EnemySpawn((LivingEntity)boss, spawns[0]));
        return set;
    }

    public static LivingEntity createKriegShowcase(World world) {
        LivingEntity entity = (LivingEntity)((EntityType)ModEntities.DON_KRIEG.get()).func_200721_a(world);
        entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModArmors.WOOTZ_STEEL_ARMOR.get()));
        return entity;
    }
}

