/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CheckPlayerCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"check_player").requires(source -> source.func_197034_c(2));
        ((LiteralArgumentBuilder)builder.executes(context -> CheckPlayerCommand.checkPlayer((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), true))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"show_attributes", (ArgumentType)BoolArgumentType.bool()).executes(context -> CheckPlayerCommand.checkPlayer((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"), BoolArgumentType.getBool((CommandContext)context, (String)"show_attributes")))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int checkPlayer(CommandContext<CommandSource> context, ServerPlayerEntity player, boolean showAttributes) {
        try {
            IEntityStats statsData = EntityStatsCapability.get((LivingEntity)player);
            IDevilFruit fruitData = DevilFruitCapability.get((LivingEntity)player);
            IHakiData hakiData = HakiDataCapability.get((LivingEntity)player);
            ExtendedWorldData worldData = ExtendedWorldData.get((IWorld)player.field_70170_p);
            Crew crew = worldData.getCrewWithMember(player.func_110124_au());
            StringBuilder builder = new StringBuilder();
            builder.append("===============================================\n");
            builder.append("Name: " + player.func_145748_c_().getString() + "\n");
            builder.append("Faction: " + statsData.getFaction() + "\n");
            if (statsData.isMarine() || statsData.isRevolutionary()) {
                builder.append("Loyalty: " + statsData.getLoyalty() + "\n");
                String rank = statsData.isMarine() ? statsData.getMarineRank().getLocalizedName() : statsData.getRevolutionaryRank().getLocalizedName();
                builder.append("Rank: " + rank + "\n");
            }
            builder.append("Race: " + statsData.getRace() + "\n");
            if (statsData.isCyborg()) {
                builder.append("Max Cola: " + statsData.getMaxCola() + "\n");
                builder.append("Ultra Cola: " + statsData.getUltraCola() + "\n");
            }
            builder.append("Style: " + statsData.getFightingStyle() + "\n");
            builder.append("Doriki: " + statsData.getDoriki() + "\n");
            builder.append("Busoshoku Haki: " + hakiData.getBusoshokuHakiExp() + "\n");
            builder.append("Kenbunshoku Haki: " + hakiData.getKenbunshokuHakiExp() + "\n");
            builder.append("Belly: " + statsData.getBelly() + "\n");
            builder.append("Extol: " + statsData.getExtol() + "\n");
            if (BountyHelper.canGainBounty((PlayerEntity)player)) {
                builder.append("Bounty: " + statsData.getBounty() + "\n");
                builder.append("Issued Bounty: " + worldData.getBounty(player.func_110124_au().toString()) + "\n");
            }
            if (statsData.isPirate()) {
                builder.append("Crew: " + (crew != null ? crew.getName() : "None") + "\n");
            }
            ItemStack fruitStack = new ItemStack((IItemProvider)fruitData.getDevilFruitItem());
            builder.append("Devil Fruit: " + (!fruitStack.func_190926_b() ? fruitStack.func_200301_q().getString() : "None") + "\n");
            builder.append("Damage Multiplier: " + statsData.getDamageMultiplier() + "\n");
            if (WyDebug.isDebug()) {
                builder.append("In Combat ?: " + WyHelper.isInCombat((LivingEntity)player) + "\n");
                builder.append("Combat Cache Timer: " + statsData.getLastAttackTime() + "\n");
            }
            if (showAttributes) {
                builder.append("-----\n");
                builder.append("\u00a72Attribute | Current Value / Base Value\u00a7r\n");
                for (Attribute attr : ForgeRegistries.ATTRIBUTES.getValues()) {
                    ModifiableAttributeInstance modInst = player.func_233645_dx_().func_233779_a_(attr);
                    if (modInst == null || modInst.func_111126_e() == modInst.func_111125_b()) continue;
                    builder.append("- \u00a79" + modInst.func_111123_a().getRegistryName() + " | " + modInst.func_111126_e() + "/" + modInst.func_111125_b() + "\u00a7r\n");
                    for (AttributeModifier mod : modInst.func_225505_c_()) {
                        builder.append("  " + mod.func_111166_b() + " | " + mod.func_111164_d() + "\n");
                    }
                }
            }
            builder.append("===============================================");
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}

