/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.commands.CrewArgument;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CrewCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"crew").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197057_a((String)"crew_info").executes(context -> CrewCommand.getAllCrewsInfo((CommandContext<CommandSource>)context)));
        builder.then(Commands.func_197057_a((String)"crew_info_by_name").then(Commands.func_197056_a((String)"crew", (ArgumentType)CrewArgument.crew()).executes(context -> CrewCommand.getCrewInfo((CommandContext<CommandSource>)context, CrewArgument.getCrew(context, "crew")))));
        builder.then(Commands.func_197057_a((String)"create_crew").then(Commands.func_197056_a((String)"crew_name", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CrewCommand.createCrew((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"crew_name"), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove_all_crews").executes(context -> CrewCommand.removeAllCrews((CommandContext<CommandSource>)context, false))).then(Commands.func_197056_a((String)"--i-am-sure", (ArgumentType)BoolArgumentType.bool()).executes(context -> CrewCommand.removeAllCrews((CommandContext<CommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"--i-am-sure")))));
        builder.then(Commands.func_197057_a((String)"remove_crew").then(Commands.func_197056_a((String)"crew", (ArgumentType)CrewArgument.crew()).executes(context -> CrewCommand.removeCrew((CommandContext<CommandSource>)context, CrewArgument.getCrew(context, "crew")))));
        builder.then(Commands.func_197057_a((String)"add_member_to_crew").then(Commands.func_197056_a((String)"crew", (ArgumentType)CrewArgument.crew()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CrewCommand.addMemberToCrew((CommandContext<CommandSource>)context, CrewArgument.getCrew(context, "crew"), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))));
        builder.then(Commands.func_197057_a((String)"remove_member_from_crew").then(Commands.func_197056_a((String)"crew", (ArgumentType)CrewArgument.crew()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CrewCommand.removeMemberFromCrew((CommandContext<CommandSource>)context, CrewArgument.getCrew(context, "crew"), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))));
        builder.then(Commands.func_197057_a((String)"make_captain").then(Commands.func_197056_a((String)"crew", (ArgumentType)CrewArgument.crew()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CrewCommand.makeCaptain((CommandContext<CommandSource>)context, CrewArgument.getCrew(context, "crew"), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))));
        builder.then(Commands.func_197057_a((String)"download_jolly_roger").executes(ctx -> CrewCommand.downloadJollyRoger((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h())));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int downloadJollyRoger(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        Crew crew = worldData.getCrewWithCaptain(player.func_110124_au());
        if (crew != null) {
            String crewNameSnakeCase = WyHelper.stringToSnakeCase(crew.getName());
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd_HH.mm.ss");
            LocalDateTime now = LocalDateTime.now();
            String screenshotPath = String.format("%s/screenshots", FMLPaths.GAMEDIR.get());
            String filePath = String.format("%s/jolly_roger_%s_%s.png", screenshotPath, crewNameSnakeCase, dtf.format(now));
            TranslationTextComponent textComp = new TranslationTextComponent(ModI18n.GUI_SAVED_JOLLY_ROGER);
            StringTextComponent emptyComp = new StringTextComponent(" ");
            File outputFile = new File(filePath);
            try {
                outputFile.getParentFile().mkdirs();
                ImageIO.write((RenderedImage)crew.getJollyRoger().getAsBufferedImage().get(), "png", outputFile);
                StringTextComponent fileComp = new StringTextComponent(String.format("%s_%s", crewNameSnakeCase, dtf.format(now)));
                fileComp.func_230530_a_(textComp.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputFile.getCanonicalFile().getAbsolutePath())).setUnderlined(Boolean.valueOf(true)));
                textComp.func_230529_a_((ITextComponent)emptyComp);
                textComp.func_230529_a_((ITextComponent)fileComp);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)textComp, Minecraft.func_71410_x().field_71439_g.func_110124_au());
            }
            catch (IOException e) {
                ModMain.LOGGER.error(e.getMessage());
            }
        }
        return 1;
    }

    private static int getAllCrewsInfo(CommandContext<CommandSource> context) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        StringBuilder builder = new StringBuilder();
        for (Crew crew : worldData.getCrews()) {
            builder.append("\n=================\nName: \n " + crew.getName() + "\n");
            builder.append("Members: \n");
            for (Crew.Member member : crew.getMembers()) {
                builder.append(" " + member.getUsername() + (member.isCaptain() ? " (Captain)" : "") + "\n");
            }
            builder.append("Jolly Roger: \n");
            builder.append(" Base: \n " + crew.getJollyRoger().getBase().getTexture());
            builder.append(" Backgrounds: \n");
            for (JollyRogerElement elem : crew.getJollyRoger().getBackgrounds()) {
                if (elem == null) continue;
                builder.append(" " + elem.getTexture() + "\n");
            }
            builder.append(" Details: \n");
            for (JollyRogerElement elem : crew.getJollyRoger().getDetails()) {
                if (elem == null) continue;
                builder.append(" " + elem.getTexture() + "\n");
            }
            builder.append("=================\n");
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(builder.toString().isEmpty() ? ModI18n.COMMAND_CREW_NO_CREW_FOUND : builder.toString()), false);
        return 1;
    }

    private static int getCrewInfo(CommandContext<CommandSource> context, Crew crew) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        StringBuilder builder = new StringBuilder();
        builder.append("\n=================\nName: \n " + crew.getName() + "\n");
        builder.append("Members: \n");
        for (Crew.Member member : crew.getMembers()) {
            builder.append(" " + member.getUsername() + (member.isCaptain() ? " (Captain)" : "") + "\n");
        }
        builder.append("Jolly Roger: \n");
        builder.append(" Base: \n " + crew.getJollyRoger().getBase().getTexture());
        builder.append(" Backgrounds: \n");
        for (JollyRogerElement elem : crew.getJollyRoger().getBackgrounds()) {
            if (elem == null) continue;
            builder.append(" " + elem.getTexture() + "\n");
        }
        builder.append(" Details: \n");
        for (JollyRogerElement elem : crew.getJollyRoger().getDetails()) {
            if (elem == null) continue;
            builder.append(" " + elem.getTexture() + "\n");
        }
        builder.append("=================\n");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        return 1;
    }

    private static int removeAllCrews(CommandContext<CommandSource> context, boolean isSure) {
        if (!isSure) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent(ModI18n.COMMAND_CREW_DELETE_ALL_CONFIRM));
            return 0;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get();
        for (Crew crew : worldData.getCrews()) {
            worldData.removeCrew(crew);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_DELETED_ALL_CREWS), false);
        return 1;
    }

    private static int createCrew(CommandContext<CommandSource> context, String name, ServerPlayerEntity player) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        if (!EntityStatsCapability.get((LivingEntity)player).isPirate()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_PLAYER_NO_PIRATE));
            return 0;
        }
        if (worldData.getCrewWithMember(player.func_110124_au()) != null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_ALREADY_IN_CREW));
            return 0;
        }
        if (worldData.getCrewByName(name) != null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_NAME_ALREADY_EXISTS));
            return 0;
        }
        Crew crew = new Crew(name, (LivingEntity)player);
        worldData.addCrew(crew);
        Crew.Member member = crew.getMember(player.func_110124_au());
        member.setIsCaptain(true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_CREATED_CREW), false);
        return 1;
    }

    private static int removeCrew(CommandContext<CommandSource> context, Crew crew) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.removeCrew(crew);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_DELETED_CREW), false);
        return 1;
    }

    private static int addMemberToCrew(CommandContext<CommandSource> context, Crew crew, ServerPlayerEntity player) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        if (!EntityStatsCapability.get((LivingEntity)player).isPirate()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_PLAYER_NO_PIRATE));
            return 0;
        }
        if (worldData.getCrewWithMember(player.func_110124_au()) != null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_ALREADY_IN_CREW));
            return 0;
        }
        worldData.addCrewMember(crew, (LivingEntity)player);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_PLAYER_ADDED_TO_CREW), false);
        return 1;
    }

    private static int removeMemberFromCrew(CommandContext<CommandSource> context, Crew crew, ServerPlayerEntity player) {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        Crew.Member member = crew.getMember(player.func_110124_au());
        if (member == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_NOT_IN_CREW));
            return 0;
        }
        worldData.removeCrewMember(crew, player.func_110124_au());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_PLAYER_REMOVED_FROM_CREW), false);
        return 1;
    }

    private static int makeCaptain(CommandContext<CommandSource> context, Crew crew, ServerPlayerEntity player) {
        Crew.Member member = crew.getMember(player.func_110124_au());
        if (member == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_NOT_IN_CREW));
            return 0;
        }
        crew.getCaptain().setIsCaptain(false);
        member.setIsCaptain(true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_CREW_CAPTAIN_CHANGE), false);
        return 1;
    }
}

