/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class GetWantedPosterCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"getwantedposter").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> GetWantedPosterCommand.giveWantedPoster((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int giveWantedPoster(CommandContext<CommandSource> context, ServerPlayerEntity player) throws CommandSyntaxException {
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.issueBounty(player.func_110124_au().toString(), entityStatsProps.getBounty());
        if (WyDebug.isDebug()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + TextFormatting.ITALIC + "[DEBUG] A new bounty was issued on your name!"), Util.field_240973_b_);
        }
        ItemStack posterStack = new ItemStack((IItemProvider)ModBlocks.WANTED_POSTER.get());
        CompoundNBT data = ItemsHelper.setPlayerWantedData((IWorld)player.field_70170_p, player.func_110124_au().toString(), worldData.getBounty(player.func_110124_au().toString()));
        ServerPlayerEntity sender = ((CommandSource)context.getSource()).func_197035_h();
        if (data.isEmpty()) {
            sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "New Wanted Posters can only be generated for online players!"), Util.field_240973_b_);
            return 1;
        }
        posterStack.func_77982_d(data);
        sender.field_71071_by.func_70441_a(posterStack);
        WyNetwork.sendToAllAround(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), (Entity)player);
        return 1;
    }
}

