/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.events.IssueBountyEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class IssueBountyCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"issuebounty");
        builder.then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"bounty", (ArgumentType)LongArgumentType.longArg()).executes(context -> IssueBountyCommand.issueBounty((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"), LongArgumentType.getLong((CommandContext)context, (String)"bounty")))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int issueBounty(CommandContext<CommandSource> context, ServerPlayerEntity player, long bounty) {
        try {
            ServerPlayerEntity sender = ((CommandSource)context.getSource()).func_197035_h();
            IEntityStats propz = EntityStatsCapability.get((LivingEntity)sender);
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            IssueBountyEvent event = new IssueBountyEvent((PlayerEntity)player, bounty, (PlayerEntity)sender);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (propz.isMarine() && (event.getResult() == Event.Result.DEFAULT && propz.hasMarineRank(FactionHelper.MarineRank.CAPTAIN) || event.getResult() == Event.Result.ALLOW)) {
                if (!(props.isPirate() || props.isBandit() || props.isRevolutionary())) {
                    sender.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_ISSUEBOUNTY_MESSAGE_TARGET_REQUIREMENTS), Util.field_240973_b_);
                    return 1;
                }
                if (bounty <= props.getBounty()) {
                    sender.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_ISSUEBOUNTY_MESSAGE_ONLY_UP), Util.field_240973_b_);
                    return 1;
                }
                long costOfAdding = bounty - props.getBounty();
                if (propz.getBelly() > costOfAdding) {
                    propz.setBelly(propz.getBelly() - costOfAdding);
                    props.setBounty(bounty);
                    return 1;
                }
                sender.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_ISSUEBOUNTY_MESSAGE_NOT_ENOUGH_BELLY), Util.field_240973_b_);
                return 1;
            }
            sender.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_ISSUEBOUNTY_MESSAGE_REQUIREMENTS), Util.field_240973_b_);
            return 1;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }
}

