/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.commands.CurrencyTypeArgument;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class PouchCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"pouch").requires(source -> source.func_197034_c(0));
        builder.then(Commands.func_197057_a((String)"ALL").then(Commands.func_197056_a((String)"currency", CurrencyTypeArgument.currencyType()).executes(ctx -> PouchCommand.createPouch((CommandContext<CommandSource>)ctx, (Currency)((Object)((Object)ctx.getArgument("currency", Currency.class))), 999999999L))));
        builder.then(Commands.func_197056_a((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).then(Commands.func_197056_a((String)"currency", CurrencyTypeArgument.currencyType()).executes(ctx -> PouchCommand.createPouch((CommandContext<CommandSource>)ctx, (Currency)((Object)((Object)ctx.getArgument("currency", Currency.class))), LongArgumentType.getLong((CommandContext)ctx, (String)"amount")))));
        builder.then(Commands.func_197057_a((String)"take").then(Commands.func_197056_a((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).executes(ctx -> PouchCommand.takeFromPouch((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h(), LongArgumentType.getLong((CommandContext)ctx, (String)"amount")))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int takeFromPouch(CommandContext<CommandSource> context, ServerPlayerEntity player, long amount) {
        if (amount <= 0L) {
            return 1;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() && (stack = player.func_184592_cb()).func_190926_b()) {
            return 1;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (stack.func_77973_b() == ModItems.BELLY_POUCH.get()) {
            long belly = stack.func_196082_o().func_74763_f("belly");
            if (belly < amount) {
                amount = belly;
            }
            props.alterBelly(amount, StatChangeSource.COMMAND);
            long remains = belly - amount;
            if (remains > 0L) {
                stack.func_196082_o().func_74772_a("belly", remains);
            } else {
                stack.func_190918_g(1);
            }
            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else if (stack.func_77973_b() == ModItems.EXTOL_POUCH.get()) {
            long extol = stack.func_196082_o().func_74763_f("extol");
            if (extol < amount) {
                amount = extol;
            }
            props.alterExtol(amount, StatChangeSource.COMMAND);
            long remains = extol - amount;
            if (remains > 0L) {
                stack.func_196082_o().func_74772_a("extol", remains);
            } else {
                stack.func_190918_g(1);
            }
            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)player);
        }
        return 1;
    }

    private static int createPouch(CommandContext<CommandSource> context, Currency currency, long amount) {
        if (amount <= 0L) {
            return 1;
        }
        try {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            switch (currency) {
                case EXTOL: {
                    PouchCommand.createExtolPouch(player, amount);
                    break;
                }
                default: {
                    PouchCommand.createBellyPouch(player, amount);
                    break;
                }
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static void createBellyPouch(ServerPlayerEntity player, long amount) {
        if (ItemsHelper.hasInventoryFull((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_POUCH_MESSAGE_INVENTORY_FULL), Util.field_240973_b_);
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getBelly() <= 0L) {
            return;
        }
        if (props.getBelly() - amount >= 0L) {
            props.alterBelly(-amount, StatChangeSource.COMMAND);
        } else {
            amount = props.getBelly();
            props.alterBelly(-amount, StatChangeSource.COMMAND);
        }
        ItemStack pouch = new ItemStack((IItemProvider)ModItems.BELLY_POUCH.get());
        pouch.func_196082_o().func_74772_a("belly", amount);
        player.field_71071_by.func_70441_a(pouch);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)player);
    }

    private static void createExtolPouch(ServerPlayerEntity player, long amount) {
        if (ItemsHelper.hasInventoryFull((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.COMMAND_POUCH_MESSAGE_INVENTORY_FULL), Util.field_240973_b_);
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getExtol() <= 0L) {
            return;
        }
        if (props.getExtol() - amount >= 0L) {
            props.alterExtol(-amount, StatChangeSource.COMMAND);
        } else {
            amount = props.getExtol();
            props.alterExtol(-amount, StatChangeSource.COMMAND);
        }
        ItemStack pouch = new ItemStack((IItemProvider)ModItems.EXTOL_POUCH.get());
        pouch.func_196082_o().func_74772_a("extol", amount);
        player.field_71071_by.func_70441_a(pouch);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)player);
    }
}

