/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.config;

import java.awt.Color;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.IConfigEnum;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.config.SystemConfig;
import xyz.pixelatedw.mineminenomi.config.UIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ClientConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "mineminenomi-client.toml");
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;
    private Map<String, ForgeConfigSpec.BooleanValue> cooldownVisual;
    public ForgeConfigSpec.IntValue onFireVisibility;
    private ForgeConfigSpec.BooleanValue alwaysLegUp;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.onFireVisibility = builder.comment("Visibility when on fire while using a fire resistant fruit \nDefault: 20").defineInRange("Fire Visibility", 25, 0, 100);
        AbilitiesConfig.HAKI_COLOR.createValue(builder);
        this.alwaysLegUp = builder.comment("Always hold the leg up for combat as a Black Leg user\nDefault: true").define("Black Leg Always Up", true);
        builder.push("Cooldown Visuals");
        String[] cooldownVisuals = new String[]{"Text", "Color"};
        this.cooldownVisual = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        for (String mode : cooldownVisuals) {
            this.cooldownVisual.put(mode, builder.define(mode, true));
        }
        AbilitiesConfig.COMBAT_STATE_UPDATE_CHAT_MESSAGGE.createValue(builder);
        builder.pop();
        builder.pop();
        builder.push("UI");
        UIConfig.DISPLAY_IN_SECONDS.createValue(builder);
        UIConfig.ABILITY_BARS_ON_SCREEN.createValue(builder);
        UIConfig.SHOW_KEYBIND.createValue(builder);
        UIConfig.MERGE_ABILITY_BONUSES.createValue(builder);
        UIConfig.SIMPLE_DISPLAYS.createValue(builder);
        UIConfig.USE_HEARTS_BAR.createValue(builder);
        UIConfig.SLOT_NUMBER_DISPLAY.createValue(builder);
        UIConfig.HIDE_ABILITY_STATS.createValue(builder);
        builder.pop();
        builder.push("System");
        SystemConfig.UPDATE_MESSAGE.createValue(builder);
        SystemConfig.MOD_SPLASH_TEXT.createValue(builder);
        SystemConfig.BLUE_GORO.createValue(builder);
        builder.pop();
    }

    public boolean isGoroBlue() {
        return (Boolean)SystemConfig.BLUE_GORO.get();
    }

    public boolean isDisplayInTicks() {
        return UIConfig.SLOT_NUMBER_DISPLAY.get() == SlotNumberVisuals.TICKS;
    }

    public boolean isDisplayInSeconds() {
        return UIConfig.SLOT_NUMBER_DISPLAY.get() == SlotNumberVisuals.SECONDS;
    }

    public boolean isDisplayInPercentage() {
        return UIConfig.SLOT_NUMBER_DISPLAY.get() == SlotNumberVisuals.PERCENTAGE;
    }

    public boolean hidesAbilityStats() {
        return (Boolean)UIConfig.HIDE_ABILITY_STATS.get();
    }

    public boolean hasCombatUpdateChatMessageEnabled() {
        return (Boolean)AbilitiesConfig.COMBAT_STATE_UPDATE_CHAT_MESSAGGE.get();
    }

    public boolean isSimpleDisplaysEnabled() {
        return (Boolean)UIConfig.SIMPLE_DISPLAYS.get();
    }

    public boolean hasHeartsUI() {
        if (!((Boolean)GeneralConfig.EXTRA_HEARTS.get()).booleanValue()) {
            return false;
        }
        return (Boolean)UIConfig.USE_HEARTS_BAR.get();
    }

    public boolean isAbilityBonusesMergeEnable() {
        return (Boolean)UIConfig.MERGE_ABILITY_BONUSES.get();
    }

    public boolean isModSplashTextEnabled() {
        return (Boolean)SystemConfig.MOD_SPLASH_TEXT.get();
    }

    public boolean isBlackLegAlwaysUp() {
        return (Boolean)this.alwaysLegUp.get();
    }

    public Color getHakiColor() {
        Color color = new Color(0xFF0000);
        try {
            String c = (String)AbilitiesConfig.HAKI_COLOR.get();
            if (c.startsWith("#")) {
                color = WyHelper.hexToRGB(c);
            } else {
                int n = Integer.parseInt(c);
                if (n < 0 || n > 0xFFFFFF) {
                    throw new Exception("Haki Color outside its bounds: " + n + " Can only use numbers between 0 and 16777215");
                }
                color = new Color(n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return color;
    }

    public boolean showSlotKeybinds() {
        return (Boolean)UIConfig.SHOW_KEYBIND.get();
    }

    public int getAbilityBarsOnScreen() {
        return (Integer)UIConfig.ABILITY_BARS_ON_SCREEN.get();
    }

    public boolean[] getCooldownVisuals() {
        boolean hasText = (Boolean)this.cooldownVisual.get("Text").get();
        boolean hasColor = (Boolean)this.cooldownVisual.get("Color").get();
        return new boolean[]{hasText, hasColor};
    }

    public int getFireVisibility() {
        return (Integer)this.onFireVisibility.get();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (ClientConfig)pair.getLeft();
    }

    public static enum SlotNumberVisuals implements IConfigEnum
    {
        TICKS,
        SECONDS,
        PERCENTAGE;


        @Override
        public <T extends IConfigEnum> T next() {
            return (T)SlotNumberVisuals.values()[(this.ordinal() + 1) % SlotNumberVisuals.values().length];
        }
    }
}

