/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.config;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.IConfigEnum;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.ChallengesConfig;
import xyz.pixelatedw.mineminenomi.config.FactionsConfig;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.config.SystemConfig;
import xyz.pixelatedw.mineminenomi.config.WorldEventsConfig;
import xyz.pixelatedw.mineminenomi.config.WorldFeaturesConfig;

@Mod.EventBusSubscriber(modid="mineminenomi", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    public static final Path CONFIG_PATH = Paths.get("config", "mineminenomi-common.toml");
    public static final CommonConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> bannedItemsFromImbuing;
    public ForgeConfigSpec.BooleanValue forceSelection;
    public ForgeConfigSpec.BooleanValue abilityInvulnerability;
    public ForgeConfigSpec.BooleanValue specialSourceEvents;
    public ForgeConfigSpec.BooleanValue stopContinuousAbilities;
    public ForgeConfigSpec.BooleanValue animeScreaming;
    private List<AbilityCore> protectionWhitelistedAbilities = new ArrayList<AbilityCore>();
    private List<Item> bannedImbueableItems = new ArrayList<Item>();
    private List<AbilityCore> bannedAbilities = new ArrayList<AbilityCore>();
    private List<ResourceLocation> bannedDimensionsForStructures = new ArrayList<ResourceLocation>();

    public static void save() {
        ModMain.LOGGER.warn("save() method got accessed server side! This is bad!");
    }

    public void clearCachedLists() {
        this.bannedAbilities.clear();
        this.bannedImbueableItems.clear();
        this.protectionWhitelistedAbilities.clear();
        this.bannedDimensionsForStructures.clear();
    }

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        GeneralConfig.EXTRA_HEARTS.createValue(builder);
        GeneralConfig.MOB_REWARDS.createValue(builder);
        GeneralConfig.MINIMUM_DORIKI_PER_KILL.createValue(builder);
        GeneralConfig.DESTROY_SPAWNER.createValue(builder);
        GeneralConfig.DESTROY_WATER.createValue(builder);
        GeneralConfig.RACE_RANDOMIZER.createValue(builder);
        GeneralConfig.ALLOW_MINK_RACE_SELECT.createValue(builder);
        GeneralConfig.NATIVE_HAKI.createValue(builder);
        GeneralConfig.PUBLIC_REMOVEDF.createValue(builder);
        GeneralConfig.PUBLIC_CHECK_FRUITS.createValue(builder);
        GeneralConfig.DESPAWN_WITH_NAMETAG.createValue(builder);
        this.forceSelection = builder.comment("Forces new players to select their race, faction and fighting style upon joining the world\nDefault: false").define("Force Selection", false);
        Predicate<Object> bannedItemsTest = new Predicate<Object>(){

            @Override
            public boolean test(Object t) {
                if (!(t instanceof String)) {
                    return false;
                }
                String str = (String)t;
                return !Strings.isNullOrEmpty((String)str);
            }
        };
        ArrayList<String> defaultBannedItems = new ArrayList<String>();
        defaultBannedItems.add("mineminenomi:bubbly_coral");
        defaultBannedItems.add("mineminenomi:medic_bag");
        this.bannedItemsFromImbuing = builder.comment("List with item ids that will not get the durability protection of Imbuing Haki").defineList("Banned Items from Imbuing", defaultBannedItems, (Predicate)bannedItemsTest);
        GeneralConfig.DORIKI_LIMIT.createValue(builder);
        GeneralConfig.HAKI_EXP_LIMIT.createValue(builder);
        GeneralConfig.HEALTH_GAIN_FREQUENCY.createValue(builder);
        GeneralConfig.DORIKI_REWARD_MULTIPLIER.createValue(builder);
        GeneralConfig.BELLY_REWARD_MULTIPLIER.createValue(builder);
        GeneralConfig.BOUNTY_REWARD_MULTIPLIER.createValue(builder);
        GeneralConfig.HAKI_EXP_MULTIPLIER.createValue(builder);
        GeneralConfig.LOYALTY_MULTIPLIER.createValue(builder);
        builder.push("Stats to Keep");
        GeneralConfig.RACE_KEEP.createValue(builder);
        GeneralConfig.FACTION_KEEP.createValue(builder);
        GeneralConfig.FIGHTING_STYLE_KEEP.createValue(builder);
        GeneralConfig.DEVIL_FRUIT_KEEP.createValue(builder);
        GeneralConfig.DORIKI_KEEP_PERCENTAGE.createValue(builder);
        GeneralConfig.BOUNTY_KEEP_PERCENTAGE.createValue(builder);
        GeneralConfig.BELLY_KEEP_PERCENTAGE.createValue(builder);
        GeneralConfig.HAKI_EXP_KEEP_PERCENTAGE.createValue(builder);
        GeneralConfig.LOYALTY_KEEP_PERCENTAGE.createValue(builder);
        builder.pop();
        builder.push("Quests & Trials");
        GeneralConfig.ENABLE_TRIALS.createValue(builder);
        GeneralConfig.ENABLE_STYLES_PROGRESSION.createValue(builder);
        builder.pop();
        builder.pop();
        builder.push("Devil Fruits / Abilities");
        AbilitiesConfig.ABILITY_GRIEFING.createValue(builder);
        AbilitiesConfig.ABILITY_FRAUD_CHECKS.createValue(builder);
        AbilitiesConfig.ABILITY_BARS.createValue(builder);
        AbilitiesConfig.YAMI_POWER.createValue(builder);
        AbilitiesConfig.ENABLE_AWAKENINGS.createValue(builder);
        AbilitiesConfig.WATER_CHECKS.createValue(builder);
        AbilitiesConfig.SHARED_COOLDOWNS.createValue(builder);
        AbilitiesConfig.REMOVE_Y_RESTRICTION.createValue(builder);
        AbilitiesConfig.RANDOMIZED_FRUITS.createValue(builder);
        AbilitiesConfig.DEVIL_FRUIT_DROP_FROM_LEAVES.createValue(builder);
        AbilitiesConfig.LOGIA_INVULNERABILITY.createValue(builder);
        AbilitiesConfig.LOGIA_RETURN_EFFECT.createValue(builder);
        AbilitiesConfig.LOGIA_PROJECTILE_HIT_LOGIC.createValue(builder);
        this.abilityInvulnerability = builder.comment("Invulnerability to avoid attacks\nDefault: true").define("Ability Invulnerability", true);
        this.specialSourceEvents = builder.comment("Makes the fire and lava damage source to reduce fire resistance; only applies to move attacks from fruits \nDefault: true").define("Special Source Events", true);
        this.stopContinuousAbilities = builder.comment("Used to determine the logic for when a continuous ability is used while another continuous ability is being used;\n true - Currently used ability is stopped and the newly used ability starts its process\n false - The current ability is NOT stopped and the used ability has no effect\nDefault: true").define("Stop Continuous Abilities", true);
        this.animeScreaming = builder.comment("Will send a chat message to nearby players with the used ability's name\nDefault: false").define("Anime Scream", false);
        AbilitiesConfig.BANNED_ABILITIES.createValue(builder);
        builder.comment("These options only work when \"One Fruit per World\" option is set to EXTENDED!").push("One Fruit Per World");
        AbilitiesConfig.ONE_FRUIT_PER_WORLD.createValue(builder);
        AbilitiesConfig.UNABLE_TO_PICKUP_DF.createValue(builder);
        AbilitiesConfig.FRUITS_LIMIT_INVENTORY.createValue(builder);
        AbilitiesConfig.DAYS_FOR_INACTIVITY.createValue(builder);
        builder.pop();
        builder.push("Devil Fruits Reincarnation");
        AbilitiesConfig.DROPPED_APPLES_RESPAWN_CHANCE.createValue(builder);
        AbilitiesConfig.ENTITY_INVENTORY_APPLES_RESPAWN_CHANCE.createValue(builder);
        AbilitiesConfig.CHESTS_APPLES_RESPAWN_CHANCE.createValue(builder);
        builder.pop();
        builder.push("Ability Protection");
        AbilitiesConfig.GLOBAL_PROTECTION_WHITELIST.createValue(builder);
        AbilitiesConfig.GLOBAL_PROTECTION_RESTORATION_GRACE.createValue(builder);
        AbilitiesConfig.RESTORATION_STOP_NEAR_PLAYERS.createValue(builder);
        builder.pop();
        builder.push("Haki");
        AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.createValue(builder);
        AbilitiesConfig.HAOSHOKU_HAKI_COLORING_LOGIC.createValue(builder);
        builder.pop();
        builder.pop();
        builder.push("World Features");
        WorldFeaturesConfig.DIMENSION_STRUCTURES_BANLIST.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_TRAINING_STRUCTURES.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_GHOST_SHIPS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_SKY_ISLANDS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_SMALL_SHIPS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_MEDIUM_SHIPS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_LARGE_SHIPS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_CAMPS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_SMALL_BASES.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_LARGE_BASES.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_WATCH_TOWERS.createValue(builder);
        WorldFeaturesConfig.SPAWN_CHANCE_PONEGLYPHS.createValue(builder);
        WorldFeaturesConfig.KAIROSEKI_SPAWN_COUNT.createValue(builder);
        builder.pop();
        builder.push("Challenges");
        ChallengesConfig.ENABLE_CHALLENGES.createValue(builder);
        ChallengesConfig.CHALLENGE_CACHING.createValue(builder);
        ChallengesConfig.RETURN_TO_SAFETY.createValue(builder);
        builder.pop();
        builder.push("World Events");
        WorldEventsConfig.SPAWN_WORLD_HUMANOIDS.createValue(builder);
        WorldEventsConfig.SPAWN_WORLD_ANIMALS.createValue(builder);
        builder.push("Traders");
        WorldEventsConfig.TIME_BETWEEN_TRADER_SPAWNS.createValue(builder);
        WorldEventsConfig.SPAWN_CHANCE_TRADER.createValue(builder);
        builder.pop();
        builder.push("Trainers");
        WorldEventsConfig.TIME_BETWEEN_TRAINER_SPAWNS.createValue(builder);
        WorldEventsConfig.SPAWN_CHANCE_TRAINER.createValue(builder);
        builder.pop();
        builder.push("Ambushes");
        WorldEventsConfig.TIME_BETWEEN_AMBUSH_SPAWNS.createValue(builder);
        WorldEventsConfig.SPAWN_CHANCE_AMBUSH.createValue(builder);
        builder.pop();
        builder.pop();
        builder.push("Factions");
        FactionsConfig.DISABLE_FRIENDLY_FIRE.createValue(builder);
        builder.push("Bounty");
        FactionsConfig.TIME_BETWEEN_PACKAGE_DROPS.createValue(builder);
        builder.push("Crews");
        FactionsConfig.CREW_BOUNTY_REQUIREMENT.createValue(builder);
        FactionsConfig.WORLD_MESSAGE_ON_CREW_CREATE.createValue(builder);
        builder.pop();
        builder.push("System");
        SystemConfig.MASTER_COMMAND.createValue(builder);
        builder.pop();
    }

    public boolean hasAwakeningsEnabled() {
        return (Boolean)AbilitiesConfig.ENABLE_AWAKENINGS.get();
    }

    public List<ResourceLocation> getBannedDimensionsForStructures() {
        if (this.bannedDimensionsForStructures.isEmpty()) {
            List list = (List)WorldFeaturesConfig.DIMENSION_STRUCTURES_BANLIST.get();
            for (Object o : list) {
                String s;
                String[] arr;
                if (!(o instanceof String) || (arr = (s = (String)o).split(":")).length == 0) continue;
                if (arr.length == 1) {
                    arr = new String[]{"minecraft", s};
                }
                this.bannedDimensionsForStructures.add(new ResourceLocation(arr[0], arr[1]));
            }
        }
        return this.bannedDimensionsForStructures;
    }

    public boolean hasPublicCheckFruitsCommand() {
        return (Boolean)GeneralConfig.PUBLIC_CHECK_FRUITS.get();
    }

    public boolean stopRestorationNearPlayers() {
        return (Boolean)AbilitiesConfig.RESTORATION_STOP_NEAR_PLAYERS.get();
    }

    public long getGlobalProtectionGraceTime() {
        return (Long)AbilitiesConfig.GLOBAL_PROTECTION_RESTORATION_GRACE.get();
    }

    public boolean isItemBannedFromImbuing(Item item) {
        return this.getBannedImbuingItems().contains(item);
    }

    public List<Item> getBannedImbuingItems() {
        if (this.bannedImbueableItems.isEmpty()) {
            for (String str : (List)this.bannedItemsFromImbuing.get()) {
                ResourceLocation res = new ResourceLocation(str);
                Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(res);
                if (item == null) continue;
                this.bannedImbueableItems.add(item);
            }
        }
        return this.bannedImbueableItems;
    }

    public int getHealthGainFrequency() {
        return (Integer)GeneralConfig.HEALTH_GAIN_FREQUENCY.get();
    }

    public boolean hasYRestrictionRemoved() {
        return (Boolean)AbilitiesConfig.REMOVE_Y_RESTRICTION.get();
    }

    public boolean isHaoColoringRandom() {
        return AbilitiesConfig.HAOSHOKU_HAKI_COLORING_LOGIC.get() == HaoshokuColoringLogic.RANDOM;
    }

    public boolean isHaoColoringCustom() {
        return AbilitiesConfig.HAOSHOKU_HAKI_COLORING_LOGIC.get() == HaoshokuColoringLogic.CUSTOM;
    }

    public boolean isHaoColoringStandard() {
        return AbilitiesConfig.HAOSHOKU_HAKI_COLORING_LOGIC.get() == HaoshokuColoringLogic.STANDARD;
    }

    public boolean isNativeHakiEnabled() {
        return (Boolean)GeneralConfig.NATIVE_HAKI.get();
    }

    public boolean isAbilityProtectionWhitelisted(AbilityCore core) {
        return this.getProtectionWhitelistedAbilities().contains(core);
    }

    public List<AbilityCore> getProtectionWhitelistedAbilities() {
        if (this.protectionWhitelistedAbilities.isEmpty()) {
            List list = (List)AbilitiesConfig.GLOBAL_PROTECTION_WHITELIST.get();
            for (Object o : list) {
                ResourceLocation res;
                AbilityCore<?> ability;
                String s;
                String[] arr;
                if (!(o instanceof String) || (arr = (s = (String)o).split(":")).length == 0) continue;
                if (arr.length == 1) {
                    arr = new String[]{"mineminenomi", s};
                }
                if ((ability = AbilityCore.get(res = new ResourceLocation(arr[0], arr[1]))) == null) continue;
                this.protectionWhitelistedAbilities.add(ability);
            }
        }
        return this.protectionWhitelistedAbilities;
    }

    public boolean getDespawnWithNametag() {
        return (Boolean)GeneralConfig.DESPAWN_WITH_NAMETAG.get();
    }

    public boolean getRandomizedFruits() {
        return (Boolean)AbilitiesConfig.RANDOMIZED_FRUITS.get();
    }

    public boolean getRaceRandomizer() {
        return (Boolean)GeneralConfig.RACE_RANDOMIZER.get();
    }

    public boolean getAllowMinkRaceSelect() {
        return (Boolean)GeneralConfig.ALLOW_MINK_RACE_SELECT.get();
    }

    public double getChanceForSkyIslandSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_SKY_ISLANDS.get()).intValue();
    }

    public boolean canSpawnSkyIslands() {
        return this.getChanceForSkyIslandSpawn() > 0.0;
    }

    public double getChanceForGhostShipSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_GHOST_SHIPS.get()).intValue();
    }

    public boolean canSpawnGhostShips() {
        return this.getChanceForGhostShipSpawn() > 0.0;
    }

    public boolean isChallengesEnabled() {
        return (Boolean)ChallengesConfig.ENABLE_CHALLENGES.get();
    }

    public boolean isChallengesCachingEnabled() {
        return (Boolean)ChallengesConfig.CHALLENGE_CACHING.get();
    }

    public boolean isReturnToSafetyEnabled() {
        return (Boolean)ChallengesConfig.RETURN_TO_SAFETY.get();
    }

    public double getChanceForPoneglyphSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_PONEGLYPHS.get()).intValue();
    }

    public boolean canSpawnPoneglyphs() {
        return this.getChanceForPoneglyphSpawn() > 0.0;
    }

    public int getDaysForInactivity() {
        return (Integer)AbilitiesConfig.DAYS_FOR_INACTIVITY.get();
    }

    public int getBellyKeepPercentage() {
        return (Integer)GeneralConfig.BELLY_KEEP_PERCENTAGE.get();
    }

    public int getHakiExpKeepPercentage() {
        return (Integer)GeneralConfig.HAKI_EXP_KEEP_PERCENTAGE.get();
    }

    public int getBountyKeepPercentage() {
        return (Integer)GeneralConfig.BOUNTY_KEEP_PERCENTAGE.get();
    }

    public int getDorikiKeepPercentage() {
        return (Integer)GeneralConfig.DORIKI_KEEP_PERCENTAGE.get();
    }

    public int getInventoryLimitForFruits() {
        return (Integer)AbilitiesConfig.FRUITS_LIMIT_INVENTORY.get();
    }

    public boolean getUnableToPickDFAsUser() {
        return (Boolean)AbilitiesConfig.UNABLE_TO_PICKUP_DF.get();
    }

    public int getAbilityBars() {
        return (Integer)AbilitiesConfig.ABILITY_BARS.get();
    }

    public boolean getStopContinuousAbility() {
        return (Boolean)this.stopContinuousAbilities.get();
    }

    public int getHakiExpLimit() {
        return (Integer)GeneralConfig.HAKI_EXP_LIMIT.get();
    }

    public int getDorikiLimit() {
        return (Integer)GeneralConfig.DORIKI_LIMIT.get();
    }

    public boolean getDestroySpawner() {
        return (Boolean)GeneralConfig.DESTROY_SPAWNER.get();
    }

    public boolean getDestroyWater() {
        return (Boolean)GeneralConfig.DESTROY_WATER.get();
    }

    public double getChanceForChestAppleReincarnation() {
        return ((Integer)AbilitiesConfig.CHESTS_APPLES_RESPAWN_CHANCE.get()).intValue();
    }

    public double getChanceForInventoryAppleReincarnation() {
        return ((Integer)AbilitiesConfig.ENTITY_INVENTORY_APPLES_RESPAWN_CHANCE.get()).intValue();
    }

    public double getChanceForDroppedAppleReincarnation() {
        return ((Integer)AbilitiesConfig.DROPPED_APPLES_RESPAWN_CHANCE.get()).intValue();
    }

    public boolean isFriendlyDamageDisabled() {
        return (Boolean)FactionsConfig.DISABLE_FRIENDLY_FIRE.get();
    }

    public boolean hasOneFruitPerWorldExtendedLogic() {
        return ((OneFruitPerWorldLogic)AbilitiesConfig.ONE_FRUIT_PER_WORLD.get()).equals(OneFruitPerWorldLogic.EXTENDED);
    }

    public boolean hasOneFruitPerWorldSimpleLogic() {
        return ((OneFruitPerWorldLogic)AbilitiesConfig.ONE_FRUIT_PER_WORLD.get()).equals(OneFruitPerWorldLogic.SIMPLE) || this.hasOneFruitPerWorldExtendedLogic();
    }

    public double getChanceForLargeBasesSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_LARGE_BASES.get()).intValue();
    }

    public boolean canSpawnLargeBases() {
        return this.getChanceForLargeBasesSpawn() > 0.0;
    }

    public double getChanceForWatchTowersSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_WATCH_TOWERS.get()).intValue();
    }

    public boolean canSpawnWatchTowers() {
        return this.getChanceForWatchTowersSpawn() > 0.0;
    }

    public double getChanceForLargeShipsSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_LARGE_SHIPS.get()).intValue();
    }

    public boolean canSpawnLargeShips() {
        return this.getChanceForLargeShipsSpawn() > 0.0;
    }

    public double getChanceForSmallBasesSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_SMALL_BASES.get()).intValue();
    }

    public boolean canSpawnSmallBases() {
        return this.getChanceForSmallBasesSpawn() > 0.0;
    }

    public double getChanceForCampsSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_CAMPS.get()).intValue();
    }

    public boolean canSpawnCamps() {
        return this.getChanceForCampsSpawn() > 0.0;
    }

    public double getChanceForSmallShipsSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_SMALL_SHIPS.get()).intValue();
    }

    public boolean canSpawnSmallShips() {
        return this.getChanceForSmallShipsSpawn() > 0.0;
    }

    public double getChanceForMediumShipsSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_MEDIUM_SHIPS.get()).intValue();
    }

    public boolean canSpawnMediumShips() {
        return this.getChanceForMediumShipsSpawn() > 0.0;
    }

    public double getChanceForTrainingStructureSpawn() {
        return ((Integer)WorldFeaturesConfig.SPAWN_CHANCE_TRAINING_STRUCTURES.get()).intValue();
    }

    public boolean canSpawnTrainingStructures() {
        return this.getChanceForTrainingStructureSpawn() > 0.0;
    }

    public boolean isCrewWorldMessageEnabled() {
        return (Boolean)FactionsConfig.WORLD_MESSAGE_ON_CREW_CREATE.get();
    }

    public int getBountyRequirementForCrews() {
        return (Integer)FactionsConfig.CREW_BOUNTY_REQUIREMENT.get();
    }

    public boolean isHaoshokuUnlockLogicExpBased() {
        return AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get() == HaoshokuUnlockLogic.EXPERIENCE || AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get() == HaoshokuUnlockLogic.COMBINED;
    }

    public boolean isHaoshokuUnlockLogicChanceBased() {
        return AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get() == HaoshokuUnlockLogic.RANDOM || AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get() == HaoshokuUnlockLogic.COMBINED || AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get() == HaoshokuUnlockLogic.TRUE_RANDOM;
    }

    public HaoshokuUnlockLogic getHaoshokuUnlockLogic() {
        return (HaoshokuUnlockLogic)AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC.get();
    }

    public int getChanceForAmbushSpawn() {
        return (Integer)WorldEventsConfig.SPAWN_CHANCE_AMBUSH.get();
    }

    public int getTimeBetweenAmbushSpawns() {
        return (Integer)WorldEventsConfig.TIME_BETWEEN_AMBUSH_SPAWNS.get() * 60 * 20;
    }

    public boolean canSpawnAmbushes() {
        return this.getChanceForAmbushSpawn() > 0 && this.getTimeBetweenAmbushSpawns() > 0;
    }

    public int getChanceForTrainerSpawn() {
        return (Integer)WorldEventsConfig.SPAWN_CHANCE_TRAINER.get();
    }

    public int getTimeBetweenTrainerSpawns() {
        return (Integer)WorldEventsConfig.TIME_BETWEEN_TRAINER_SPAWNS.get() * 60 * 20;
    }

    public boolean canSpawnTrainers() {
        return this.getChanceForTrainerSpawn() > 0 && this.getTimeBetweenTrainerSpawns() > 0;
    }

    public int getChanceForTraderSpawn() {
        return (Integer)WorldEventsConfig.SPAWN_CHANCE_TRADER.get();
    }

    public int getTimeBetweenTraderSpawns() {
        return (Integer)WorldEventsConfig.TIME_BETWEEN_TRADER_SPAWNS.get() * 60 * 20;
    }

    public boolean canSpawnTraders() {
        return this.getChanceForTraderSpawn() > 0 && this.getTimeBetweenTraderSpawns() > 0;
    }

    public int getTimeBetweenPackages() {
        return (Integer)FactionsConfig.TIME_BETWEEN_PACKAGE_DROPS.get() * 20 * 60;
    }

    public boolean isWantedPosterPackagesEnabled() {
        return this.getTimeBetweenPackages() > 0;
    }

    public double getDorikiRewardMultiplier() {
        return (Double)GeneralConfig.DORIKI_REWARD_MULTIPLIER.get();
    }

    public double getBellyRewardMultiplier() {
        return (Double)GeneralConfig.BELLY_REWARD_MULTIPLIER.get();
    }

    public double getBountyRewardMultiplier() {
        return (Double)GeneralConfig.BOUNTY_REWARD_MULTIPLIER.get();
    }

    public double getHakiExpMultiplier() {
        return (Double)GeneralConfig.HAKI_EXP_MULTIPLIER.get();
    }

    public double getLoyaltyMultiplier() {
        return (Double)GeneralConfig.LOYALTY_MULTIPLIER.get();
    }

    public boolean isQuestProgressionEnabled() {
        return (Boolean)GeneralConfig.ENABLE_STYLES_PROGRESSION.get();
    }

    public boolean isQuestsEnabled() {
        return (Boolean)GeneralConfig.ENABLE_TRIALS.get();
    }

    public List<AbilityCore> getBannedAbilities() {
        if (this.bannedAbilities.isEmpty()) {
            for (String str : (List)AbilitiesConfig.BANNED_ABILITIES.get()) {
                ResourceLocation res = new ResourceLocation(str);
                AbilityCore<?> ability = AbilityCore.get(res);
                if (ability == null) continue;
                this.bannedAbilities.add(ability);
            }
        }
        return this.bannedAbilities;
    }

    public boolean isAbilityInvulnerabilityEnabled() {
        return (Boolean)this.abilityInvulnerability.get();
    }

    public boolean areExtraWaterChecksEnabled() {
        return (Boolean)AbilitiesConfig.WATER_CHECKS.get();
    }

    public boolean isLogiaDamageEffectEnabled() {
        return (Boolean)AbilitiesConfig.LOGIA_RETURN_EFFECT.get();
    }

    public boolean doLogiasHaveHurtHakiLogic() {
        return ((LogiaProjectileHitLogic)AbilitiesConfig.LOGIA_PROJECTILE_HIT_LOGIC.get()).equals(LogiaProjectileHitLogic.HAKI) || ((LogiaProjectileHitLogic)AbilitiesConfig.LOGIA_PROJECTILE_HIT_LOGIC.get()).equals(LogiaProjectileHitLogic.EXTENDED);
    }

    public boolean doLogiasHaveHurtExtendedLogic() {
        return ((LogiaProjectileHitLogic)AbilitiesConfig.LOGIA_PROJECTILE_HIT_LOGIC.get()).equals(LogiaProjectileHitLogic.EXTENDED);
    }

    public double getDevilFruitDropsFromLeavesChance() {
        return (Double)AbilitiesConfig.DEVIL_FRUIT_DROP_FROM_LEAVES.get();
    }

    public boolean isExtraHeartsEnabled() {
        return (Boolean)GeneralConfig.EXTRA_HEARTS.get();
    }

    public boolean isMobRewardsEnabled() {
        return (Boolean)GeneralConfig.MOB_REWARDS.get();
    }

    public boolean isAbilityGriefingEnabled() {
        return (Boolean)AbilitiesConfig.ABILITY_GRIEFING.get();
    }

    public boolean isSpecialSourceEventsEnabled() {
        return (Boolean)this.specialSourceEvents.get();
    }

    public boolean isYamiPowerEnabled() {
        return (Boolean)AbilitiesConfig.YAMI_POWER.get();
    }

    public boolean isAbilityFraudChecksEnabled() {
        return (Boolean)AbilitiesConfig.ABILITY_FRAUD_CHECKS.get();
    }

    public boolean isMinimumDorikiPerKillEnabled() {
        return (Boolean)GeneralConfig.MINIMUM_DORIKI_PER_KILL.get();
    }

    public int getKairosekiSpawnCount() {
        return (Integer)WorldFeaturesConfig.KAIROSEKI_SPAWN_COUNT.get();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (CommonConfig)pair.getLeft();
    }

    public static enum HaoshokuColoringLogic implements IConfigEnum
    {
        STANDARD,
        CUSTOM,
        RANDOM;


        @Override
        public <T extends IConfigEnum> T next() {
            return (T)HaoshokuColoringLogic.values()[(this.ordinal() + 1) % HaoshokuColoringLogic.values().length];
        }
    }

    public static enum LogiaProjectileHitLogic implements IConfigEnum
    {
        NONE,
        HAKI,
        EXTENDED;


        @Override
        public <T extends IConfigEnum> T next() {
            return (T)LogiaProjectileHitLogic.values()[(this.ordinal() + 1) % LogiaProjectileHitLogic.values().length];
        }
    }

    public static enum OneFruitPerWorldLogic implements IConfigEnum
    {
        NONE,
        SIMPLE,
        EXTENDED;


        @Override
        public <T extends IConfigEnum> T next() {
            return (T)OneFruitPerWorldLogic.values()[(this.ordinal() + 1) % OneFruitPerWorldLogic.values().length];
        }
    }

    public static enum HaoshokuUnlockLogic implements IConfigEnum
    {
        NONE,
        RANDOM,
        EXPERIENCE,
        COMBINED,
        TRUE_RANDOM;


        @Override
        public <T extends IConfigEnum> T next() {
            return (T)HaoshokuUnlockLogic.values()[(this.ordinal() + 1) % HaoshokuUnlockLogic.values().length];
        }
    }
}

