/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.config.options;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import xyz.pixelatedw.mineminenomi.config.options.ListOption;

public class StringListOption
extends ListOption<String> {
    private static final Predicate<Object> STRING_VALIDATOR = new Predicate<Object>(){

        @Override
        public boolean test(Object t) {
            if (!(t instanceof String)) {
                return false;
            }
            String str = (String)t;
            return !Strings.isNullOrEmpty((String)str);
        }
    };

    public StringListOption(List<String> defaultValue, String optionName, @Nullable String optionDescription) {
        super(defaultValue, STRING_VALIDATOR, optionName, optionDescription);
    }

    @Override
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> buildValue(ForgeConfigSpec.Builder builder) {
        if (this.getDescription() != null) {
            builder.comment(this.getDescription());
        }
        return builder.defineList(this.getTitle(), (List)this.getDefault(), this.getValidator());
    }
}

