/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MappedTag<K extends IForgeRegistryEntry<K>>
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private HashMap<K, Float> values = new HashMap();
    private final ResourceLocation id;
    private final IForgeRegistry<K> registry;

    public MappedTag(ResourceLocation id, String directory, IForgeRegistry<K> registry) {
        super(GSON, directory);
        this.id = id;
        this.registry = registry;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, IResourceManager pResourceManager, IProfiler pProfiler) {
        JsonObject obj = pObject.get(this.id).getAsJsonObject();
        for (Map.Entry objEntry : obj.entrySet()) {
            ResourceLocation resourceId = new ResourceLocation((String)objEntry.getKey());
            IForgeRegistryEntry key = this.registry.getValue(resourceId);
            float value = ((JsonElement)objEntry.getValue()).getAsFloat();
            this.values.put(key, Float.valueOf(value));
        }
    }

    public float getValue(K type) {
        return this.values.getOrDefault(type, Float.valueOf(0.0f)).floatValue();
    }
}

