/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.animation;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.data.entity.animation.IAnimationData;

public class AnimationDataBase
implements IAnimationData {
    private LivingEntity owner;
    private Animation<?, ?> currentAnimation;
    private LinkedList<Animation<?, ?>> animations = new LinkedList();

    @Override
    public IAnimationData setOwner(LivingEntity entity) {
        this.owner = entity;
        return this;
    }

    @Override
    public void startAnimation(AnimationId<?> animationId, int duration, boolean force) {
        boolean alreadyHasAnim;
        if (this.currentAnimation != null && !force) {
            return;
        }
        if (this.currentAnimation != null && !(alreadyHasAnim = this.animations.stream().anyMatch(a -> a.getId().equals(animationId)))) {
            this.animations.push(this.currentAnimation);
        }
        this.currentAnimation = AnimationId.getRegisteredAnimation(animationId);
        if (this.currentAnimation != null) {
            this.currentAnimation.start(this.owner, duration);
        }
    }

    @Override
    public void stopAnimation(AnimationId<?> animationId) {
        if (this.currentAnimation != null && this.currentAnimation.getId().equals(animationId)) {
            this.currentAnimation.stop(this.owner);
            this.currentAnimation = null;
        } else {
            Optional<Animation> opt = this.animations.stream().filter(a -> a.getId().equals(animationId)).findFirst();
            if (opt.isPresent()) {
                opt.get().stop(this.owner);
            }
        }
    }

    @Nullable
    public Animation<?, ?> getAnimation() {
        if (this.currentAnimation != null && this.currentAnimation.isStopped()) {
            return null;
        }
        return this.currentAnimation;
    }

    @Override
    public void tickAnimations() {
        Animation<?, ?> last;
        if (this.owner == null) {
            return;
        }
        if (this.currentAnimation != null) {
            this.currentAnimation.tick(this.owner);
            if (this.currentAnimation.isStopped()) {
                this.currentAnimation = null;
            }
        }
        Iterator iter = this.animations.iterator();
        while (iter.hasNext()) {
            Animation anim = (Animation)iter.next();
            anim.tick(this.owner);
            if (!anim.isStopped()) continue;
            iter.remove();
        }
        if (this.animations.size() > 0 && (this.currentAnimation == null || this.currentAnimation.isStopped()) && (last = this.animations.pollFirst()) != null) {
            this.currentAnimation = last;
        }
    }

    @Override
    public LinkedList<Animation<?, ?>> getAnimations() {
        return new LinkedList(this.animations);
    }
}

