/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.devilfruit;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.abilities.LogiaInvulnerabilityAbility;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class DevilFruitBase
implements IDevilFruit {
    private int version = 2;
    private LivingEntity owner;
    private Optional<ResourceLocation> devilFruit = Optional.empty();
    private String zoanPoint = "";
    private boolean hasAwakenedFruit;
    private Deque<ResourceLocation> morphs = new ArrayDeque<ResourceLocation>();
    private boolean isMorphDirty;
    private Optional<MorphInfo> lastMorph = Optional.empty();
    private boolean hasYamiPower = false;

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public IDevilFruit setOwner(LivingEntity entity) {
        this.owner = entity;
        return this;
    }

    @Override
    public Optional<ResourceLocation> getDevilFruit() {
        return this.devilFruit;
    }

    @Override
    public Item getDevilFruitItem() {
        if (!this.hasAnyDevilFruit()) {
            return Items.field_190931_a;
        }
        return (Item)ForgeRegistries.ITEMS.getValue(this.getDevilFruit().get());
    }

    @Override
    public void setDevilFruit(@Nullable ResourceLocation value) {
        this.devilFruit = Optional.ofNullable(value);
    }

    @Override
    public void setDevilFruit(AkumaNoMiItem fruit) {
        this.devilFruit = Optional.ofNullable(fruit.getRegistryName());
    }

    @Override
    public boolean hasAnyDevilFruit() {
        return this.devilFruit.isPresent();
    }

    @Override
    public boolean hasDevilFruit(AkumaNoMiItem fruit) {
        return this.getDevilFruit().map(rs -> rs != null && rs.equals((Object)fruit.getRegistryName())).orElse(false);
    }

    @Override
    public void removeDevilFruit() {
        this.setDevilFruit((ResourceLocation)null);
        this.setZoanPoint("");
        this.morphs.clear();
        this.setYamiPower(false);
    }

    @Override
    public boolean isLogia() {
        return !this.hasYamiPower() && AbilityDataCapability.get(this.owner).getPassiveAbilities(a -> a instanceof LogiaInvulnerabilityAbility).size() > 0;
    }

    @Override
    public boolean hasYamiPower() {
        return this.hasYamiPower;
    }

    @Override
    public void setYamiPower(boolean value) {
        this.hasYamiPower = value;
    }

    @Override
    public Optional<MorphInfo> getCurrentMorph() {
        MorphInfo morph;
        if (!this.isMorphDirty && this.lastMorph.isPresent()) {
            return this.lastMorph;
        }
        ResourceLocation res = this.morphs.peekLast();
        if (res != null && (morph = (MorphInfo)ModRegistries.MORPHS.getValue(res)) != null) {
            this.lastMorph = Optional.ofNullable(morph);
            this.isMorphDirty = false;
            return this.lastMorph;
        }
        return Optional.empty();
    }

    @Override
    public boolean hasMorphActive(MorphInfo morph) {
        if (!this.isMorphDirty && this.lastMorph.isPresent() && ((Object)((Object)this.lastMorph.get())).equals((Object)morph)) {
            return true;
        }
        return this.morphs.contains(morph.getRegistryName());
    }

    @Override
    public void addMorph(MorphInfo morph) {
        if (this.morphs.contains(morph.getRegistryName())) {
            return;
        }
        this.morphs.addLast(morph.getRegistryName());
        this.isMorphDirty = true;
        this.setZoanPoint(morph.getForm());
    }

    @Override
    public void removeMorph(MorphInfo morph) {
        if (this.morphs.size() <= 0) {
            return;
        }
        this.morphs.removeLastOccurrence(morph.getRegistryName());
        this.isMorphDirty = true;
        this.setZoanPoint(this.getCurrentMorph().map(m -> m.getForm()).orElse(""));
    }

    @Override
    public void removeMorph() {
        if (this.morphs.size() <= 0) {
            return;
        }
        this.morphs.removeLast();
        this.isMorphDirty = true;
        this.setZoanPoint(this.getCurrentMorph().map(m -> m.getForm()).orElse(""));
    }

    @Override
    @Deprecated
    public String getZoanPoint() {
        return this.zoanPoint;
    }

    @Override
    @Deprecated
    public void setZoanPoint(String value) {
        this.zoanPoint = value;
    }

    @Override
    public boolean hasAwakenedFruit() {
        if (!CommonConfig.INSTANCE.hasAwakeningsEnabled()) {
            return false;
        }
        if (this.owner == null) {
            return false;
        }
        if (this.owner.func_184102_h() != null && this.owner.func_184102_h().func_71262_S()) {
            return false;
        }
        return this.hasAwakenedFruit;
    }

    @Override
    public void setAwakenedFruit(boolean flag) {
        this.hasAwakenedFruit = flag;
    }
}

