/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.entitystats;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.ColaBackpackBonusAbility;
import xyz.pixelatedw.mineminenomi.api.ClientBossExtraInfo;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.events.EntityCarryEvent;
import xyz.pixelatedw.mineminenomi.api.events.UpdateCombatStateEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.BountyEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.CurrencyEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.LoyaltyEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SCarryEntityPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SLeashPlayerPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SUpdateCombatStatePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class EntityStatsBase
implements IEntityStats {
    private LivingEntity owner;
    private double doriki;
    private double loyalty = 0.0;
    private int cola = 100;
    private int ultraCola = 0;
    private int invulnerableTime = 0;
    private long bounty;
    private long belly;
    private long extol;
    private String faction = "";
    private String race = "";
    private String subRace = "";
    private String fightingStyle = "";
    private boolean hasShadow = true;
    private boolean hasHeart = true;
    private boolean inCombatMode = false;
    private boolean hasStrawDoll = true;
    private boolean isRogue = false;
    private double damageMultiplier = 1.0;
    private float xxa;
    private float zza;
    private Map<UUID, ClientBossExtraInfo> extraInfos = new HashMap<UUID, ClientBossExtraInfo>();
    @Nullable
    private LivingEntity lastAttacker;
    private long lastAttackTime;
    @Nullable
    private LivingEntity carryTarget;
    @Nullable
    private LivingEntity carrier;
    private float storedDamage;
    @Nullable
    private LivingEntity leashHolder;

    @Override
    public IEntityStats setOwner(LivingEntity entity) {
        this.owner = entity;
        return this;
    }

    @Override
    public void setLeashedTo(LivingEntity entity) {
        this.leashHolder = entity;
        if (this.owner.func_184218_aH()) {
            this.owner.func_184210_p();
        }
        if (!this.owner.field_70170_p.field_72995_K && entity instanceof PlayerEntity && this.owner instanceof PlayerEntity) {
            WyNetwork.sendToAllTrackingAndSelf(new SLeashPlayerPacket((PlayerEntity)this.owner, (PlayerEntity)entity), (LivingEntity)((PlayerEntity)entity));
        }
    }

    @Override
    public void dropLeash() {
        Vector3d leashHolderPos = this.leashHolder.func_213303_ch().func_72441_c(0.0, (double)this.leashHolder.func_70047_e(), 0.0);
        this.leashHolder = null;
        ItemEntity entity = new ItemEntity(this.owner.field_70170_p, leashHolderPos.field_72450_a, leashHolderPos.field_72448_b, leashHolderPos.field_72449_c, Items.field_151058_ca.func_190903_i());
        entity.func_174869_p();
        this.owner.field_70170_p.func_217376_c((Entity)entity);
        if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof PlayerEntity) {
            WyNetwork.sendToAllTrackingAndSelf(new SLeashPlayerPacket((PlayerEntity)this.owner, null), (LivingEntity)((PlayerEntity)this.owner));
        }
    }

    @Override
    @Nullable
    public LivingEntity getLeashHolder() {
        return this.leashHolder;
    }

    @Override
    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    @Override
    public boolean canBeLeashed(LivingEntity entity) {
        return this.leashHolder == null;
    }

    @Override
    public void setStoredDamage(float damage) {
        this.storedDamage = damage;
    }

    @Override
    public float getStoredDamage() {
        return this.storedDamage;
    }

    @Override
    public void startCarrying(@Nullable LivingEntity target) {
        if (target == null) {
            this.stopCarrying();
            return;
        }
        if (target.func_184218_aH()) {
            target.func_184210_p();
        }
        this.carryTarget = target;
        IEntityStats props = EntityStatsCapability.get(target);
        props.setCarrier(this.owner);
        EntityCarryEvent event = new EntityCarryEvent(this.owner, target, true);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof PlayerEntity) {
            WyNetwork.sendTo(new SCarryEntityPacket(target), (PlayerEntity)this.owner);
        }
    }

    @Override
    public void stopCarrying() {
        EntityCarryEvent event = new EntityCarryEvent(this.owner, this.carryTarget, false);
        boolean isCancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        if (isCancelled) {
            return;
        }
        if (this.carryTarget != null) {
            IEntityStats props = EntityStatsCapability.get(this.carryTarget);
            props.setCarrier(null);
        }
        this.carryTarget = null;
        this.owner.func_195063_d((Effect)ModEffects.CARRYING.get());
        if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof PlayerEntity) {
            WyNetwork.sendTo(new SCarryEntityPacket(null), (PlayerEntity)this.owner);
        }
    }

    @Override
    @Nullable
    public LivingEntity getCarry() {
        return this.carryTarget;
    }

    @Override
    public boolean isCarrying() {
        return this.carryTarget != null && this.carryTarget.func_70089_S();
    }

    @Override
    public void setCarrier(LivingEntity entity) {
        this.carrier = entity;
    }

    @Override
    @Nullable
    public LivingEntity getCarrier() {
        return this.carrier;
    }

    @Override
    public boolean isCarried() {
        return this.carrier != null && this.carrier.func_70089_S();
    }

    @Override
    public void setInCombatCache(@Nullable LivingEntity attacker) {
        this.lastAttackTime = attacker != null ? 300L : 0L;
        if (this.lastAttacker != attacker) {
            this.lastAttacker = attacker;
            boolean hasAttacker = this.lastAttacker != null;
            UpdateCombatStateEvent event = new UpdateCombatStateEvent(this.owner, this.lastAttacker, hasAttacker);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (this.owner instanceof ServerPlayerEntity) {
                WyNetwork.sendTo(new SUpdateCombatStatePacket(this.lastAttacker), (PlayerEntity)((ServerPlayerEntity)this.owner));
            }
        }
    }

    @Override
    public boolean isInCombatCache() {
        return this.lastAttackTime > 0L;
    }

    @Override
    @Nullable
    public LivingEntity getLastAttacker() {
        return this.lastAttacker;
    }

    @Override
    public long getLastAttackTime() {
        return this.lastAttackTime;
    }

    @Override
    public void tickLastAttack() {
        boolean canTickDown;
        if (this.owner == null) {
            return;
        }
        boolean isAttackerAlive = this.lastAttacker != null && this.lastAttacker.func_70089_S();
        boolean isAttackerInDistance = isAttackerAlive && Math.abs(this.lastAttacker.func_70068_e((Entity)this.owner)) <= 10000.0;
        boolean isTheTarget = isAttackerAlive && this.lastAttacker instanceof MobEntity && ((MobEntity)this.lastAttacker).func_70638_az() == this.owner;
        boolean bl = canTickDown = !isAttackerAlive || !isAttackerInDistance || !isTheTarget;
        if (canTickDown && this.lastAttackTime > 0L) {
            --this.lastAttackTime;
        } else if (this.lastAttackTime <= 0L && this.lastAttacker != null) {
            this.setInCombatCache(null);
        }
    }

    @Override
    public Map<UUID, ClientBossExtraInfo> getExtraBossInfo() {
        return this.extraInfos;
    }

    @Override
    public void addExtraBossInfo(UUID id, ClientBossExtraInfo info) {
        this.extraInfos.put(id, info);
    }

    @Override
    public double getDoriki() {
        return this.doriki;
    }

    @Override
    public boolean alterDoriki(double value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            DorikiEvent.Pre pre = new DorikiEvent.Pre((PlayerEntity)this.owner, value, source);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            value = pre.getDoriki();
        }
        this.doriki = MathHelper.func_151237_a((double)(this.doriki + value), (double)0.0, (double)CommonConfig.INSTANCE.getDorikiLimit());
        if (this.owner instanceof PlayerEntity) {
            DorikiEvent.Post post = new DorikiEvent.Post((PlayerEntity)this.owner, value, source);
            MinecraftForge.EVENT_BUS.post((Event)post);
            if (this.owner instanceof ServerPlayerEntity) {
                ModAdvancements.OBTAIN_DORIKI.trigger((ServerPlayerEntity)this.owner, (int)this.doriki);
            }
        }
        return true;
    }

    @Override
    public void setDoriki(double value) {
        this.doriki = MathHelper.func_151237_a((double)value, (double)0.0, (double)CommonConfig.INSTANCE.getDorikiLimit());
    }

    @Override
    public long getBelly() {
        return this.belly;
    }

    @Override
    public boolean alterBelly(long value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            CurrencyEvent.Pre pre = new CurrencyEvent.Pre((PlayerEntity)this.owner, value, Currency.BELLY, source);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            value = pre.getAmount();
        }
        this.belly = WyHelper.clamp(this.belly + value, 0L, 999999999L);
        if (this.owner instanceof PlayerEntity) {
            CurrencyEvent.Post post = new CurrencyEvent.Post((PlayerEntity)this.owner, value, Currency.BELLY, source);
            MinecraftForge.EVENT_BUS.post((Event)post);
            if (this.owner instanceof ServerPlayerEntity) {
                ModAdvancements.OBTAIN_BELLY.trigger((ServerPlayerEntity)this.owner, (int)this.belly, false);
            }
        }
        return true;
    }

    @Override
    public void setBelly(long value) {
        this.belly = value;
    }

    @Override
    public long getExtol() {
        return this.extol;
    }

    @Override
    public boolean alterExtol(long value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            CurrencyEvent extolEvent = new CurrencyEvent((PlayerEntity)this.owner, value, Currency.EXTOL, source);
            if (MinecraftForge.EVENT_BUS.post((Event)extolEvent)) {
                return false;
            }
            value = extolEvent.getAmount();
        }
        this.extol = WyHelper.clamp(this.extol + value, 0L, 999999999L);
        if (this.owner instanceof PlayerEntity) {
            CurrencyEvent.Post post = new CurrencyEvent.Post((PlayerEntity)this.owner, value, Currency.EXTOL, source);
            MinecraftForge.EVENT_BUS.post((Event)post);
        }
        return true;
    }

    @Override
    public void setExtol(long value) {
        this.extol = value;
    }

    @Override
    public long getBounty() {
        return this.bounty;
    }

    @Override
    public boolean alterBounty(long value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            BountyEvent.Pre pre = new BountyEvent.Pre((PlayerEntity)this.owner, value, source);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            value = pre.getBounty();
        }
        this.bounty = WyHelper.clamp(this.bounty + value, 0L, 100000000000L);
        if (this.owner instanceof PlayerEntity) {
            BountyEvent.Post post = new BountyEvent.Post((PlayerEntity)this.owner, value, source);
            MinecraftForge.EVENT_BUS.post((Event)post);
            if (this.owner instanceof ServerPlayerEntity) {
                ModAdvancements.OBTAIN_BOUNTY.trigger((ServerPlayerEntity)this.owner, (int)this.bounty);
            }
        }
        return true;
    }

    @Override
    public void setBounty(long value) {
        this.bounty = value;
    }

    @Override
    public int getCola() {
        return this.cola;
    }

    @Override
    public void alterCola(int value) {
        this.cola = MathHelper.func_76125_a((int)(this.cola + value), (int)0, (int)this.getMaxCola());
    }

    @Override
    public void setCola(int value) {
        this.cola = MathHelper.func_76125_a((int)this.cola, (int)0, (int)this.getMaxCola());
    }

    @Override
    @Deprecated
    public void setForcedCola(int value) {
        this.cola = value;
    }

    @Override
    public void updateCola() {
        this.cola = MathHelper.func_76125_a((int)this.cola, (int)0, (int)this.getMaxCola());
    }

    @Override
    public int getMaxCola() {
        IAbilityData props;
        ColaBackpackBonusAbility backpackBonus;
        int maxCola = 100;
        maxCola += this.ultraCola * 20;
        if (this.owner != null && (backpackBonus = (props = AbilityDataCapability.get(this.owner)).getPassiveAbility(ColaBackpackBonusAbility.INSTANCE)) != null) {
            maxCola += 500;
        }
        maxCola = MathHelper.func_76125_a((int)maxCola, (int)0, (int)1000);
        return maxCola;
    }

    @Override
    public int getUltraCola() {
        return this.ultraCola;
    }

    @Override
    public void setUltraCola(int value) {
        this.ultraCola = MathHelper.func_76125_a((int)(this.ultraCola + value), (int)0, (int)20);
    }

    @Override
    public void addUltraCola(int value) {
        this.ultraCola += value;
    }

    @Override
    public double getLoyalty() {
        return this.loyalty;
    }

    @Override
    public boolean alterLoyalty(double value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            LoyaltyEvent.Pre pre = new LoyaltyEvent.Pre((PlayerEntity)this.owner, value, source);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            value = pre.getLoyalty();
        }
        this.loyalty = MathHelper.func_151237_a((double)(this.loyalty + value), (double)-5.0, (double)100.0);
        if (this.owner instanceof PlayerEntity) {
            LoyaltyEvent.Post post = new LoyaltyEvent.Post((PlayerEntity)this.owner, value, source);
            MinecraftForge.EVENT_BUS.post((Event)post);
            if (this.owner instanceof ServerPlayerEntity) {
                ModAdvancements.OBTAIN_LOYALTY.trigger((ServerPlayerEntity)this.owner, (int)this.loyalty);
            }
            if (this.loyalty <= -5.0) {
                this.setFaction("pirate");
                TranslationTextComponent message = new TranslationTextComponent(ModI18n.INFO_FACTION_CHANGE, new Object[]{ModI18n.FACTION_PIRATE.getString()});
                ((PlayerEntity)this.owner).func_146105_b((ITextComponent)message, true);
            }
        }
        return true;
    }

    @Override
    public void setLoyalty(double value) {
        this.loyalty = value;
    }

    @Override
    public int getInvulnerableTime() {
        return this.invulnerableTime;
    }

    @Override
    public void alterInvulnerableTime(int value) {
        this.invulnerableTime = Math.max(0, this.invulnerableTime + value);
    }

    @Override
    public void setInvulnerableTime(int value) {
        this.invulnerableTime = Math.max(value, 0);
    }

    @Override
    @Nullable
    public FactionHelper.MarineRank getMarineRank() {
        if (!this.isMarine()) {
            return null;
        }
        for (int i = 0; i < FactionHelper.MarineRank.values().length; ++i) {
            FactionHelper.MarineRank next;
            FactionHelper.MarineRank rank = FactionHelper.MarineRank.values()[i];
            FactionHelper.MarineRank marineRank = next = i + 1 < FactionHelper.MarineRank.values().length ? FactionHelper.MarineRank.values()[i + 1] : null;
            if (!(this.getLoyalty() >= (double)rank.getRequiredLoyalty()) || next != null && !(this.getLoyalty() < (double)next.getRequiredLoyalty())) continue;
            return rank;
        }
        return FactionHelper.MarineRank.CHORE_BOY;
    }

    @Override
    public boolean hasMarineRank(FactionHelper.MarineRank rank) {
        if (!this.isMarine()) {
            return false;
        }
        return this.getMarineRank().ordinal() >= rank.ordinal();
    }

    @Override
    @Nullable
    public FactionHelper.RevolutionaryRank getRevolutionaryRank() {
        if (!this.isRevolutionary()) {
            return null;
        }
        for (int i = 0; i < FactionHelper.RevolutionaryRank.values().length; ++i) {
            FactionHelper.RevolutionaryRank next;
            FactionHelper.RevolutionaryRank rank = FactionHelper.RevolutionaryRank.values()[i];
            FactionHelper.RevolutionaryRank revolutionaryRank = next = i + 1 < FactionHelper.RevolutionaryRank.values().length ? FactionHelper.RevolutionaryRank.values()[i + 1] : null;
            if (!(this.getLoyalty() >= (double)rank.getRequiredLoyalty()) || next != null && !(this.getLoyalty() < (double)next.getRequiredLoyalty())) continue;
            return rank;
        }
        return FactionHelper.RevolutionaryRank.MEMBER;
    }

    @Override
    public boolean hasRevolutionaryRank(FactionHelper.RevolutionaryRank rank) {
        if (!this.isRevolutionary()) {
            return false;
        }
        return this.getRevolutionaryRank().ordinal() >= rank.ordinal();
    }

    @Override
    public boolean isPirate() {
        if (Strings.isNullOrEmpty((String)this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("pirate");
    }

    @Override
    public boolean isMarine() {
        if (Strings.isNullOrEmpty((String)this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("marine");
    }

    @Override
    public boolean isBountyHunter() {
        if (Strings.isNullOrEmpty((String)this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("bounty_hunter");
    }

    @Override
    public boolean isRevolutionary() {
        if (Strings.isNullOrEmpty((String)this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("revolutionary");
    }

    @Override
    public boolean isBandit() {
        if (Strings.isNullOrEmpty((String)this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("bandit");
    }

    @Override
    public boolean isCivilian() {
        if (Strings.isNullOrEmpty((String)this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("civilian");
    }

    @Override
    public boolean hasFaction() {
        return !Strings.isNullOrEmpty((String)this.faction);
    }

    @Override
    public void setFaction(String value) {
        this.faction = WyHelper.getResourceName(value);
    }

    @Override
    public String getFaction() {
        return this.faction;
    }

    @Override
    public boolean isHuman() {
        if (Strings.isNullOrEmpty((String)this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("human");
    }

    @Override
    public boolean isFishman() {
        if (Strings.isNullOrEmpty((String)this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("fishman");
    }

    @Override
    public boolean isCyborg() {
        if (Strings.isNullOrEmpty((String)this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("cyborg");
    }

    @Override
    public boolean isMink() {
        if (Strings.isNullOrEmpty((String)this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("mink");
    }

    @Override
    public boolean hasRace() {
        return !Strings.isNullOrEmpty((String)this.race);
    }

    @Override
    public void setRace(String value) {
        this.race = WyHelper.getResourceName(value);
    }

    @Override
    public String getRace() {
        return this.race;
    }

    @Override
    public boolean isSwordsman() {
        if (Strings.isNullOrEmpty((String)this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("swordsman");
    }

    @Override
    public boolean isSniper() {
        if (Strings.isNullOrEmpty((String)this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("sniper");
    }

    @Override
    public boolean isDoctor() {
        if (Strings.isNullOrEmpty((String)this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("doctor");
    }

    @Override
    public boolean isWeatherWizard() {
        if (Strings.isNullOrEmpty((String)this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("art_of_weather");
    }

    @Override
    public boolean isBlackLeg() {
        if (Strings.isNullOrEmpty((String)this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("black_leg");
    }

    @Override
    public boolean isBrawler() {
        if (Strings.isNullOrEmpty((String)this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("brawler");
    }

    @Override
    public boolean hasFightingStyle() {
        return !Strings.isNullOrEmpty((String)this.fightingStyle);
    }

    @Override
    public void setFightingStyle(String value) {
        this.fightingStyle = value;
    }

    @Override
    public String getFightingStyle() {
        return this.fightingStyle;
    }

    @Override
    public boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public void setShadow(boolean value) {
        this.hasShadow = value;
    }

    @Override
    public boolean hasHeart() {
        return this.hasHeart;
    }

    @Override
    public void setHeart(boolean value) {
        this.hasHeart = value;
    }

    @Override
    public boolean isInCombatMode() {
        return this.inCombatMode;
    }

    @Override
    public void setCombatMode(boolean value) {
        this.inCombatMode = value;
    }

    @Override
    public boolean hasStrawDoll() {
        return this.hasStrawDoll;
    }

    @Override
    public void setStrawDoll(boolean value) {
        this.hasStrawDoll = value;
    }

    @Override
    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Override
    public void setDamageMultiplier(double multiplier) {
        this.damageMultiplier = multiplier;
    }

    @Override
    public boolean isBunnyMink() {
        return this.subRace.equalsIgnoreCase("mink_bunny");
    }

    @Override
    public boolean isDogMink() {
        return this.subRace.equalsIgnoreCase("mink_dog");
    }

    @Override
    public boolean isLionMink() {
        return this.subRace.equalsIgnoreCase("mink_lion");
    }

    @Override
    public void setSubRace(String value) {
        this.subRace = value;
    }

    @Override
    public String getSubRace() {
        return this.subRace;
    }

    @Override
    public boolean isRogue() {
        return this.isRogue;
    }

    @Override
    public void setRogue(boolean value) {
        this.isRogue = value;
    }

    @Override
    public void setXxa(float xxa) {
        this.xxa = xxa;
    }

    @Override
    public float getXxa() {
        return this.xxa;
    }

    @Override
    public void setZza(float zza) {
        this.zza = zza;
    }

    @Override
    public float getZza() {
        return this.zza;
    }
}

