/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.RandomRanges;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModLootTypes;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class IncreaseLoyaltyFunction
extends LootFunction {
    private IRandomRange amount;
    private StatChangeSource source;

    protected IncreaseLoyaltyFunction(ILootCondition[] conditions, IRandomRange amount, StatChangeSource source) {
        super(conditions);
        this.amount = amount;
        this.source = source;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity killer = (Entity)context.func_216031_c(LootParameters.field_216284_d);
            int amount = this.amount.func_186511_a(context.func_216032_b());
            if (killer != null && killer instanceof LivingEntity) {
                boolean hasLoyalty;
                target = (LivingEntity)killer;
                boolean bl = hasLoyalty = EntityStatsCapability.get(target).isMarine() || EntityStatsCapability.get(target).isRevolutionary();
                if (!(this.source != StatChangeSource.KILL_NPC || CommonConfig.INSTANCE.isMobRewardsEnabled() && hasLoyalty)) {
                    amount = 0;
                }
            }
            IEntityStats props = EntityStatsCapability.get(target);
            boolean hasUpdate = props.alterLoyalty(amount, this.source);
            if (target instanceof ServerPlayerEntity && hasUpdate) {
                WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)target));
            }
            stack.func_200302_a((ITextComponent)new StringTextComponent("_rewards"));
            stack.func_196082_o().func_74768_a("_rewardsLoyalty", amount);
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootTypes.INCREASE_BELLY;
    }

    public static LootFunction.Builder<?> builder(int amount, StatChangeSource source) {
        return IncreaseLoyaltyFunction.func_215860_a(condition -> new IncreaseLoyaltyFunction((ILootCondition[])condition, (IRandomRange)ConstantRange.func_215835_a((int)amount), source));
    }

    public static LootFunction.Builder<?> builder(IRandomRange amount, StatChangeSource source) {
        return IncreaseLoyaltyFunction.func_215860_a(condition -> new IncreaseLoyaltyFunction((ILootCondition[])condition, amount, source));
    }

    public static class Serializer
    extends LootFunction.Serializer<IncreaseLoyaltyFunction> {
        public void serialize(JsonObject object, IncreaseLoyaltyFunction func, JsonSerializationContext context) {
            super.func_230424_a_(object, (LootFunction)func, context);
            object.add("amount", context.serialize((Object)func.amount));
            object.add("source", context.serialize((Object)func.source));
        }

        public IncreaseLoyaltyFunction deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] cond) {
            IRandomRange amount = RandomRanges.func_216130_a((JsonElement)object.get("amount"), (JsonDeserializationContext)context);
            StatChangeSource source = (StatChangeSource)((Object)context.deserialize(object.get("source"), StatChangeSource.class));
            return new IncreaseLoyaltyFunction(cond, amount, source);
        }
    }
}

