/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.SoulboundMark;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ExtendedWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi";
    private HashMap<String, Long> issuedBounties = new HashMap();
    private HashMap<String, Crew> pirateCrews = new HashMap();
    private List<String> generatedArenas = new ArrayList<String>();
    private HashMap<UUID, SoulboundMark> linkedItemStatus = new HashMap();
    @Deprecated
    private static final ExtendedWorldData CLIENT_DATA = new ExtendedWorldData();

    public ExtendedWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static ExtendedWorldData get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (ExtendedWorldData)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(ExtendedWorldData::new, IDENTIFIER);
        }
        return null;
    }

    @Deprecated
    public static ExtendedWorldData get(IWorld world) {
        if (world == null) {
            return null;
        }
        ExtendedWorldData worldExt = null;
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = ((ServerWorld)world).func_73046_m().func_71218_a(World.field_234918_g_);
            worldExt = (ExtendedWorldData)serverWorld.func_217481_x().func_215752_a(ExtendedWorldData::new, IDENTIFIER);
        } else {
            worldExt = CLIENT_DATA;
        }
        return worldExt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT bounties = nbt.func_74775_l("issuedBounties");
        this.issuedBounties.clear();
        bounties.func_150296_c().stream().forEach(x -> this.issuedBounties.put((String)x, bounties.func_74763_f(x)));
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            ListNBT protectedAreas = nbt.func_150295_c("protectedAreas", 10);
            ProtectedAreasData protectedAreaData = ProtectedAreasData.get((World)ServerLifecycleHooks.getCurrentServer().func_241755_D_());
            for (int i = 0; i < protectedAreas.size(); ++i) {
                CompoundNBT areaNBT = protectedAreas.func_150305_b(i);
                ProtectedArea area = ProtectedArea.from(areaNBT);
                BlockPos pos = area.getCenter();
                if (protectedAreaData.getProtectedArea(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) != null) continue;
                ModMain.LOGGER.info(ModMain.MARKER, String.format("Ported a protection area with its center at %s %s %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                protectedAreaData.addRestrictedArea(pos, area.getSize(), area.getLabel());
            }
        }
        ListNBT crews = nbt.func_150295_c("crews", 10);
        this.pirateCrews.clear();
        for (int i = 0; i < crews.size(); ++i) {
            CompoundNBT crewNBT = crews.func_150305_b(i);
            Crew crew = Crew.from(crewNBT);
            this.pirateCrews.put(WyHelper.getResourceName(crew.getName()), crew);
        }
        CompoundNBT generatedArenas = nbt.func_74775_l("generatedArenas");
        this.generatedArenas.clear();
        generatedArenas.func_150296_c().stream().forEach(key -> this.generatedArenas.add((String)key));
        CompoundNBT linkedItemMarksNBT = nbt.func_74775_l("linkedItemMarks");
        this.linkedItemStatus.clear();
        linkedItemMarksNBT.func_150296_c().stream().forEach(key -> {
            SoulboundMark markType = SoulboundMark.values()[linkedItemMarksNBT.func_74762_e(key)];
            this.linkedItemStatus.put(UUID.fromString(key), markType);
        });
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        CompoundNBT bounties = new CompoundNBT();
        if (this.issuedBounties.size() > 0) {
            this.issuedBounties.entrySet().stream().forEach(x -> bounties.func_74772_a((String)x.getKey(), ((Long)x.getValue()).longValue()));
        }
        nbt.func_218657_a("issuedBounties", (INBT)bounties);
        ListNBT crews = new ListNBT();
        for (Crew crew : this.pirateCrews.values()) {
            crews.add((Object)crew.write());
        }
        nbt.func_218657_a("crews", (INBT)crews);
        CompoundNBT generatedArenas = new CompoundNBT();
        if (this.generatedArenas.size() > 0) {
            for (String key : this.generatedArenas) {
                generatedArenas.func_74757_a(key, true);
            }
        }
        nbt.func_218657_a("generatedArenas", (INBT)generatedArenas);
        CompoundNBT compoundNBT = new CompoundNBT();
        if (this.linkedItemStatus.size() > 0) {
            for (Map.Entry<UUID, SoulboundMark> entry : this.linkedItemStatus.entrySet()) {
                compoundNBT.func_74768_a(entry.getKey().toString(), entry.getValue().ordinal());
            }
        }
        nbt.func_218657_a("linkedItemMarks", (INBT)compoundNBT);
        return nbt;
    }

    public void markDead(UUID id) {
        this.linkedItemStatus.put(id, SoulboundMark.DEATH);
        this.func_76185_a();
    }

    public void markRestore(UUID id, SoulboundMark mark) {
        this.linkedItemStatus.put(id, mark);
        this.func_76185_a();
    }

    public void removeMark(UUID id) {
        this.linkedItemStatus.remove(id);
        this.func_76185_a();
    }

    public boolean isOnDeathList(UUID id) {
        return this.linkedItemStatus.get(id) == SoulboundMark.DEATH;
    }

    public boolean isOnRestoreList(UUID id, SoulboundMark mark) {
        return this.linkedItemStatus.get(id) == mark;
    }

    public boolean isArenaGenerated(String key) {
        return this.generatedArenas.contains(key);
    }

    public List<String> getGeneratedArenas() {
        return this.generatedArenas;
    }

    public void removeGeneratedArena(String key) {
        this.generatedArenas.remove(key);
        this.func_76185_a();
    }

    public void addGeneratedArena(String key) {
        this.generatedArenas.add(key);
        this.func_76185_a();
    }

    public List<Crew> getCrews() {
        return new ArrayList<Crew>(this.pirateCrews.values());
    }

    @Nullable
    public Crew getCrewWithMember(UUID memId) {
        for (Crew crew : this.pirateCrews.values()) {
            for (Crew.Member member : crew.getMembers()) {
                if (!member.getUUID().equals(memId)) continue;
                return crew;
            }
        }
        return null;
    }

    @Nullable
    public Crew getCrewByName(String name) {
        for (Crew crew : this.pirateCrews.values()) {
            if (!crew.getName().equals(name)) continue;
            return crew;
        }
        return null;
    }

    @Nullable
    public Crew getCrewWithCaptain(UUID capId) {
        return this.pirateCrews.values().stream().filter(crew -> crew.getCaptain() != null && crew.getCaptain().getUUID().equals(capId)).findFirst().orElse(null);
    }

    public void removeCrew(Crew crew) {
        String key = WyHelper.getResourceName(crew.getName());
        if (this.pirateCrews.containsKey(key)) {
            this.pirateCrews.remove(key);
        }
        this.func_76185_a();
    }

    public void addCrew(Crew crew) {
        String key = WyHelper.getResourceName(crew.getName());
        if (!this.pirateCrews.containsKey(key)) {
            this.pirateCrews.put(key, crew);
        }
        this.func_76185_a();
    }

    public void removeCrewMember(Crew crew, UUID uuid) {
        crew.removeMember(uuid);
        this.func_76185_a();
    }

    public void addCrewMember(Crew crew, LivingEntity entity) {
        this.addCrewMember(crew, entity, true);
    }

    public void addTemporaryCrewMember(Crew crew, LivingEntity entity) {
        this.addCrewMember(crew, entity, false);
    }

    public void addCrewMember(Crew crew, LivingEntity entity, boolean saveMember) {
        String key = WyHelper.getResourceName(crew.getName());
        if (!this.pirateCrews.containsKey(key)) {
            this.pirateCrews.put(key, crew);
        } else {
            crew = this.pirateCrews.get(key);
        }
        crew.addMember(entity, saveMember);
        this.func_76185_a();
    }

    public void updateCrewJollyRoger(Crew crew, JollyRoger jollyRoger) {
        crew.setJollyRoger(jollyRoger);
        this.func_76185_a();
    }

    public HashMap<String, Long> getAllBounties() {
        return this.issuedBounties;
    }

    public Object[] getRandomBounty() {
        int count = this.getAllBounties().size();
        if (count <= 0) {
            return null;
        }
        Object[] keys = this.getAllBounties().keySet().toArray();
        Object key = keys[new Random().nextInt(count)];
        long bounty = this.getAllBounties().get(key);
        return new Object[]{key, bounty};
    }

    public long getBounty(String uuid) {
        if (this.issuedBounties.containsKey(uuid.toLowerCase())) {
            return this.issuedBounties.get(uuid.toLowerCase());
        }
        return 0L;
    }

    public boolean hasIssuedBounty(LivingEntity entity) {
        String uuidAsStr = entity.func_110124_au().toString().toLowerCase();
        return this.issuedBounties.containsKey(uuidAsStr);
    }

    public void issueBounty(String uuid, long bounty) {
        if (this.issuedBounties.containsKey(uuid.toLowerCase())) {
            this.issuedBounties.remove(uuid.toLowerCase());
            this.issuedBounties.put(uuid.toLowerCase(), bounty);
        } else {
            this.issuedBounties.put(uuid.toLowerCase(), bounty);
        }
        this.func_76185_a();
    }
}

