/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.datagen.advancements;

import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.data.ExistingFileHelper;
import xyz.pixelatedw.mineminenomi.abilities.BellyFlopAbility;
import xyz.pixelatedw.mineminenomi.abilities.PearlFireAbility;
import xyz.pixelatedw.mineminenomi.abilities.ShakushiAbility;
import xyz.pixelatedw.mineminenomi.abilities.StealPunchAbility;
import xyz.pixelatedw.mineminenomi.abilities.bomu.BreezeBreathBombAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.TackleAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleChampionAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.DoruDoruArtsMoriAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.KarakusagawaraSeikenAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MizuTaihoAbility;
import xyz.pixelatedw.mineminenomi.abilities.kilo.KiloPress1Ability;
import xyz.pixelatedw.mineminenomi.abilities.mandemontactics.DemonicDanceAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.GrandeSablesAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SablesAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.SparClawAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.SpiralHollowAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.ShiShishiSonsonAbility;
import xyz.pixelatedw.mineminenomi.api.AbilityDisplayInfo;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.triggers.CompleteChallengeTrigger;
import xyz.pixelatedw.mineminenomi.data.triggers.UnlockChallengeTrigger;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModChallenges;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class ChallengeAdvancements
implements Consumer<Consumer<Advancement>> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/adventure.png");
    private ExistingFileHelper fileHelper;

    public ChallengeAdvancements(ExistingFileHelper fileHelper) {
        this.fileHelper = fileHelper;
    }

    @Override
    public void accept(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)ModBlocks.PONEGLYPH.get(), (ITextComponent)ModI18n.Advancements.title("challenges.root"), (ITextComponent)ModI18n.Advancements.description("challenges.root"), BACKGROUND, FrameType.TASK, false, false, false).func_200275_a("unlock_challenge", (ICriterionInstance)UnlockChallengeTrigger.Instance.unlockAnyChallenge()).save(consumer, new ResourceLocation("mineminenomi", "challenges/root"), this.fileHelper);
        Advancement higuma = this.standard(root, (ChallengeCore)ModChallenges.HIGUMA.get(), (IItemProvider)ModWeapons.CUTLASS.get(), consumer);
        this.hard(higuma, (ChallengeCore)ModChallenges.HIGUMA_HARD.get(), ShiShishiSonsonAbility.INSTANCE, consumer);
        ItemStack marineAxe = new ItemStack((IItemProvider)ModWeapons.AXE.get());
        marineAxe.func_190925_c("display").func_74768_a("color", MobsHelper.MARINE_BLUE_COLOR.getRGB());
        Advancement morgan = this.standard(root, (ChallengeCore)ModChallenges.MORGAN.get(), marineAxe, consumer);
        this.hard(morgan, (ChallengeCore)ModChallenges.MORGAN_HARD.get(), TackleAbility.INSTANCE, consumer);
        Advancement kuro = this.standard(root, (ChallengeCore)ModChallenges.KURO.get(), (IItemProvider)ModArmors.KURO_CHEST.get(), consumer);
        this.hard(kuro, (ChallengeCore)ModChallenges.KURO_HARD.get(), ShakushiAbility.INSTANCE, consumer);
        Advancement nyanban = this.standard(root, (ChallengeCore)ModChallenges.NYANBAN_BROTHERS.get(), StealPunchAbility.INSTANCE, consumer);
        this.hard(nyanban, (ChallengeCore)ModChallenges.NYANBAN_BROTHERS_HARD.get(), BellyFlopAbility.INSTANCE, consumer);
        Advancement krieg = this.standard(root, (ChallengeCore)ModChallenges.DON_KRIEG.get(), (IItemProvider)ModArmors.MH5_GAS_MASK.get(), consumer);
        this.hard(krieg, (ChallengeCore)ModChallenges.DON_KRIEG_HARD.get(), (IItemProvider)ModWeapons.DAISENSO.get(), consumer);
        Advancement gin = this.standard(root, (ChallengeCore)ModChallenges.GIN.get(), (IItemProvider)ModWeapons.TONFA.get(), consumer);
        this.hard(gin, (ChallengeCore)ModChallenges.GIN_HARD.get(), DemonicDanceAbility.INSTANCE, consumer);
        Advancement pearl = this.standard(root, (ChallengeCore)ModChallenges.PEARL.get(), (IItemProvider)ModArmors.PEARL_HAT.get(), consumer);
        this.hard(pearl, (ChallengeCore)ModChallenges.PEARL_HARD.get(), PearlFireAbility.INSTANCE, consumer);
        Advancement arlong = this.standard(root, (ChallengeCore)ModChallenges.ARLONG.get(), (IItemProvider)ModArmors.ARLONG_CHEST.get(), consumer);
        this.hard(arlong, (ChallengeCore)ModChallenges.ARLONG_HARD.get(), (IItemProvider)ModWeapons.KIRIBACHI.get(), consumer);
        Advancement kuroobi = this.standard(root, (ChallengeCore)ModChallenges.KUROOBI.get(), (IItemProvider)ModArmors.KUROOBI_CHEST.get(), consumer);
        this.hard(kuroobi, (ChallengeCore)ModChallenges.KUROOBI_HARD.get(), KarakusagawaraSeikenAbility.INSTANCE, consumer);
        Advancement chew = this.standard(root, (ChallengeCore)ModChallenges.CHEW.get(), (IItemProvider)ModArmors.CHEW_CHEST.get(), consumer);
        this.hard(chew, (ChallengeCore)ModChallenges.CHEW_HARD.get(), MizuTaihoAbility.INSTANCE, consumer);
        Advancement mr0 = this.standard(root, (ChallengeCore)ModChallenges.MR_0.get(), SablesAbility.INSTANCE, consumer);
        this.hard(mr0, (ChallengeCore)ModChallenges.MR_0_HARD.get(), GrandeSablesAbility.INSTANCE, consumer);
        Advancement mr1 = this.standard(root, (ChallengeCore)ModChallenges.MR_1.get(), SparClawAbility.INSTANCE, consumer);
        this.hard(mr1, (ChallengeCore)ModChallenges.MR_1_HARD.get(), SpiralHollowAbility.INSTANCE, consumer);
        Advancement mr3 = this.standard(root, (ChallengeCore)ModChallenges.MR_3.get(), DoruDoruArtsMoriAbility.INSTANCE, consumer);
        this.hard(mr3, (ChallengeCore)ModChallenges.MR_3_HARD.get(), CandleChampionAbility.INSTANCE, consumer);
        Advancement mr5MissValentine = this.standard(root, (ChallengeCore)ModChallenges.MR_5_AND_MISS_VALENTINE.get(), KiloPress1Ability.INSTANCE, consumer);
        this.hard(mr5MissValentine, (ChallengeCore)ModChallenges.MR_5_AND_MISS_VALENTINE_HARD.get(), BreezeBreathBombAbility.INSTANCE, consumer);
    }

    private Advancement standard(Advancement parent, ChallengeCore<?> challengeCore, IItemProvider itemProvider, Consumer<Advancement> consumer) {
        DisplayInfo displayInfo = new DisplayInfo(new ItemStack((IItemProvider)itemProvider.func_199767_j()), (ITextComponent)challengeCore.getLocalizedTitle(), (ITextComponent)challengeCore.getLocalizedObjective(), null, FrameType.TASK, true, false, true);
        return this.challenge(parent, challengeCore, displayInfo, consumer);
    }

    private Advancement standard(Advancement parent, ChallengeCore<?> challengeCore, ItemStack itemStack, Consumer<Advancement> consumer) {
        DisplayInfo displayInfo = new DisplayInfo(itemStack, (ITextComponent)challengeCore.getLocalizedTitle(), (ITextComponent)challengeCore.getLocalizedObjective(), null, FrameType.TASK, true, false, true);
        return this.challenge(parent, challengeCore, displayInfo, consumer);
    }

    private Advancement standard(Advancement parent, ChallengeCore<?> challengeCore, AbilityCore<?> abilityCore, Consumer<Advancement> consumer) {
        AbilityDisplayInfo displayInfo = new AbilityDisplayInfo(abilityCore, (ITextComponent)challengeCore.getLocalizedTitle(), (ITextComponent)challengeCore.getLocalizedObjective(), null, FrameType.TASK, true, false, true);
        return this.challenge(parent, challengeCore, displayInfo, consumer);
    }

    private Advancement hard(Advancement parent, ChallengeCore<?> challengeCore, IItemProvider itemProvider, Consumer<Advancement> consumer) {
        DisplayInfo displayInfo = new DisplayInfo(new ItemStack((IItemProvider)itemProvider.func_199767_j()), (ITextComponent)challengeCore.getLocalizedTitle(), (ITextComponent)challengeCore.getLocalizedObjective(), null, FrameType.CHALLENGE, true, true, false);
        return this.challenge(parent, challengeCore, displayInfo, consumer);
    }

    private Advancement hard(Advancement parent, ChallengeCore<?> challengeCore, ItemStack itemStack, Consumer<Advancement> consumer) {
        DisplayInfo displayInfo = new DisplayInfo(itemStack, (ITextComponent)challengeCore.getLocalizedTitle(), (ITextComponent)challengeCore.getLocalizedObjective(), null, FrameType.CHALLENGE, true, true, false);
        return this.challenge(parent, challengeCore, displayInfo, consumer);
    }

    private Advancement hard(Advancement parent, ChallengeCore<?> challengeCore, AbilityCore<?> abilityCore, Consumer<Advancement> consumer) {
        AbilityDisplayInfo displayInfo = new AbilityDisplayInfo(abilityCore, (ITextComponent)challengeCore.getLocalizedTitle(), (ITextComponent)challengeCore.getLocalizedObjective(), null, FrameType.CHALLENGE, true, true, false);
        return this.challenge(parent, challengeCore, displayInfo, consumer);
    }

    private Advancement challenge(Advancement parent, ChallengeCore<?> challengeCore, DisplayInfo display, Consumer<Advancement> consumer) {
        return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203903_a(display).func_200275_a("unlock_challenge", (ICriterionInstance)CompleteChallengeTrigger.Instance.completeChallenge(challengeCore)).save(consumer, new ResourceLocation("mineminenomi", "challenges/" + challengeCore.getId()), this.fileHelper);
    }
}

