/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.datagen.loottables;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.wypi.LootTablesDataGen;

public class BlocksLootTablesDataGen
extends LootTablesDataGen {
    private final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();

    public BlocksLootTablesDataGen(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addLootTable((Block)ModBlocks.KAIROSEKI_ORE.get(), this.createOreLootPool((Item)ModItems.KAIROSEKI.get(), 1, 1, 3.0f, 6.0f));
        this.addLootTable((Block)ModBlocks.AXE_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.AXE_DIAL.get()));
        this.addLootTable((Block)ModBlocks.BREATH_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.BREATH_DIAL.get()));
        this.addLootTable((Block)ModBlocks.FLAME_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.FLAME_DIAL.get()));
        this.addLootTable((Block)ModBlocks.REJECT_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.REJECT_DIAL.get()));
        this.addLootTable((Block)ModBlocks.IMPACT_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.IMPACT_DIAL.get()));
        this.addLootTable((Block)ModBlocks.FLASH_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.FLASH_DIAL.get()));
        this.addLootTable((Block)ModBlocks.EISEN_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.EISEN_DIAL.get()));
        this.addLootTable((Block)ModBlocks.MILKY_DIAL.get(), this.createSelfDropLootPool((Block)ModBlocks.MILKY_DIAL.get()));
        this.addLootTable((Block)ModBlocks.DEN_DEN_MUSHI.get(), this.createSelfDropLootPool((Block)ModBlocks.DEN_DEN_MUSHI.get()));
        this.addLootTable((Block)ModBlocks.CANNON.get(), this.createSelfDropLootPool((Block)ModBlocks.CANNON.get()));
        this.addLootTable((Block)ModBlocks.KAIROSEKI.get(), this.createSelfDropLootPool((Block)ModBlocks.KAIROSEKI.get()));
        this.addLootTable((Block)ModBlocks.KAIROSEKI_BARS.get(), this.createSelfDropLootPool((Block)ModBlocks.KAIROSEKI_BARS.get()));
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        this.lootTables.forEach((block, builder) -> tables.put(block.func_220068_i(), builder.func_216038_b()));
        this.writeTables(cache, tables);
    }

    protected LootPool.Builder createBasicLootPool(Item drop, int roll, float count) {
        return this.createBasicLootPool(drop, roll, roll, count, count);
    }

    protected LootPool.Builder createBasicLootPool(Item drop, int rollMin, int rollMax, float countMin, float countMax) {
        Object rollRange = rollMin == rollMax ? ConstantRange.func_215835_a((int)rollMin) : RandomValueRange.func_215837_a((float)rollMin, (float)rollMax);
        Object countRange = countMin == countMax ? ConstantRange.func_215835_a((int)((int)countMin)) : RandomValueRange.func_215837_a((float)countMin, (float)countMax);
        return LootPool.func_216096_a().func_216046_a((IRandomRange)rollRange).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)drop).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)countRange)));
    }

    protected LootPool.Builder createSelfDropLootPool(Block block) {
        return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block.func_199767_j()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))));
    }

    protected LootPool.Builder createOreLootPool(Item ore, int roll, float count) {
        return this.createOreLootPool(ore, roll, roll, count, count);
    }

    protected LootPool.Builder createOreLootPool(Item ore, int rollMin, int rollMax, float countMin, float countMax) {
        Object rollRange = rollMin == rollMax ? ConstantRange.func_215835_a((int)rollMin) : RandomValueRange.func_215837_a((float)rollMin, (float)rollMax);
        Object countRange = countMin == countMax ? ConstantRange.func_215835_a((int)((int)countMin)) : RandomValueRange.func_215837_a((float)countMin, (float)countMax);
        return LootPool.func_216096_a().func_216046_a((IRandomRange)rollRange).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ore).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)countRange)).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t)));
    }

    protected void addLootTable(Block block, LootPool.Builder ... pools) {
        LootTable.Builder builder = LootTable.func_216119_b();
        for (LootPool.Builder pool : pools) {
            builder.func_216040_a(pool);
        }
        this.lootTables.put(block, builder);
    }

    @Override
    public String func_200397_b() {
        return "Blocks Loot Pools";
    }
}

