/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BombEntity
extends Entity {
    private LivingEntity owner;
    private final Predicate<Entity> targetPredicate;
    private int fuseTime = 300;
    private boolean canDestroyBlocks = false;
    private boolean explodeOnImpact = false;

    public BombEntity(EntityType type, World world) {
        super(type, world);
        this.targetPredicate = entity -> true;
    }

    public BombEntity(World world, LivingEntity owner) {
        super((EntityType)ModEntities.BOMB.get(), world);
        this.owner = owner;
        this.targetPredicate = entity -> {
            if (entity.equals((Object)owner)) {
                return false;
            }
            if (entity instanceof BombEntity) {
                return false;
            }
            return !ModEntityPredicates.getFriendlyFactions(owner).test((Entity)entity);
        };
    }

    public boolean func_241849_j(Entity entity) {
        return !(entity instanceof BombEntity);
    }

    public void setFuseTime(int fuseTime) {
        this.fuseTime = fuseTime;
    }

    public void setDestroyBlocks() {
        this.canDestroyBlocks = true;
    }

    public void setExplodeOnImpact() {
        this.explodeOnImpact = true;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            List targets;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.098f, 0.0));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
                if (this.field_70124_G || this.field_70123_F) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    if (this.explodeOnImpact) {
                        this.func_70106_y();
                    }
                }
            }
            if (this.field_70173_aa % 10 == 0 && (targets = WyHelper.getNearbyEntities(this.func_213303_ch(), (IWorld)this.field_70170_p, 2.0, this.targetPredicate, LivingEntity.class)).size() > 0) {
                this.func_70106_y();
            }
            if (this.field_70173_aa >= this.fuseTime) {
                this.func_70106_y();
            }
        }
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion(this, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 4.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(this.canDestroyBlocks);
            explosion.setFireAfterExplosion(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.setDamageEntities(true);
            explosion.doExplosion();
        }
        super.func_70106_y();
    }

    protected void func_70088_a() {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241845_aY() {
        return true;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

