/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.SablesNewParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TornadoEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private LivingEntity owner;
    private SablesNewParticleEffect.Details details = new SablesNewParticleEffect.Details();
    private int maxLife = 60;
    private float size = 1.0f;
    private float speed = 1.0f;
    private Vector3d vector = null;
    private List<BlockState> states = new ArrayList<BlockState>();

    public TornadoEntity(World level, LivingEntity entity) {
        super((EntityType)ModEntities.TORNADO.get(), level);
        this.owner = entity;
    }

    public TornadoEntity(EntityType<?> type, World pLevel) {
        super(type, pLevel);
    }

    public void setMaxLife(int maxLife) {
        this.maxLife = maxLife;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.speed;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.maxLife > 0 && this.field_70173_aa >= this.maxLife) {
                this.func_70106_y();
                return;
            }
            if (this.owner == null) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa % 40 == 0) {
                this.details.setSize(this.size);
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SABLES_NEW.get(), this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.details);
            }
            AxisAlignedBB box = new AxisAlignedBB(this.func_233580_cy_()).func_72314_b((double)(this.size / 2.0f), (double)this.size, (double)(this.size / 2.0f));
            for (Entity entity : this.field_70170_p.func_175647_a(Entity.class, box, e -> e != this.owner)) {
                double px = entity.func_213322_ci().field_72450_a + (this.func_226277_ct_() - entity.func_226277_ct_()) / 25.0;
                double py = entity.func_213322_ci().field_72448_b + (this.func_226278_cu_() + (double)(this.size / 2.0f) - entity.func_226278_cu_()) / 25.0;
                double pz = entity.func_213322_ci().field_72449_c + (this.func_226281_cx_() - entity.func_226281_cx_()) / 25.0;
                entity.func_213293_j(px, py, pz);
                entity.field_70133_I = true;
                if (this.func_70032_d(entity) < 2.0f) {
                    entity.func_70097_a(DamageSource.field_188406_j, this.getSize() / 3.0f);
                }
                if (!(entity instanceof FallingBlockEntity)) continue;
                FallingBlockEntity falling = (FallingBlockEntity)entity;
                this.states.add(falling.func_195054_l());
            }
            ProtectedArea area = ProtectedAreasData.get(this.field_70170_p).getProtectedArea((int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_());
            if (area == null && CommonConfig.INSTANCE.isAbilityGriefingEnabled()) {
                for (double x = box.field_72340_a; x < box.field_72336_d; x += 1.0) {
                    for (double y = box.field_72338_b; y < box.field_72337_e; y += 1.0) {
                        for (double z = box.field_72339_c; z < box.field_72334_f; z += 1.0) {
                            boolean hasAirAbove;
                            BlockPos blockPos = new BlockPos(x, y, z);
                            BlockState state = this.field_70170_p.func_180495_p(blockPos);
                            boolean bl = hasAirAbove = this.field_70170_p.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150350_a;
                            if (state.func_196958_f() || !((double)this.field_70146_Z.nextFloat() > 0.9995) || DefaultProtectionRules.CORE_FOLIAGE_ORE.isBanned(state) || !hasAirAbove) continue;
                            FallingBlockEntity fallingBlock = new FallingBlockEntity(this.field_70170_p, x, y, z, state);
                            fallingBlock.func_213293_j(0.0, WyHelper.randomDouble() * 2.0, 0.0);
                            fallingBlock.field_70133_I = true;
                            fallingBlock.field_145813_c = false;
                            fallingBlock.field_145812_b = 1;
                            this.field_70170_p.func_217376_c((Entity)fallingBlock);
                            WyHelper.setBlockStateInChunk(this.field_70170_p, blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                }
            }
            if (this.vector != null) {
                this.field_70145_X = true;
                Vector3d dist = this.func_213303_ch().func_178788_d(this.vector).func_72441_c(0.0, -1.0, 0.0);
                double speedReduction = 20.0;
                double speed = 0.4;
                double xSpeed = Math.min(speed, -dist.field_72450_a / speedReduction);
                double zSpeed = Math.min(speed, -dist.field_72449_c / speedReduction);
                this.func_213315_a(MoverType.SELF, new Vector3d(xSpeed, 0.0, zSpeed));
            }
            if (this.func_70026_G() && this.field_70173_aa % 20 == 0) {
                this.func_70106_y();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_242278_a(BlockPos pPos, BlockState pState) {
        return false;
    }

    public EntitySize func_213305_a(Pose pose) {
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220313_a(this.size / 2.0f);
        return newSize;
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.maxLife = nbt.func_74762_e("maxLife");
        this.size = nbt.func_74760_g("size");
        this.speed = nbt.func_74760_g("speed");
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("maxLife", this.maxLife);
        nbt.func_74776_a("size", this.size);
        nbt.func_74776_a("speed", this.speed);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeFloat(this.size);
        buf.writeFloat(this.speed);
    }

    public void readSpawnData(PacketBuffer buf) {
        this.size = buf.readFloat();
        this.speed = buf.readFloat();
    }

    public List<BlockState> getBlocksUsed() {
        return this.states;
    }

    public void setVector(Vector3d vector) {
        this.vector = vector;
    }
}

