/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.TackleAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FightingStyleHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.ChargedCleaveWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.WeaponSpinWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.GenkotsuMeteorWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.TackleWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.OTatsumakiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.ShiShishiSonsonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.YakkodoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BruteEntity
extends OPEntity
implements IRangedAttackMob,
ICommandReceiver {
    private static final UUID TACKLE_COOLDOWN_BONUS_UUID = UUID.fromString("2839290d-9070-45fb-a7ac-465405562ec6");
    private static final String[] STYLES = new String[]{"swordsman", "sniper", "brawler"};
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    public BruteEntity(EntityType type, World world, String faction) {
        super(type, world, null);
        String style = STYLES[this.func_70681_au().nextInt(STYLES.length)];
        if (world != null && !world.field_72995_K) {
            this.getEntityStats().setFaction(faction);
            this.getEntityStats().setFightingStyle(style);
            this.getEntityStats().setRace("human");
            this.setDetails();
            boolean isHardDifficulty = this.isAboveNormalDifficulty();
            this.setDoriki(2000.0 + WyHelper.randomWithRange(0, 1500) + (isHardDifficulty ? WyHelper.randomWithRange(0, 500) : 0.0));
            this.setBelly(5.0 + WyHelper.randomWithRange(0, 5));
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(60.0);
            MobsHelper.addBasicNPCGoals(this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.3);
            MobsHelper.addBusoshokuHaki((MobEntity)this, 15);
        }
    }

    public static BruteEntity createMarineBrute(EntityType type, World world) {
        return new BruteEntity(type, world, "marine");
    }

    public static BruteEntity createPirateBrute(EntityType type, World world) {
        return new BruteEntity(type, world, "pirate");
    }

    public static BruteEntity createBanditBrute(EntityType type, World world) {
        return new BruteEntity(type, world, "bandit");
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, WyHelper.randomWithRange(4, 6)).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange(80, 100)).func_233815_a_(Attributes.field_233826_i_, WyHelper.randomWithRange(8, 12));
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        if (this.func_184614_ca() == null || !this.func_184614_ca().func_77973_b().equals(ModWeapons.BAZOOKA.get())) {
            return;
        }
        CannonBallProjectile proj = new CannonBallProjectile(this.field_70170_p, (LivingEntity)this);
        proj.setDamage(3.0f);
        proj.onBlockImpactEvent = hit -> {
            if (this.field_70173_aa < 2) {
                return;
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj, this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 2.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        double velX = target.func_226277_ct_() - this.func_226277_ct_();
        double velY = target.func_174813_aQ().field_72338_b - proj.func_226278_cu_();
        double velZ = target.func_226281_cx_() - this.func_226281_cx_();
        double x = MathHelper.func_76133_a((double)(velX * velX + velZ * velZ));
        proj.func_70186_c(velX, velY + x * (double)0.1f, velZ, 2.0f, MathHelper.func_76125_a((int)(12 - this.field_70170_p.func_175659_aa().func_151525_a() * 4), (int)0, (int)100));
        this.field_70170_p.func_217376_c((Entity)proj);
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ModSounds.GENERIC_EXPLOSION.get(), SoundCategory.PLAYERS, 2.5f, 0.75f + this.func_70681_au().nextFloat() / 4.0f);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    private void setDetails() {
        IEntityStats props = this.getEntityStats();
        if (props.isPirate()) {
            this.setPirateDetails();
        } else if (props.isMarine()) {
            this.setMarineDetails();
        } else if (props.isBandit()) {
            this.setBanditDetails();
        }
        this.chooseTexture();
        if (props.isSwordsman()) {
            this.setSwordsmanDetails();
        } else if (props.isSniper()) {
            this.setSniperDetails();
        } else if (props.isBrawler()) {
            this.setBrawlerDetails();
        }
    }

    private void setSwordsmanDetails() {
        ItemStack randomSword = this.getRandomSword(MobsHelper.BRUTE_SWORDS);
        if (this.getEntityStats().isMarine() && randomSword.func_77973_b() instanceof IDyeableArmorItem) {
            randomSword.func_190925_c("display").func_74768_a("color", MobsHelper.MARINE_BLUE_COLOR.getRGB());
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new ChargedCleaveWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new ShiShishiSonsonWrapperGoal((MobEntity)this), 2.0f);
        goals.addEntry(() -> new YakkodoriWrapperGoal((MobEntity)this), 2.0f);
        goals.addEntry(() -> new WeaponSpinWrapperGoal((MobEntity)this), 1.0f);
        goals.addEntry(() -> new OTatsumakiWrapperGoal((MobEntity)this), 1.0f);
        MobsHelper.getRandomizedGoals((MobEntity)this, this.isAboveNormalDifficulty() ? 2 : 1, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
    }

    private void setSniperDetails() {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.BAZOOKA.get()));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, this.isAboveNormalDifficulty() ? 100 : 160, 40.0f));
    }

    private void setBrawlerDetails() {
        FightingStyleHelper.applyBrawlerModifiers((LivingEntity)this);
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new SuplexWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new SpinningBrawlWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> {
            TackleWrapperGoal tackleWrapper = new TackleWrapperGoal((MobEntity)this);
            ((TackleAbility)tackleWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(TACKLE_COOLDOWN_BONUS_UUID, "Tackle Cooldown Bonus", BonusOperation.MUL, 2.0f));
            return tackleWrapper;
        }, 2.0f);
        goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 2.0f);
        goals.addEntry(() -> new GenkotsuMeteorWrapperGoal((MobEntity)this), 1.0f);
        MobsHelper.getRandomizedGoals((MobEntity)this, this.isAboveNormalDifficulty() ? 2 : 1, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
    }

    private void setMarineDetails() {
        this.setTextures(MobsHelper.MARINE_TEXTURES);
    }

    private void setPirateDetails() {
        this.setTextures(MobsHelper.PIRATE_TEXTURES);
        if (this.field_70170_p.func_201674_k().nextInt(10) < 3) {
            this.getEntityStats().setRace("fishman");
            this.queueEntityDataUpdate();
            this.setTextures(MobsHelper.PIRATE_FISHMEN_TEXTURES);
        }
    }

    private void setBanditDetails() {
        this.setTextures(MobsHelper.BANDIT_TEXTURES);
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        if (!this.getEntityStats().isMarine()) {
            return false;
        }
        IEntityStats senderProps = EntityStatsCapability.get(commandSender);
        if (!senderProps.isMarine()) {
            return false;
        }
        return senderProps.hasMarineRank(FactionHelper.MarineRank.ADMIRAL);
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get(this.lastCommandSender).isRogue();
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }
}

