/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.HumandrillEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BellyFlopWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.SlamWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class AbstractGorillaEntity
extends CreatureEntity
implements IEntityAdditionalSpawnData {
    private float size;
    private static final float MIN_SIZE = 2.5f;
    private static final float MAX_SIZE = 3.5f;

    protected AbstractGorillaEntity(EntityType entity, World world) {
        super(entity, world);
        if (world != null && !world.field_72995_K) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, this.getRandomAxe(MobsHelper.GORILLA_AXES));
            double attackDamage = this.func_110148_a(Attributes.field_233823_f_).func_111125_b();
            double maxHealth = this.func_110148_a(Attributes.field_233818_a_).func_111125_b();
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(attackDamage + (double)(this.getSize() > 1.0f ? this.getSize() : 0.0f));
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth + (double)(this.getSize() * 10.0f));
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a((double)(0.0f + this.getSize() * 0.5f));
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setDoriki(1500.0 + WyHelper.randomWithRange(world.func_201674_k(), 0, 500));
            props.setBelly(0L);
            this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
            if (this.field_70146_Z.nextFloat() < 0.6f) {
                this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            }
            this.field_70714_bg.func_75776_a(0, (Goal)new ImprovedMeleeAttackGoal(this, 1.25, true));
            if (this.field_70146_Z.nextBoolean()) {
                this.field_70714_bg.func_75776_a(2, (Goal)new SlamWrapperGoal((MobEntity)this));
            } else {
                this.field_70714_bg.func_75776_a(2, (Goal)new BellyFlopWrapperGoal((MobEntity)this));
            }
            this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, OPEntity.class, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VillagerEntity.class, true));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, HumandrillEntity.class, true));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.size = Math.min(2.5f + this.field_70146_Z.nextFloat(), 3.5f);
    }

    public EntitySize func_213305_a(Pose pose) {
        float scale = this.getSize() / 1.3f;
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220313_a(scale);
        return newSize;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("size", this.size);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.size = compound.func_74760_g("size");
    }

    public ItemStack getRandomAxe(List<Supplier<? extends Item>> list) {
        return new ItemStack((IItemProvider)list.get(this.field_70146_Z.nextInt(list.size())).get());
    }

    public float getSize() {
        return this.size;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_219680_ht;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219673_hm;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.5f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? 0.5f + this.field_70146_Z.nextFloat() / 2.0f : 0.2f + this.field_70146_Z.nextFloat() / 3.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.size);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.size = buffer.readFloat();
    }
}

