/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.PersonalSpaceTargetGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BananawaniEntity
extends TameableEntity
implements ICommandReceiver {
    private static final DataParameter<Boolean> IS_SADDLED = EntityDataManager.func_187226_a(BananawaniEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SADDLE_COLOR = EntityDataManager.func_187226_a(BananawaniEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String SADDLED_TAG = "isSaddled";
    private static final String SADDLE_COLOR_TAG = "saddleColor";
    private static final double TAME_CHANCE = 0.25;
    private static final Food[] FISH_FOODS = new Food[]{Foods.field_221434_j, Foods.field_221420_H, Foods.field_221424_L, Foods.field_221437_m, Foods.field_221441_q, Foods.field_221415_C};
    private static final Item[] SADDLES = new Item[]{Items.field_151141_av};
    private static final byte BITE_EVENT = 100;
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;
    private long lastMountTime;
    private long lastBiteTime;
    private int clientBiteTime;

    public BananawaniEntity(EntityType type, World world) {
        super(type, world);
        this.func_70661_as().func_212239_d(true);
        if (world != null && !world.field_72995_K) {
            this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 40.0);
    }

    protected void func_184651_r() {
        CommandAbility.addCommandGoals((MobEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.15));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new PersonalSpaceTargetGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ChickenEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_SADDLED, (Object)false);
        this.func_184212_Q().func_187214_a(SADDLE_COLOR, (Object)DyeColor.RED.func_196059_a());
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a(SADDLED_TAG, ((Boolean)this.field_70180_af.func_187225_a(IS_SADDLED)).booleanValue());
        nbt.func_74768_a(SADDLE_COLOR_TAG, ((Integer)this.field_70180_af.func_187225_a(SADDLE_COLOR)).intValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)nbt.func_74767_n(SADDLED_TAG));
        this.field_70180_af.func_187227_b(SADDLE_COLOR, (Object)nbt.func_74762_e(SADDLE_COLOR_TAG));
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.5f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? 1.5f + this.field_70146_Z.nextFloat() / 2.0f : 1.25f + this.field_70146_Z.nextFloat() / 2.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184186_bw() && this.func_70090_H()) {
            double waterHeight = this.func_226278_cu_() - this.func_233571_b_((ITag)FluidTags.field_206959_a);
            double upforce = (this.func_226278_cu_() - waterHeight) / (double)this.func_213302_cg() - 0.35;
            Vector3d lookVec = this.func_70040_Z().func_216372_d(2.0, 1.0, 2.0);
            BlockPos frontPos = this.func_233580_cy_().func_177963_a(lookVec.field_72450_a, 0.0, lookVec.field_72449_c);
            BlockState state = this.field_70170_p.func_180495_p(frontPos);
            if (!state.func_196958_f() && state.func_204520_s().func_206888_e()) {
                upforce += 0.35;
            }
            if (upforce > 0.0) {
                double swimSpeed = this.func_233637_b_((Attribute)ForgeMod.SWIM_SPEED.get());
                Vector3d movement = this.func_213322_ci();
                this.func_213293_j(movement.field_72450_a * swimSpeed, (movement.field_72448_b + upforce * 0.061) * 0.75, movement.field_72449_c * swimSpeed);
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            boolean isDye;
            ItemStack stack = player.func_184586_b(player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND);
            boolean isSaddle = Arrays.stream(SADDLES).anyMatch(stack.func_77973_b()::equals);
            boolean bl = isDye = !stack.func_190926_b() && stack.func_77973_b() instanceof DyeItem;
            if (!this.func_70909_n()) {
                if (!stack.func_190926_b() && this.func_70877_b(stack)) {
                    this.func_175505_a(player, stack);
                    double chance = this.field_70146_Z.nextDouble();
                    if (chance < 0.25) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.func_193101_c(player);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else if (isDye) {
                DyeColor dyecolor = ((DyeItem)stack.func_77973_b()).func_195962_g();
                if (dyecolor != this.getSaddleColor()) {
                    this.setSaddleColor(dyecolor);
                    this.func_175505_a(player, stack);
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(4.0f);
                    this.func_175505_a(player, stack);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    return ActionResultType.SUCCESS;
                }
                if (isSaddle && !this.isSaddled() && !this.func_70631_g_()) {
                    this.setSaddled(true);
                    this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    this.func_175505_a(player, stack);
                    return ActionResultType.SUCCESS;
                }
                if ((!this.func_70877_b(stack) || this.func_70877_b(stack) && !this.func_204701_dC()) && player == this.func_70902_q() && !this.func_70631_g_()) {
                    player.func_184220_m((Entity)this);
                    this.lastMountTime = this.field_70170_p.func_82737_E();
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.1f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * 0.7f);
                    super.func_213352_e(new Vector3d((double)f, travelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(travelVector);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.clientBiteTime > 0) {
            --this.clientBiteTime;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70909_n() && this.func_184207_aI() && this.func_184188_bt().contains(this.func_70902_q()) && this.func_70902_q() != null && this.func_70902_q().field_82175_bq && this.field_70170_p.func_82737_E() >= this.lastMountTime + 20L && this.field_70170_p.func_82737_E() >= this.lastBiteTime + 20L) {
            this.func_184609_a(Hand.MAIN_HAND);
            Vector3d look = this.func_213303_ch().func_178787_e(this.func_70902_q().func_70040_Z().func_216372_d(4.0, 1.0, 4.0));
            Vector3d ogPos = new Vector3d(look.func_82615_a(), this.func_226278_cu_(), look.func_82616_c());
            List<Entity> targets = WyHelper.getNearbyLiving(ogPos, (IWorld)this.field_70170_p, 1.0, ModEntityPredicates.getEnemyFactions(this.func_70902_q()));
            targets.remove(this);
            targets.remove(this.func_70902_q());
            this.lastBiteTime = this.field_70170_p.func_82737_E();
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            for (Entity e : targets) {
                e.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
            }
        }
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos blockpos = new BlockPos(axisalignedbb.field_72340_a + 0.001, axisalignedbb.field_72338_b + 0.001, axisalignedbb.field_72339_c + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.field_72336_d - 0.001, axisalignedbb.field_72337_e - 0.001, axisalignedbb.field_72334_f - 0.001);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        if (this.field_70170_p.func_175707_a(blockpos, blockpos1)) {
            for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                        pos.func_181079_c(i, j, k);
                        BlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                        if (state.func_177230_c() != Blocks.field_196651_dG) continue;
                        this.field_70170_p.func_225521_a_((BlockPos)pos, true, (Entity)this);
                    }
                }
            }
        }
    }

    public void func_226292_a_(Hand hand, boolean updateSelf) {
        if (this.func_70638_az() != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
        }
        super.func_226292_a_(hand, updateSelf);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new AgeableEntity.AgeableData(0.2f);
        }
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.generateRandomHealth());
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a(this.generateRandomArmor());
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.generateRandomAttack());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.generateRandomSpeed());
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(this.generateRandomSwimSpeed());
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        BananawaniEntity offspring = (BananawaniEntity)((EntityType)ModEntities.BANANAWANI.get()).func_200721_a((World)world);
        this.setOffspringAttributes(mate, offspring);
        return offspring;
    }

    protected void setOffspringAttributes(AgeableEntity mate, BananawaniEntity offspring) {
        double hp = this.func_233638_c_(Attributes.field_233818_a_) + mate.func_233638_c_(Attributes.field_233818_a_) + this.generateRandomHealth();
        offspring.func_110148_a(Attributes.field_233818_a_).func_111128_a(hp / 3.0);
        double armor = this.func_233638_c_(Attributes.field_233826_i_) + mate.func_233638_c_(Attributes.field_233826_i_) + this.generateRandomArmor();
        offspring.func_110148_a(Attributes.field_233826_i_).func_111128_a(armor / 3.0);
        double speed = this.func_233638_c_(Attributes.field_233821_d_) + mate.func_233638_c_(Attributes.field_233821_d_) + this.generateRandomSpeed();
        offspring.func_110148_a(Attributes.field_233821_d_).func_111128_a(speed / 3.0);
        double damage = this.func_233638_c_(Attributes.field_233823_f_) + mate.func_233638_c_(Attributes.field_233823_f_) + this.generateRandomAttack();
        offspring.func_110148_a(Attributes.field_233823_f_).func_111128_a(damage / 3.0);
        double swimSpeed = this.func_233638_c_((Attribute)ForgeMod.SWIM_SPEED.get()) + mate.func_233638_c_((Attribute)ForgeMod.SWIM_SPEED.get()) + this.generateRandomSwimSpeed();
        offspring.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(swimSpeed / 3.0);
    }

    protected double generateRandomArmor() {
        return 2.0 + this.field_70146_Z.nextDouble() * 2.0;
    }

    protected double generateRandomAttack() {
        return 7.0 + this.field_70146_Z.nextDouble() * 2.0;
    }

    protected double generateRandomHealth() {
        return 50.0 + this.field_70146_Z.nextDouble() * 10.0;
    }

    protected double generateRandomSpeed() {
        return 0.25 + this.field_70146_Z.nextDouble() * 0.07;
    }

    protected double generateRandomSwimSpeed() {
        return 1.0 + this.field_70146_Z.nextDouble() * 0.15;
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && distance > 1024.0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Food food = stack.func_77973_b().func_219967_s();
        if (food == null) return false;
        if (food.func_221467_c()) return true;
        if (!Arrays.stream(FISH_FOODS).anyMatch(food::equals)) return false;
        return true;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.isSaddled();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.clientBiteTime = 20;
            }
        }
        super.func_70103_a(id);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public double func_70042_X() {
        return 1.4;
    }

    public void setSaddled(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)flag);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SADDLED);
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        return this.func_152114_e(commandSender);
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    public DyeColor getSaddleColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(SADDLE_COLOR)));
    }

    public void setSaddleColor(DyeColor pCollarColor) {
        this.field_70180_af.func_187227_b(SADDLE_COLOR, (Object)pCollarColor.func_196059_a());
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBiteAnimationProgress(float partialTicks) {
        return ((float)(20 - this.clientBiteTime) + partialTicks) / 20.0f;
    }
}

