/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.IRandomTexture;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class DenDenMushiEntity
extends AnimalEntity
implements IRandomTexture {
    private static final DataParameter<Integer> TEXTURE_ID = EntityDataManager.func_187226_a(DenDenMushiEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public DenDenMushiEntity(EntityType type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.75));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE_ID, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.12f).func_233815_a_(Attributes.field_233818_a_, 5.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.setTexture(this.field_70146_Z.nextInt(MobsHelper.DEN_DEN_MUSHI_TEXTURES.length));
        return spawnData;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151042_j) {
            ItemStack denStack = new ItemStack((IItemProvider)ModBlocks.DEN_DEN_MUSHI.get());
            denStack.func_196082_o().func_74768_a("type", this.getTextureId());
            player.field_71071_by.func_70441_a(denStack);
            stack.func_190918_g(1);
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Texture", this.getTextureId());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setTexture(nbt.func_74762_e("Texture"));
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    public int getTextureId() {
        return (Integer)this.func_184212_Q().func_187225_a(TEXTURE_ID);
    }

    protected void setTexture(int texture) {
        this.func_184212_Q().func_187227_b(TEXTURE_ID, (Object)texture);
    }

    @Override
    public ResourceLocation getCurrentTexture() {
        return MobsHelper.DEN_DEN_MUSHI_TEXTURES[this.getTextureId()];
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return MobsHelper.DEN_DEN_MUSHI_TEXTURES[0];
    }
}

