/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.FishSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.LandFishLookController;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.AvoidBlockGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.BreakBoatGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FightingFishEntity
extends WaterMobEntity
implements IMob {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(FightingFishEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final EntityPredicate TARGET_PREDICATE = new EntityPredicate().func_221013_a(20.0).func_221011_b().func_221008_a();
    private static final List<RegistryKey<Biome>> SPAWN_BIOMES = new ArrayList<RegistryKey>(Arrays.asList(Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_203615_U, Biomes.field_203618_X, Biomes.field_203614_T, Biomes.field_203617_W));

    public FightingFishEntity(EntityType type, World world) {
        super(type, world);
        this.field_70765_h = new FishSwimMoveController<FightingFishEntity>(this);
        this.field_70749_g = new LandFishLookController<FightingFishEntity>(this, 10);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidBlockGoal((CreatureEntity)this, (Set<Block>)ImmutableSet.of((Object)Blocks.field_205165_jY, (Object)ModBlocks.KAIROSEKI.get())));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.8f, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreakBoatGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, YagaraBullEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)1.2f).func_233815_a_(Attributes.field_233819_b_, 55.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233818_a_, 40.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        float size = 0.2f + this.field_70146_Z.nextFloat();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(Math.min(size, 1.0f)));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        this.field_70125_A = 0.0f;
        double r = WyHelper.randomWithRange(this.field_70146_Z, 0, 64);
        if (r == 0.0) {
            this.func_200203_b((ITextComponent)new StringTextComponent("Timmy"));
        }
        double reach = (1.0f - this.getSize()) * 30.0f;
        this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(-reach);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.func_233637_b_(Attributes.field_233818_a_) * Math.max((double)this.getSize(), 0.5));
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setDoriki(1500.0f + this.getSize() * 1000.0f);
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void func_209207_l(int air) {
        super.func_209207_l(air);
        if (WyHelper.isAprilFirst()) {
            this.func_70050_g(300);
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74776_a("size", ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(nbt.func_74760_g("size")));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public EntitySize func_213305_a(Pose pose) {
        float fishScale = this.getSize();
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220313_a(fishScale);
        return newSize;
    }

    public float getSize() {
        return ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue();
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    protected PathNavigator func_175447_b(World level) {
        if (WyHelper.isAprilFirst()) {
            return super.func_175447_b(level);
        }
        return new SwimmerPathNavigator((MobEntity)this, level);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && !this.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.01, 0.0));
        }
    }

    public void func_213352_e(Vector3d pTravelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), pTravelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(pTravelVector);
        }
    }

    public static boolean checkSpawnRules(EntityType<FightingFishEntity> entity, IWorld world, SpawnReason spawnType, BlockPos pos, Random random) {
        if (WyHelper.isAprilFirst()) {
            return MobEntity.func_223315_a(entity, (IWorld)world, (SpawnReason)spawnType, (BlockPos)pos, (Random)random);
        }
        if (pos.func_177956_o() >= world.func_181545_F() - 10) {
            return false;
        }
        return world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_184652_a(PlayerEntity pPlayer) {
        return true;
    }
}

