/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.LapahnEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.PersonalSpaceTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.GapCloserGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.TackleWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.HiryuKaenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.ShiShishiSonsonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.YakkodoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HumandrillEntity
extends CreatureEntity
implements IEntityAdditionalSpawnData {
    protected static final List<Supplier<? extends Item>> SWORDS = Arrays.asList(ModWeapons.MARINE_SWORD, () -> Items.field_151040_l, () -> Items.field_151052_q, ModWeapons.SANDAI_KITETSU, ModWeapons.NIDAI_KITETSU, ModWeapons.WADO_ICHIMONJI, () -> Items.field_151048_u);
    private float size;
    private static final float MIN_SIZE = 0.8f;
    private static final float MAX_SIZE = 2.0f;

    public HumandrillEntity(EntityType type, World world) {
        super(type, world);
        if (world != null && !world.field_72995_K) {
            boolean hasSword = false;
            if (this.func_70681_au().nextDouble() < 0.7) {
                ItemStack randomSword;
                if (this.field_70146_Z.nextDouble() < 0.9) {
                    randomSword = new ItemStack((IItemProvider)SWORDS.get(this.field_70146_Z.nextInt(SWORDS.size())).get());
                } else {
                    this.size = 2.5f;
                    randomSword = new ItemStack((IItemProvider)ModWeapons.YORU.get());
                }
                randomSword.func_196082_o().func_74757_a("isClone", true);
                this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
                hasSword = true;
            }
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)(3.0f + (this.getSize() > 1.0f ? this.getSize() : 0.0f)));
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(60.0f + this.getSize() * 10.0f));
            this.func_110148_a(Attributes.field_233820_c_).func_111128_a((double)(this.getSize() * 0.2f));
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a((double)(1.2f + this.getSize() * 0.5f));
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setDoriki(1500.0 + WyHelper.randomWithRange(300, 600));
            props.setBelly(0L);
            this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
            if (this.field_70146_Z.nextFloat() < 0.6f) {
                this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            }
            this.field_70714_bg.func_75776_a(0, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
            this.field_70714_bg.func_75776_a(2, (Goal)new GapCloserGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AnimalEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, HumandrillEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(1, (Goal)new PersonalSpaceTargetGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LapahnEntity.class, true));
            if (hasSword) {
                WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
                goals.addEntry(() -> new HiryuKaenWrapperGoal((MobEntity)this), 4.0f);
                goals.addEntry(() -> new ShiShishiSonsonWrapperGoal((MobEntity)this), 3.0f);
                goals.addEntry(() -> new YakkodoriWrapperGoal((MobEntity)this), 1.0f);
                MobsHelper.getRandomizedGoals((MobEntity)this, 2, goals).forEach(goal -> this.field_70714_bg.func_75776_a(3, goal));
            } else {
                WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
                goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this), 4.0f);
                goals.addEntry(() -> new TackleWrapperGoal((MobEntity)this), 2.0f);
                goals.addEntry(() -> new SuplexWrapperGoal((MobEntity)this), 1.0f);
                MobsHelper.getRandomizedGoals((MobEntity)this, 2, goals).forEach(goal -> this.field_70714_bg.func_75776_a(3, goal));
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 80.0).func_233815_a_((Attribute)ModAttributes.FALL_RESISTANCE.get(), 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.27f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.size = Math.min(0.8f + this.field_70146_Z.nextFloat(), 2.0f);
    }

    public EntitySize func_213305_a(Pose pose) {
        float scale = this.getSize();
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220313_a(scale);
        return newSize;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("size", this.size);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.size = compound.func_74760_g("size");
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_219680_ht;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219673_hm;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.5f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? 0.5f + this.field_70146_Z.nextFloat() / 2.0f : 0.2f + this.field_70146_Z.nextFloat() / 3.0f;
    }

    public float getSize() {
        return this.size;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.size);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.size = buffer.readFloat();
    }
}

