/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.LeapAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.HumandrillEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.PersonalSpaceTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.LeapWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.lapahn.LapahnChaseGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.lapahn.LapahnRageGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.lapahn.LapahnRestGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LapahnEntity
extends CreatureEntity {
    private static final UUID LEAP_COOLDOWN_BONUS_UUID = UUID.fromString("5711f1b8-d776-44fb-9cd7-afdbd51a9837");
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(LapahnEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final int JUMP_ANIM_CYCLE = 20;
    private static final byte JUMP_EVENT = 100;
    private int clientJumpTick = 0;
    private int jumpTick = 0;

    public LapahnEntity(EntityType type, World world) {
        super(type, world);
        if (world != null && !world.field_72995_K) {
            LeapWrapperGoal leapWrapper = new LeapWrapperGoal((MobEntity)this);
            ((LeapAbility)leapWrapper.getAbility()).setLeapHeight(0.4);
            ((LeapAbility)leapWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(LEAP_COOLDOWN_BONUS_UUID, "Leap Cooldown Bonus", BonusOperation.MUL, 0.5f));
            this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new LapahnChaseGoal(this));
            this.field_70714_bg.func_75776_a(0, (Goal)new LapahnRageGoal(this));
            this.field_70714_bg.func_75776_a(0, (Goal)new LapahnRestGoal(this));
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
            this.field_70714_bg.func_75776_a(1, (Goal)leapWrapper);
            this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, RabbitEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(1, (Goal)new PersonalSpaceTargetGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, HumandrillEntity.class, true));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 55.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233818_a_, 60.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientJumpTick > 0) {
                --this.clientJumpTick;
            }
        } else if (this.isIdling() && --this.jumpTick <= 0 && this.func_233570_aj_()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            this.func_70683_ar().func_75660_a();
            this.func_184185_a(SoundEvents.field_190030_ev, 0.2f, 0.5f);
            this.jumpTick = 20;
        }
    }

    public List<LapahnEntity> getNearbyLapahns() {
        List<LapahnEntity> targets = WyHelper.getNearbyLiving(this.func_213303_ch(), (IWorld)this.field_70170_p, 16.0, LapahnEntity.class::isInstance);
        targets.remove((Object)this);
        return targets;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.clientJumpTick = 20;
            }
        }
        super.func_70103_a(id);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setDoriki(1000.0 + WyHelper.randomWithRange(0, 500));
        props.setBelly(0L);
        return spawnData;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("isEnraged", this.isEnraged());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setEnraged(nbt.func_74767_n("isEnraged"));
    }

    public void setEnraged(boolean set) {
        this.setFlag(0, set);
    }

    public void setChasing(boolean flag) {
        this.setFlag(1, flag);
        if (flag) {
            this.setResting(false);
        }
    }

    public void setResting(boolean flag) {
        this.setFlag(2, flag);
    }

    private void setFlag(int flag, boolean set) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        if (set) {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)(b0 | 1 << flag)));
        } else {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)(b0 & ~(1 << flag))));
        }
    }

    private boolean getFlag(int id) {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 1 << id) != 0;
    }

    public boolean isIdling() {
        return !this.isResting() && !this.isChasing();
    }

    public boolean isEnraged() {
        return this.getFlag(0);
    }

    public boolean isChasing() {
        return this.getFlag(1);
    }

    public boolean isResting() {
        return this.getFlag(2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpAnimationProgress(float partialTicks) {
        return ((float)(20 - this.clientJumpTick) + partialTicks) / 20.0f;
    }
}

