/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.FishSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.LandFishLookController;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.AvoidBlockGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.EatNearbyFishGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PandaSharkEntity
extends WaterMobEntity
implements IMob,
IEntityAdditionalSpawnData {
    private static final List<RegistryKey<Biome>> SPAWN_BIOMES = new ArrayList<RegistryKey>(Arrays.asList(Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_203615_U, Biomes.field_203618_X, Biomes.field_203614_T, Biomes.field_203617_W));
    private float size = 1.0f;

    public PandaSharkEntity(EntityType type, World world) {
        super(type, world);
        this.field_70765_h = new FishSwimMoveController<PandaSharkEntity>(this);
        this.field_70749_g = new LandFishLookController<PandaSharkEntity>(this, 10);
        if (world != null && !world.field_72995_K) {
            this.size = 1.0f + this.field_70146_Z.nextFloat();
            double reach = (1.0f - this.size) * 30.0f;
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(-reach);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.func_233637_b_(Attributes.field_233818_a_) * Math.max((double)this.size, 0.5));
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidBlockGoal((CreatureEntity)this, (Set<Block>)ImmutableSet.of((Object)Blocks.field_205165_jY, (Object)ModBlocks.KAIROSEKI.get())));
        this.field_70714_bg.func_75776_a(0, (Goal)new EatNearbyFishGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.8f, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)1.3f).func_233815_a_(Attributes.field_233819_b_, 55.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    public EntitySize func_213305_a(Pose pose) {
        float fishScale = this.getSize();
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220313_a(fishScale);
        return newSize;
    }

    public float getSize() {
        return this.size;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_184652_a(PlayerEntity pPlayer) {
        return true;
    }

    protected PathNavigator func_175447_b(World level) {
        if (WyHelper.isAprilFirst()) {
            return super.func_175447_b(level);
        }
        return new SwimmerPathNavigator((MobEntity)this, level);
    }

    public void func_213352_e(Vector3d moveVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), moveVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(moveVector);
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74776_a("size", this.size);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.size = nbt.func_74760_g("size");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.size);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.size = buffer.readFloat();
    }

    public static boolean checkSpawnRules(EntityType<PandaSharkEntity> entity, IWorld world, SpawnReason spawnType, BlockPos pos, Random random) {
        if (pos.func_177956_o() >= world.func_181545_F() - 10) {
            return false;
        }
        return world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

