/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.entities.GoalMemories;
import xyz.pixelatedw.mineminenomi.api.entities.IGoalMemoriesEntity;
import xyz.pixelatedw.mineminenomi.containers.WhiteWalkieStorageContainer;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.whitewalkie.WhiteWalkieSleepGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WhiteWalkieEntity
extends TameableEntity
implements IInventoryChangedListener,
IGoalMemoriesEntity {
    private static final TranslationTextComponent CONTAINER_TITLE = new TranslationTextComponent(ModI18n.CONTAINER_WHITE_WALKIE_STORAGE);
    private static final DataParameter<Byte> FLAGS = EntityDataManager.func_187226_a(WhiteWalkieEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> CHESTS = EntityDataManager.func_187226_a(WhiteWalkieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double TAME_CHANCE = 0.35;
    private static final Item[] SADDLES = new Item[]{Items.field_151141_av};
    private static final byte BITE_EVENT = 100;
    private static final byte SHAKE_EVENT = 101;
    private final GoalMemories goalMemories = new GoalMemories();
    private Inventory inventory;
    private int currentInvPage;
    private long lastMountTime;
    private long lastBiteTime;
    private long lastShakeTime;
    private int clientBiteTime;
    private int clientShakeTime;

    public WhiteWalkieEntity(EntityType type, World world) {
        super(type, world);
        this.createInventory();
        if (world != null && !world.field_72995_K) {
            this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 40.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new WhiteWalkieSleepGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.15));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FLAGS, (Object)0);
        this.func_184212_Q().func_187214_a(CHESTS, (Object)0);
    }

    protected void createInventory() {
        Inventory inventory = this.inventory;
        this.inventory = new Inventory(this.getInventorySize());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.field_70170_p.field_72995_K) {
            this.setFlag(4, !this.inventory.func_70301_a(0).func_190926_b());
        }
    }

    public void openInventory(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)player)) && this.func_70909_n()) {
            SimpleNamedContainerProvider containerProvider = new SimpleNamedContainerProvider((id, inv, playerEntity) -> new WhiteWalkieStorageContainer(id, inv, (IInventory)this.inventory, this), (ITextComponent)CONTAINER_TITLE);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, buf -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("entity", this.func_145782_y());
                nbt.func_74768_a("inventorySize", this.inventory.func_70302_i_());
                nbt.func_74768_a("pageSize", this.getInventoryPageSize());
                buf.func_150786_a(nbt);
            });
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("IsSleeping", this.func_70608_bn());
        nbt.func_74768_a("Chests", this.getChests());
        if (!this.inventory.func_70301_a(0).func_190926_b()) {
            nbt.func_218657_a("SaddleItem", (INBT)this.inventory.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
        if (this.hasChest()) {
            ListNBT listnbt = new ListNBT();
            for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(compoundnbt);
                listnbt.add((Object)compoundnbt);
            }
            nbt.func_218657_a("Items", (INBT)listnbt);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        ItemStack itemstack;
        super.func_70037_a(nbt);
        this.setSleeping(nbt.func_74767_n("IsSleeping"));
        this.setChest(nbt.func_74762_e("Chests"));
        if (nbt.func_150297_b("SaddleItem", 10) && (itemstack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("SaddleItem"))) != null && !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151141_av) {
            this.setSaddled(itemstack);
        }
        if (this.hasChest()) {
            ListNBT listnbt = nbt.func_150295_c("Items", 10);
            this.createInventory();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                if (j < 1 || j >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
            }
        }
        this.updateContainerEquipment();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND);
            boolean isSaddle = Arrays.stream(SADDLES).anyMatch(stack.func_77973_b()::equals);
            if (!this.func_70909_n()) {
                if (!stack.func_190926_b() && this.func_70877_b(stack)) {
                    this.func_175505_a(player, stack);
                    double chance = this.field_70146_Z.nextDouble();
                    if (chance < 0.35) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.func_193101_c(player);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (player.func_226563_dT_()) {
                    this.openInventory(player);
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
                if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_175505_a(player, stack);
                    this.func_70691_i(4.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    return ActionResultType.SUCCESS;
                }
                if (isSaddle && !this.isSaddled() && !this.func_70631_g_()) {
                    this.setSaddled(stack.func_77946_l());
                    this.func_175505_a(player, stack);
                    this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77973_b() == Blocks.field_150486_ae.func_199767_j() && !this.func_70631_g_() && this.getChests() < 2) {
                    this.setChest(this.getChests() + 1);
                    this.createInventory();
                    this.func_175505_a(player, stack);
                    return ActionResultType.SUCCESS;
                }
                if ((!this.func_70877_b(stack) || this.func_70877_b(stack) && !this.func_204701_dC()) && player == this.func_70902_q() && !this.func_70631_g_()) {
                    player.func_184220_m((Entity)this);
                    this.lastMountTime = this.field_70170_p.func_82737_E();
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213352_e(Vector3d pTravelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.3f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * 0.7f);
                    super.func_213352_e(new Vector3d((double)f, pTravelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(pTravelVector);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.clientShakeTime > 0) {
            --this.clientShakeTime;
        }
        if (this.clientBiteTime > 0) {
            --this.clientBiteTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70909_n() && this.func_184207_aI() && this.func_184188_bt().contains(this.func_70902_q()) && this.func_70902_q() != null && this.func_70902_q().field_82175_bq && this.field_70170_p.func_82737_E() >= this.lastMountTime + 20L && this.field_70170_p.func_82737_E() >= this.lastBiteTime + 20L) {
                this.func_184609_a(Hand.MAIN_HAND);
                Vector3d look = this.func_213303_ch().func_178787_e(this.func_70902_q().func_70040_Z().func_216372_d(4.0, 1.0, 4.0));
                Vector3d ogPos = new Vector3d(look.func_82615_a(), this.func_226278_cu_(), look.func_82616_c());
                List<Entity> targets = WyHelper.getNearbyLiving(ogPos, (IWorld)this.field_70170_p, 1.0, ModEntityPredicates.getEnemyFactions(this.func_70902_q()));
                targets.remove(this);
                targets.remove(this.func_70902_q());
                this.lastBiteTime = this.field_70170_p.func_82737_E();
                this.field_70170_p.func_72960_a((Entity)this, (byte)100);
                for (Entity e : targets) {
                    e.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
                }
            }
            if (this.lastShakeTime <= 0L) {
                this.lastShakeTime = this.field_70170_p.func_82737_E();
            }
            if (this.field_70170_p.func_82737_E() >= this.lastShakeTime + 1200L && !this.func_184207_aI()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)101);
                this.lastShakeTime = this.field_70170_p.func_82737_E();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_70619_bc() {
        this.goalMemories.tick();
    }

    public void func_226292_a_(Hand hand, boolean updateSelf) {
        if (this.func_70638_az() != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
        }
        super.func_226292_a_(hand, updateSelf);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.5f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? 1.5f + this.field_70146_Z.nextFloat() / 2.0f : 1.25f + this.field_70146_Z.nextFloat() / 2.0f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new AgeableEntity.AgeableData(0.2f);
        }
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.generateRandomHealth());
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a(this.generateRandomArmor());
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.generateRandomAttack());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.generateRandomSpeed());
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        WhiteWalkieEntity offspring = (WhiteWalkieEntity)((EntityType)ModEntities.WHITE_WALKIE.get()).func_200721_a((World)world);
        this.setOffspringAttributes(mate, offspring);
        return offspring;
    }

    protected void setOffspringAttributes(AgeableEntity mate, WhiteWalkieEntity offspring) {
        double hp = this.func_233638_c_(Attributes.field_233818_a_) + mate.func_233638_c_(Attributes.field_233818_a_) + this.generateRandomHealth();
        offspring.func_110148_a(Attributes.field_233818_a_).func_111128_a(hp / 3.0);
        double armor = this.func_233638_c_(Attributes.field_233826_i_) + mate.func_233638_c_(Attributes.field_233826_i_) + this.generateRandomArmor();
        offspring.func_110148_a(Attributes.field_233826_i_).func_111128_a(armor / 3.0);
        double speed = this.func_233638_c_(Attributes.field_233821_d_) + mate.func_233638_c_(Attributes.field_233821_d_) + this.generateRandomSpeed();
        offspring.func_110148_a(Attributes.field_233821_d_).func_111128_a(speed / 3.0);
        double damage = this.func_233638_c_(Attributes.field_233823_f_) + mate.func_233638_c_(Attributes.field_233823_f_) + this.generateRandomAttack();
        offspring.func_110148_a(Attributes.field_233823_f_).func_111128_a(damage / 3.0);
    }

    protected double generateRandomArmor() {
        return 1.0 + this.field_70146_Z.nextDouble() * 2.5;
    }

    protected double generateRandomAttack() {
        return 5.0 + this.field_70146_Z.nextDouble() * 2.0;
    }

    protected double generateRandomHealth() {
        return 50.0 + this.field_70146_Z.nextDouble() * 10.0;
    }

    protected double generateRandomSpeed() {
        return (double)0.23f + this.field_70146_Z.nextDouble() * 0.05;
    }

    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Food food = stack.func_77973_b().func_219967_s();
        return food != null && food.func_221467_c();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.isSaddled();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.clientBiteTime = 20;
                break;
            }
            case 101: {
                this.clientShakeTime = 40;
                break;
            }
        }
        super.func_70103_a(id);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public double func_70042_X() {
        return 1.7;
    }

    public void func_76316_a(IInventory inv) {
        ItemStack stack = this.inventory.func_70301_a(0);
        boolean flag = stack != null && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151141_av;
        this.setFlag(0, flag);
        this.updateContainerEquipment();
        if (this.field_70173_aa > 20 && !flag && this.isSaddled()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    protected int getInventorySize() {
        return 3 + (this.hasChest() ? this.getInventoryPageSize() * this.getInventoryMaxPage() : 0);
    }

    public int getInventoryColumns() {
        return 5;
    }

    public int getInventoryPageSize() {
        return 15;
    }

    public void setInventoryPage(int page) {
        this.currentInvPage = page;
    }

    public int getInventoryPage() {
        return this.currentInvPage;
    }

    public int getInventoryMaxPage() {
        return 2;
    }

    public boolean func_174820_d(int pSlotIndex, ItemStack pStack) {
        return super.func_174820_d(pSlotIndex, pStack);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
        if (this.hasChest()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_199703_a((IItemProvider)Blocks.field_150486_ae);
            }
            this.setChest(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBiteAnimationProgress(float partialTicks) {
        return ((float)(20 - this.clientBiteTime) + partialTicks) / 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAnimationTime() {
        return this.clientShakeTime;
    }

    public void setSaddled(@Nullable ItemStack stack) {
        boolean flag = true;
        if (stack == null) {
            stack = ItemStack.field_190927_a;
            flag = false;
        }
        this.inventory.func_70299_a(0, stack);
        this.setFlag(0, flag);
    }

    public void setSleeping(boolean flag) {
        this.setFlag(1, flag);
    }

    public void setChest(int chests) {
        this.func_184212_Q().func_187227_b(CHESTS, (Object)chests);
    }

    private void setFlag(int flag, boolean set) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        if (set) {
            this.field_70180_af.func_187227_b(FLAGS, (Object)((byte)(b0 | 1 << flag)));
        } else {
            this.field_70180_af.func_187227_b(FLAGS, (Object)((byte)(b0 & ~(1 << flag))));
        }
    }

    private boolean getFlag(int id) {
        return ((Byte)this.field_70180_af.func_187225_a(FLAGS) & 1 << id) != 0;
    }

    public boolean isIdling() {
        return !this.func_70608_bn() && !this.func_184207_aI();
    }

    public boolean isSaddled() {
        ItemStack stack = this.inventory.func_70301_a(0);
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151141_av || this.getFlag(0);
    }

    public boolean func_70608_bn() {
        return this.getFlag(1);
    }

    public boolean hasChest() {
        return this.getChests() > 0;
    }

    public int getChests() {
        return (Integer)this.func_184212_Q().func_187225_a(CHESTS);
    }

    @Override
    public GoalMemories getGoalMemories() {
        return this.goalMemories;
    }
}

