/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.IRandomTexture;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class YagaraBullEntity
extends TameableEntity
implements IRandomTexture {
    private static final DataParameter<Boolean> IS_SADDLED = EntityDataManager.func_187226_a(YagaraBullEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TEXTURE_ID = EntityDataManager.func_187226_a(YagaraBullEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double TAME_CHANCE = 0.35;
    private static final Item[] SADDLES = new Item[]{Items.field_151141_av};
    private static final Item[] TAMING_FOOD = new Item[]{Items.field_196088_aY, Items.field_221600_aB, Items.field_221601_aC};
    private static final Item[] FOOD = new Item[]{Items.field_196102_ba, Items.field_196104_bb, Items.field_196086_aW, Items.field_196087_aX, Items.field_196089_aZ, Items.field_196088_aY};
    private Status status;
    private Status oldStatus;
    private double waterLevel;

    public YagaraBullEntity(EntityType type, World world) {
        super(type, world);
        this.func_70661_as().func_212239_d(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.5, 20));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196088_aY}), true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_SADDLED, (Object)false);
        this.func_184212_Q().func_187214_a(TEXTURE_ID, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233818_a_, 30.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70071_h_() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        super.func_70071_h_();
        if (this.func_184186_bw()) {
            double d1 = this.func_189652_ae() ? 0.0 : (double)-0.005f;
            double d2 = 0.0;
            float invFriction = 0.05f;
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_226278_cu_()) / (double)this.func_213302_cg();
                invFriction = (float)this.func_233637_b_((Attribute)ForgeMod.SWIM_SPEED.get());
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                invFriction = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                invFriction = 0.9f;
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)invFriction, vector3d.field_72448_b + d1, vector3d.field_72449_c * (double)invFriction);
            if (d2 > 0.0) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213293_j(vector3d1.field_72450_a, (vector3d1.field_72448_b + d2 * 0.06153846016296973) * 0.75, vector3d1.field_72449_c);
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos blockpos = new BlockPos(axisalignedbb.field_72340_a + 0.001, axisalignedbb.field_72338_b + 0.001, axisalignedbb.field_72339_c + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.field_72336_d - 0.001, axisalignedbb.field_72337_e - 0.001, axisalignedbb.field_72334_f - 0.001);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        if (this.field_70170_p.func_175707_a(blockpos, blockpos1)) {
            for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                        pos.func_181079_c(i, j, k);
                        BlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                        if (state.func_177230_c() != Blocks.field_196651_dG) continue;
                        this.field_70170_p.func_225521_a_((BlockPos)pos, true, (Entity)this);
                    }
                }
            }
        }
    }

    public void func_213352_e(Vector3d pTravelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.3f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                    super.func_213352_e(new Vector3d((double)f, pTravelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(pTravelVector);
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (spawnData == null) {
            spawnData = new AgeableEntity.AgeableData(0.2f);
        }
        this.setTexture(this.field_70146_Z.nextInt(MobsHelper.YAGARA_BULL_TEXTURES.length));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.generateRandomHealth());
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(this.generateRandomSwimSpeed());
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        YagaraBullEntity offspring = (YagaraBullEntity)((EntityType)ModEntities.YAGARA_BULL.get()).func_200721_a((World)world);
        this.setOffspringAttributes(mate, offspring);
        return offspring;
    }

    protected void setOffspringAttributes(AgeableEntity mate, YagaraBullEntity offspring) {
        double hp = this.func_233638_c_(Attributes.field_233818_a_) + mate.func_233638_c_(Attributes.field_233818_a_) + this.generateRandomHealth();
        offspring.func_110148_a(Attributes.field_233818_a_).func_111128_a(hp / 3.0);
        double swimSpeed = this.func_233638_c_((Attribute)ForgeMod.SWIM_SPEED.get()) + mate.func_233638_c_((Attribute)ForgeMod.SWIM_SPEED.get()) + this.generateRandomSwimSpeed();
        offspring.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(swimSpeed / 3.0);
    }

    protected double generateRandomHealth() {
        return 30.0 + this.field_70146_Z.nextDouble() * 10.0;
    }

    protected double generateRandomSwimSpeed() {
        return 1.1 + this.field_70146_Z.nextDouble() * 0.15;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.isSaddled();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack;
        if (player.field_70170_p.field_72995_K || hand != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        if (this.func_70909_n() && player == this.func_70902_q()) {
            ItemStack stack2 = player.func_184614_ca();
            if (!stack2.func_190926_b()) {
                boolean isFood = Arrays.stream(FOOD).anyMatch(stack2.func_77973_b()::equals);
                boolean isSaddle = Arrays.stream(SADDLES).anyMatch(stack2.func_77973_b()::equals);
                if (isFood && this.func_110143_aJ() < this.func_110138_aP()) {
                    stack2.func_190918_g(1);
                    this.func_70691_i(4.0f);
                    this.spawnHeartParticles();
                    return ActionResultType.SUCCESS;
                }
                if (isSaddle && !this.isSaddled()) {
                    this.setSaddled(true);
                    this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    stack2.func_190918_g(1);
                }
            } else {
                player.func_184220_m((Entity)this);
            }
        } else if (!this.func_70909_n() && !(stack = player.func_184614_ca()).func_190926_b()) {
            boolean isFood = Arrays.stream(TAMING_FOOD).anyMatch(stack.func_77973_b()::equals);
            if (isFood) {
                stack.func_190918_g(1);
                double chance = this.field_70146_Z.nextDouble();
                if (chance < 0.35) {
                    this.spawnHeartParticles();
                    this.func_193101_c(player);
                }
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Texture", this.getTextureId());
        nbt.func_74757_a("IsSaddled", ((Boolean)this.field_70180_af.func_187225_a(IS_SADDLED)).booleanValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setTexture(nbt.func_74762_e("Texture"));
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)nbt.func_74767_n("IsSaddled"));
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return 0.6;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && distance > 1024.0;
    }

    public void spawnHeartParticles() {
        for (int i = 0; i < 5; ++i) {
            double offsetX = WyHelper.randomDouble() / 2.0;
            double offsetY = WyHelper.randomDouble() / 2.0;
            double offsetZ = WyHelper.randomDouble() / 2.0;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.0 + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void setSaddled(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)flag);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SADDLED);
    }

    public int getTextureId() {
        return (Integer)this.func_184212_Q().func_187225_a(TEXTURE_ID);
    }

    protected void setTexture(int texture) {
        this.func_184212_Q().func_187227_b(TEXTURE_ID, (Object)texture);
    }

    @Override
    public ResourceLocation getCurrentTexture() {
        return MobsHelper.YAGARA_BULL_TEXTURES[this.getTextureId()];
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return MobsHelper.YAGARA_BULL_TEXTURES[0];
    }

    @Nullable
    private Status isUnderwater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.002;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    public float getGroundFriction() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private Status getStatus() {
        Status status = this.isUnderwater();
        if (status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public static boolean checkSpawnRules(EntityType<YagaraBullEntity> entity, IWorld world, SpawnReason spawnType, BlockPos pos, Random random) {
        return world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

